/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.modintegration.theoneprobe;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IElementFactory;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.apiimpl.client.ElementTextRender;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import shetiphian.endertanks.common.block.BlockEnderTank;
import shetiphian.endertanks.common.misc.TankInfoHelper;
import shetiphian.endertanks.common.tileentity.TileEntityEnderTank;

public class OneProbeDataProvider
implements IProbeInfoProvider {
    static final OneProbeDataProvider INSTANCE = new OneProbeDataProvider();
    private static final ResourceLocation INFO_PROVIDER_ID = new ResourceLocation("endertanks", "default");
    private static final ResourceLocation ELEMENT_ID = new ResourceLocation("endertanks", "element");

    public ResourceLocation getID() {
        return INFO_PROVIDER_ID;
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
        BlockEntity tile;
        if (blockState.m_60734_() instanceof BlockEnderTank && (tile = world.m_7702_(data.getPos())) instanceof TileEntityEnderTank) {
            probeInfo.element((IElement)new ElementTankInfo((TileEntityEnderTank)tile));
        }
    }

    private static class ElementTankInfo
    implements IElement {
        final CompoundTag data;
        final List<String> lines = new ArrayList<String>();

        private ElementTankInfo(TileEntityEnderTank tank) {
            List<String> contents = tank.getEnderContainer().getContentsInfo();
            TankInfoHelper.getHUDInfo(this.lines, tank.getOwnerName(), tank.getCode(), tank.getPumpCapacity(), contents);
            this.data = new CompoundTag();
            this.data.m_128359_("owner", tank.getOwnerName());
            this.data.m_128359_("code", tank.getCode());
            this.data.m_128405_("pump", tank.getPumpCapacity());
            ListTag listNBT = new ListTag();
            for (String entry : contents) {
                listNBT.add((Object)StringTag.m_129297_((String)entry));
            }
            this.data.m_128365_("contents", (Tag)listNBT);
        }

        private ElementTankInfo(CompoundTag data) {
            if (data == null || data.m_128456_()) {
                this.data = new CompoundTag();
                return;
            }
            this.data = data;
            ArrayList<String> contents = new ArrayList<String>();
            ListTag listNBT = data.m_128437_("contents", 8);
            for (int index = 0; index < listNBT.size(); ++index) {
                contents.add(listNBT.m_128778_(index));
            }
            TankInfoHelper.getHUDInfo(this.lines, data.m_128461_("owner"), data.m_128461_("code"), data.m_128451_("pump"), contents);
        }

        public void render(PoseStack matrixStack, int x, int y) {
            for (String line : this.lines) {
                ElementTextRender.render((Component)new TextComponent(line), (PoseStack)matrixStack, (int)x, (int)y);
                y += 10;
            }
        }

        public int getWidth() {
            int width = 0;
            for (String line : this.lines) {
                width = Math.max(width, ElementTextRender.getWidth((Component)new TextComponent(line)));
            }
            return width;
        }

        public int getHeight() {
            return 10 + (this.lines.size() - 1) * 10;
        }

        public void toBytes(FriendlyByteBuf buffer) {
            buffer.m_130079_(this.data);
        }

        public ResourceLocation getID() {
            return ELEMENT_ID;
        }
    }

    static class ElementFactoryTankInfo
    implements IElementFactory {
        ElementFactoryTankInfo() {
        }

        public IElement createElement(FriendlyByteBuf buffer) {
            return new ElementTankInfo(buffer.m_130260_());
        }

        public ResourceLocation getId() {
            return ELEMENT_ID;
        }
    }
}

