/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweaksgamerules.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public final class CommonConfig {
    private static final Logger log = LogManager.getLogger((String)"APTweaks(Gamerules)");
    public static final ForgeConfigSpec commonSpec;
    public static final Config COMMON;

    private CommonConfig() {
    }

    static {
        com.electronwill.nightconfig.core.Config.setInsertionOrderPreserved((boolean)true);
        Pair specPair = new ForgeConfigSpec.Builder().configure(Config::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Config)specPair.getLeft();
        log.info("Registering {} common config ...", (Object)"Adaptive Performance Tweaks: Gamerules");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)commonSpec);
    }

    public static class Config {
        public final ForgeConfigSpec.IntValue timeBetweenUpdates;
        public final ForgeConfigSpec.BooleanValue entityCrammingEnabled;
        public final ForgeConfigSpec.IntValue minEntityCramming;
        public final ForgeConfigSpec.IntValue maxEntityCramming;
        public final ForgeConfigSpec.BooleanValue randomTickSpeedEnabled;
        public final ForgeConfigSpec.IntValue randomTickSpeed;
        public final ForgeConfigSpec.BooleanValue raidsEnabled;
        public final ForgeConfigSpec.BooleanValue insomniaEnabled;
        public final ForgeConfigSpec.BooleanValue patrolSpawningEnabled;
        public final ForgeConfigSpec.BooleanValue traderSpawningEnabled;

        Config(ForgeConfigSpec.Builder builder) {
            builder.comment("Adaptive Performance Tweaks: Gamerules");
            builder.push("General");
            this.timeBetweenUpdates = builder.comment("The time after a high to low load change is considered as valid. High loads are always considered immediately.").defineInRange("timeBetweenUpdates", 30, 1, 90);
            builder.pop();
            builder.push("Entity Cramming");
            this.entityCrammingEnabled = builder.comment("Enable/Disable dynamic entity cramming adjustments.").define("entityCrammingEnabled", true);
            this.minEntityCramming = builder.comment("Defines the min. numbers of mob singularity on a single block.").defineInRange("minEntityCramming", 5, 0, 64);
            this.maxEntityCramming = builder.comment("Defines the max. numbers of mob singularity on a single block.").defineInRange("maxEntityCramming", 24, 1, 64);
            builder.pop();
            builder.push("Random Tick Speed");
            this.randomTickSpeedEnabled = builder.comment("Enable/Disable dynamic random tick speed adjustments.").define("randomTickSpeedEnabled", true);
            this.randomTickSpeed = builder.comment("Defines the max. speed of crops grow, leaf decay, redstone, ... per chunk").defineInRange("randomTickSpeed", 3, 1, 256);
            builder.pop();
            builder.push("Raids");
            this.raidsEnabled = builder.comment("Enable/Disable dynamic raids adjustments.").define("raidsEnabled", true);
            builder.pop();
            builder.push("Insomnia");
            this.insomniaEnabled = builder.comment("Enable/Disable insomnia (phantoms) adjustments.").define("insomniaEnabled", true);
            builder.pop();
            builder.push("Patrol Spawning");
            this.patrolSpawningEnabled = builder.comment("Enable/Disable patrol spawning adjustments.").define("patrolSpawningEnabled", true);
            builder.pop();
            builder.push("Trader Spawning");
            this.traderSpawningEnabled = builder.comment("Enable/Disable trader spawning adjustments.").define("traderSpawningEnabled", true);
            builder.pop();
        }
    }
}

