/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweaksgamerules.gamerules;

import de.markusbordihn.adaptiveperformancetweakscore.commands.CommandManager;
import de.markusbordihn.adaptiveperformancetweakscore.server.ServerLoadEvent;
import de.markusbordihn.adaptiveperformancetweaksgamerules.config.CommonConfig;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class GameRuleManager {
    private static final Logger log = LogManager.getLogger((String)"APTweaks(Gamerules)");
    private static final CommonConfig.Config COMMON = CommonConfig.COMMON;
    private static GameRules gameRules;
    private static boolean entityCrammingEnabled;
    private static boolean insomniaEnabled;
    private static boolean patrolSpawningEnabled;
    private static boolean raidsEnabled;
    private static boolean randomTickSpeedEnabled;
    private static boolean traderSpawningEnabled;
    private static int maxEntityCramming;
    private static int minEntityCramming;
    private static int minEntityCrammingMineColonies;
    private static int randomTickSpeed;
    private static int timeBetweenUpdates;
    private static long lastUpdateTime;

    protected GameRuleManager() {
    }

    @SubscribeEvent
    public static void handleServerAboutToStartEvent(ServerAboutToStartEvent event) {
        entityCrammingEnabled = (Boolean)GameRuleManager.COMMON.entityCrammingEnabled.get();
        insomniaEnabled = (Boolean)GameRuleManager.COMMON.insomniaEnabled.get();
        patrolSpawningEnabled = (Boolean)GameRuleManager.COMMON.patrolSpawningEnabled.get();
        raidsEnabled = (Boolean)GameRuleManager.COMMON.raidsEnabled.get();
        randomTickSpeedEnabled = (Boolean)GameRuleManager.COMMON.randomTickSpeedEnabled.get();
        traderSpawningEnabled = (Boolean)GameRuleManager.COMMON.traderSpawningEnabled.get();
        maxEntityCramming = (Integer)GameRuleManager.COMMON.maxEntityCramming.get();
        minEntityCramming = (Integer)GameRuleManager.COMMON.minEntityCramming.get();
        randomTickSpeed = (Integer)GameRuleManager.COMMON.randomTickSpeed.get();
        timeBetweenUpdates = (Integer)GameRuleManager.COMMON.timeBetweenUpdates.get() * 1000;
        if (minEntityCramming >= maxEntityCramming) {
            minEntityCramming = maxEntityCramming - 1;
        }
        if (entityCrammingEnabled && ModList.get().isLoaded("minecolonies") && minEntityCramming < minEntityCrammingMineColonies) {
            log.warn("WARNING: The recommended value for minEntityCramming with {} is min. {} instead of {}!", (Object)"MineColonies", (Object)minEntityCrammingMineColonies, (Object)minEntityCramming);
            log.info("The minEntityCramming will be automatically set to {}!", (Object)minEntityCrammingMineColonies);
            minEntityCramming = minEntityCrammingMineColonies;
            if (maxEntityCramming <= minEntityCramming) {
                maxEntityCramming = minEntityCramming + 1;
            }
        }
    }

    @SubscribeEvent
    public static void handleServerStartingEvent(ServerStartingEvent event) {
        gameRules = ServerLifecycleHooks.getCurrentServer().m_129900_();
        log.info("Gamerules will be optimized with an {} sec delay between updates.", (Object)(timeBetweenUpdates / 1000));
        if (randomTickSpeedEnabled) {
            log.info("Random Tick Speed will be optimized between {} and {}", (Object)1, (Object)randomTickSpeed);
            if (gameRules.m_46215_(GameRules.f_46143_) != randomTickSpeed) {
                GameRuleManager.setRandomTickSpeed(randomTickSpeed);
            }
        }
        if (entityCrammingEnabled) {
            log.info("Max Entity Cramming will be optimized between {} and {}", (Object)minEntityCramming, (Object)maxEntityCramming);
            if (gameRules.m_46215_(GameRules.f_46149_) != maxEntityCramming) {
                GameRuleManager.setMaxEntityCramming(maxEntityCramming);
            }
        }
        if (patrolSpawningEnabled) {
            log.info("Patrol spawning will be automatically disabled during very high server load!");
        }
        if (raidsEnabled) {
            log.info("Raids will be automatically disabled during very high server load!");
        }
        if (insomniaEnabled) {
            log.info("Insomnia (phantoms spawn) will be automatically disabled during very high server load!");
        }
        if (traderSpawningEnabled) {
            log.info("Trader spawning will be automatically disabled during very high server load!");
        }
    }

    @SubscribeEvent
    public static void handleServerLoadEvent(ServerLoadEvent event) {
        gameRules = ServerLifecycleHooks.getCurrentServer().m_129900_();
        if (event.hasVeryHighServerLoad()) {
            if (entityCrammingEnabled) {
                GameRuleManager.decreaseMaxEntityCramming();
            }
            if (randomTickSpeedEnabled) {
                GameRuleManager.decreaseRandomTickSpeed();
            }
            if (patrolSpawningEnabled) {
                GameRuleManager.disablePatrolSpawning();
            }
            if (raidsEnabled) {
                GameRuleManager.disableRaids();
            }
            if (insomniaEnabled) {
                GameRuleManager.disableInsomnia();
            }
            if (traderSpawningEnabled) {
                GameRuleManager.disableTraderSpawning();
            }
            return;
        }
        if (event.hasHighServerLoad()) {
            if (randomTickSpeedEnabled) {
                GameRuleManager.decreaseRandomTickSpeed();
            }
            if (raidsEnabled) {
                GameRuleManager.enableRaids();
            }
            return;
        }
        if (System.currentTimeMillis() - lastUpdateTime < (long)timeBetweenUpdates) {
            return;
        }
        if (patrolSpawningEnabled) {
            GameRuleManager.enablePatrolSpawning();
        }
        if (raidsEnabled) {
            GameRuleManager.enableRaids();
        }
        if (insomniaEnabled) {
            GameRuleManager.enableInsomnia();
        }
        if (traderSpawningEnabled) {
            GameRuleManager.enableTraderSpawning();
        }
        if (event.hasNormalServerLoad()) {
            return;
        }
        if (event.hasLowServerLoad()) {
            if (randomTickSpeedEnabled) {
                GameRuleManager.increaseRandomTickSpeed();
            }
            if (entityCrammingEnabled) {
                GameRuleManager.increaseMaxEntityCramming();
            }
        }
        lastUpdateTime = System.currentTimeMillis();
    }

    public static void enablePatrolSpawning() {
        if (!gameRules.m_46207_(GameRules.f_46124_)) {
            log.debug("Enable PatrolSpawning");
            CommandManager.executeServerCommand((String)String.format("gamerule doPatrolSpawning %s", true));
        }
    }

    public static void disablePatrolSpawning() {
        if (gameRules.m_46207_(GameRules.f_46124_)) {
            log.debug("Disable PatrolSpawning");
            CommandManager.executeServerCommand((String)String.format("gamerule doPatrolSpawning %s", false));
        }
    }

    public static void enableInsomnia() {
        if (!gameRules.m_46207_(GameRules.f_46155_)) {
            log.debug("Enable Insomnia");
            CommandManager.executeServerCommand((String)String.format("gamerule doInsomnia %s", true));
        }
    }

    public static void disableInsomnia() {
        if (gameRules.m_46207_(GameRules.f_46155_)) {
            log.debug("Disable Insomnia");
            CommandManager.executeServerCommand((String)String.format("gamerule doInsomnia %s", false));
        }
    }

    public static void enableRaids() {
        if (gameRules.m_46207_(GameRules.f_46154_)) {
            log.debug("Enable Raids");
            CommandManager.executeServerCommand((String)String.format("gamerule disableRaids %s", false));
        }
    }

    public static void disableRaids() {
        if (!gameRules.m_46207_(GameRules.f_46154_)) {
            log.debug("Disable Raids");
            CommandManager.executeServerCommand((String)String.format("gamerule disableRaids %s", true));
        }
    }

    public static void enableTraderSpawning() {
        if (!gameRules.m_46207_(GameRules.f_46125_)) {
            log.debug("Enable TraderSpawning");
            CommandManager.executeServerCommand((String)String.format("gamerule doTraderSpawning %s", true));
        }
    }

    public static void disableTraderSpawning() {
        if (gameRules.m_46207_(GameRules.f_46125_)) {
            log.debug("Disable TraderSpawning");
            CommandManager.executeServerCommand((String)String.format("gamerule doTraderSpawning %s", false));
        }
    }

    public static void decreaseRandomTickSpeed() {
        GameRuleManager.setRandomTickSpeed(gameRules.m_46215_(GameRules.f_46143_) - 1);
    }

    public static void increaseRandomTickSpeed() {
        GameRuleManager.setRandomTickSpeed(gameRules.m_46215_(GameRules.f_46143_) + 1);
    }

    public static void setRandomTickSpeed(int tickSpeed) {
        int currentTickSpeed = gameRules.m_46215_(GameRules.f_46143_);
        if (tickSpeed < 1) {
            tickSpeed = 1;
        } else if (tickSpeed > randomTickSpeed) {
            tickSpeed = randomTickSpeed;
        }
        if (currentTickSpeed != tickSpeed) {
            log.debug("Changing randomTickSpeed from {} to {}", (Object)currentTickSpeed, (Object)tickSpeed);
            CommandManager.executeServerCommand((String)String.format("gamerule randomTickSpeed %s", tickSpeed));
        }
    }

    public static void decreaseMaxEntityCramming() {
        GameRuleManager.setMaxEntityCramming(gameRules.m_46215_(GameRules.f_46149_) - 1);
    }

    public static void increaseMaxEntityCramming() {
        GameRuleManager.setMaxEntityCramming(gameRules.m_46215_(GameRules.f_46149_) + 1);
    }

    public static void setMaxEntityCramming(int maxEntity) {
        if (maxEntity < minEntityCramming) {
            maxEntity = minEntityCramming;
        } else if (maxEntity > maxEntityCramming) {
            maxEntity = maxEntityCramming;
        }
        int currentMaxEntityCramming = gameRules.m_46215_(GameRules.f_46149_);
        if (currentMaxEntityCramming != maxEntity) {
            log.debug("Changing maxEntityCramming from {} to {}", (Object)currentMaxEntityCramming, (Object)maxEntity);
            CommandManager.executeServerCommand((String)String.format("gamerule maxEntityCramming %s", maxEntity));
        }
    }

    public static GameRules getGameRules() {
        if (gameRules == null) {
            gameRules = ServerLifecycleHooks.getCurrentServer().m_129900_();
        }
        return gameRules;
    }

    public static Map<String, String> getGameRulesOverview() {
        ConcurrentHashMap<String, String> overview = new ConcurrentHashMap<String, String>();
        overview.put("disableRaids", String.valueOf(gameRules.m_46207_(GameRules.f_46154_)));
        overview.put("doInsomnia", String.valueOf(gameRules.m_46207_(GameRules.f_46155_)));
        overview.put("doPatrolSpawning", String.valueOf(gameRules.m_46207_(GameRules.f_46124_)));
        overview.put("doTraderSpawning", String.valueOf(gameRules.m_46207_(GameRules.f_46125_)));
        overview.put("maxEntityCramming", String.valueOf(gameRules.m_46215_(GameRules.f_46149_)));
        overview.put("randomTickSpeed", String.valueOf(gameRules.m_46215_(GameRules.f_46143_)));
        return overview;
    }

    static {
        entityCrammingEnabled = (Boolean)GameRuleManager.COMMON.entityCrammingEnabled.get();
        insomniaEnabled = (Boolean)GameRuleManager.COMMON.insomniaEnabled.get();
        patrolSpawningEnabled = (Boolean)GameRuleManager.COMMON.patrolSpawningEnabled.get();
        raidsEnabled = (Boolean)GameRuleManager.COMMON.raidsEnabled.get();
        randomTickSpeedEnabled = (Boolean)GameRuleManager.COMMON.randomTickSpeedEnabled.get();
        traderSpawningEnabled = (Boolean)GameRuleManager.COMMON.traderSpawningEnabled.get();
        maxEntityCramming = (Integer)GameRuleManager.COMMON.maxEntityCramming.get();
        minEntityCramming = (Integer)GameRuleManager.COMMON.maxEntityCramming.get();
        minEntityCrammingMineColonies = 16;
        randomTickSpeed = (Integer)GameRuleManager.COMMON.randomTickSpeed.get();
        timeBetweenUpdates = (Integer)GameRuleManager.COMMON.timeBetweenUpdates.get() * 1000;
        lastUpdateTime = System.currentTimeMillis();
    }
}

