/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Logger;
import wile.rsgauges.ModContent;
import wile.rsgauges.ModRsGauges;
import wile.rsgauges.libmc.detail.Auxiliaries;
import wile.rsgauges.libmc.detail.OptionalRecipeCondition;

public class ModConfig {
    private static final Logger LOGGER = ModRsGauges.logger();
    private static final String MODID = "rsgauges";
    public static final CommonConfig COMMON;
    public static final ServerConfig SERVER;
    public static final ForgeConfigSpec COMMON_CONFIG_SPEC;
    public static final ForgeConfigSpec SERVER_CONFIG_SPEC;
    private static final CompoundTag server_config_;
    private static HashSet<String> optouts_;
    private static boolean with_experimental_features_;
    private static boolean with_config_logging_;
    public static boolean status_overlay_disabled;
    public static boolean without_switch_linking;
    public static boolean without_gauge_weak_power_measurement;
    public static boolean without_pulsetime_config;
    public static boolean without_switch_nooutput;
    public static boolean without_rightclick_item_switchconfig;
    public static int max_switch_linking_distance;
    public static int autoswitch_linear_update_interval;
    public static int comparator_switch_update_interval;
    public static int autoswitch_volumetric_update_interval;
    public static int gauge_update_interval;
    public static int config_left_click_timeout;
    public static double switch_status_overlay_y;
    public static final Set<ResourceLocation> accepted_wrenches;

    public static final boolean isOptedOut(@Nullable Block block) {
        return ModConfig.isOptedOut(block.m_5456_());
    }

    public static final boolean isOptedOut(@Nullable Item item) {
        return item != null && optouts_.contains(item.getRegistryName().m_135815_());
    }

    public static boolean withExperimental() {
        return with_experimental_features_;
    }

    public static boolean withoutRecipes() {
        return false;
    }

    public static final CompoundTag getServerConfig() {
        return server_config_;
    }

    private static final void updateOptouts() {
        int i;
        ArrayList<String> includes = new ArrayList<String>();
        ArrayList<String> excludes = new ArrayList<String>();
        String inc = ((String)ModConfig.COMMON.pattern_includes.get()).toLowerCase().replaceAll("rsgauges:", "").replaceAll("[^*_,a-z0-9]", "");
        if (ModConfig.COMMON.pattern_includes.get() != inc) {
            ModConfig.COMMON.pattern_includes.set((Object)inc);
        }
        String[] incl = inc.split(",");
        for (i = 0; i < incl.length; ++i) {
            incl[i] = incl[i].replaceAll("[*]", ".*?");
            if (incl[i].isEmpty()) continue;
            includes.add(incl[i]);
        }
        String exc = ((String)ModConfig.COMMON.pattern_excludes.get()).toLowerCase().replaceAll("rsgauges:", "").replaceAll("[^*_,a-z0-9]", "");
        String[] excl = exc.split(",");
        for (i = 0; i < excl.length; ++i) {
            excl[i] = excl[i].replaceAll("[*]", ".*?");
            if (excl[i].isEmpty()) continue;
            excludes.add(excl[i]);
        }
        if (!excludes.isEmpty()) {
            ModConfig.log("Config pattern excludes: '" + String.join((CharSequence)",", excludes) + "'");
        }
        if (!includes.isEmpty()) {
            ModConfig.log("Config pattern includes: '" + String.join((CharSequence)",", includes) + "'");
        }
        HashSet optouts = new HashSet();
        ModContent.getRegisteredItems().stream().filter(Objects::nonNull).forEach(e -> optouts.add(e.getRegistryName().m_135815_()));
        ModContent.getRegisteredBlocks().stream().filter(block -> {
            if (block == null) {
                return true;
            }
            try {
                if (!with_experimental_features_) {
                    if (block instanceof Auxiliaries.IExperimentalFeature) {
                        return true;
                    }
                    if (ModContent.isExperimentalBlock(block)) {
                        return true;
                    }
                }
                String rn = block.getRegistryName().m_135815_();
                try {
                    for (String e : includes) {
                        if (!rn.matches(e)) continue;
                        return false;
                    }
                    for (String e : excludes) {
                        if (!rn.matches(e)) continue;
                        return true;
                    }
                }
                catch (Throwable ex) {
                    LOGGER.error("optout include pattern failed, disabling.");
                    includes.clear();
                    excludes.clear();
                }
            }
            catch (Exception ex) {
                LOGGER.error("Exception evaluating the optout config: '" + ex.getMessage() + "'");
            }
            return false;
        }).forEach(e -> optouts.add(e.getRegistryName().m_135815_()));
        optouts_ = optouts;
        OptionalRecipeCondition.on_config(ModConfig.withExperimental(), ModConfig.withoutRecipes(), ModConfig::isOptedOut, ModConfig::isOptedOut);
    }

    public static final void apply() {
        if (COMMON == null || !COMMON_CONFIG_SPEC.isLoaded()) {
            return;
        }
        with_config_logging_ = (Boolean)ModConfig.COMMON.with_config_logging.get();
        with_experimental_features_ = (Boolean)ModConfig.COMMON.with_experimental.get();
        if (with_experimental_features_) {
            LOGGER.info("Config: EXPERIMENTAL FEATURES ENABLED.");
        }
        ModConfig.updateOptouts();
        without_switch_linking = (Boolean)ModConfig.COMMON.without_switch_linking.get();
        max_switch_linking_distance = (Integer)ModConfig.COMMON.max_switch_linking_distance.get();
        autoswitch_linear_update_interval = (Integer)ModConfig.COMMON.autoswitch_linear_update_interval.get();
        comparator_switch_update_interval = (Integer)ModConfig.COMMON.comparator_switch_update_interval.get();
        autoswitch_volumetric_update_interval = (Integer)ModConfig.COMMON.autoswitch_volumetric_update_interval.get();
        gauge_update_interval = (Integer)ModConfig.COMMON.gauge_update_interval.get();
        without_gauge_weak_power_measurement = (Boolean)ModConfig.COMMON.without_gauge_weak_power_measurement.get();
        String cfg_wrenches = ((String)ModConfig.COMMON.accepted_wrenches.get()).toLowerCase().replaceAll("[\\s,]", " ").trim();
        List wrenches = Arrays.stream(cfg_wrenches.split(" ")).filter(e -> !e.trim().isEmpty()).map(ResourceLocation::m_135820_).filter(Objects::nonNull).collect(Collectors.toList());
        wrenches.add(new ResourceLocation("minecraft", "redstone_torch"));
        wrenches.remove(new ResourceLocation("minecraft", "air"));
        accepted_wrenches.clear();
        accepted_wrenches.addAll(wrenches);
        ModConfig.log("Accepted wrenches: " + accepted_wrenches.stream().map(ResourceLocation::toString).collect(Collectors.joining(",")));
    }

    public static final void log(String config_message) {
        if (!with_config_logging_) {
            return;
        }
        LOGGER.info(config_message);
    }

    public static final boolean isWrench(ItemStack stack) {
        return accepted_wrenches.contains(stack.m_41720_().getRegistryName());
    }

    static {
        Pair common_ = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        COMMON_CONFIG_SPEC = (ForgeConfigSpec)common_.getRight();
        COMMON = (CommonConfig)common_.getLeft();
        Pair server_ = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        SERVER_CONFIG_SPEC = (ForgeConfigSpec)server_.getRight();
        SERVER = (ServerConfig)server_.getLeft();
        server_config_ = new CompoundTag();
        optouts_ = new HashSet();
        with_experimental_features_ = false;
        with_config_logging_ = false;
        status_overlay_disabled = false;
        without_switch_linking = false;
        without_gauge_weak_power_measurement = false;
        without_pulsetime_config = false;
        without_switch_nooutput = false;
        without_rightclick_item_switchconfig = false;
        max_switch_linking_distance = 16;
        autoswitch_linear_update_interval = 2;
        comparator_switch_update_interval = 2;
        autoswitch_volumetric_update_interval = 2;
        gauge_update_interval = 2;
        config_left_click_timeout = 600;
        switch_status_overlay_y = 0.75;
        accepted_wrenches = new HashSet<ResourceLocation>(Arrays.asList(new ResourceLocation("minecraft", "redsdtone_torch")));
    }

    public static class CommonConfig {
        public final ForgeConfigSpec.ConfigValue<String> pattern_excludes;
        public final ForgeConfigSpec.ConfigValue<String> pattern_includes;
        public final ForgeConfigSpec.BooleanValue without_switch_linking;
        public final ForgeConfigSpec.BooleanValue with_experimental;
        public final ForgeConfigSpec.IntValue max_switch_linking_distance;
        public final ForgeConfigSpec.ConfigValue<String> accepted_wrenches;
        public final ForgeConfigSpec.BooleanValue with_config_logging;
        public final ForgeConfigSpec.BooleanValue without_gauge_weak_power_measurement;
        public final ForgeConfigSpec.IntValue gauge_update_interval;
        public final ForgeConfigSpec.IntValue autoswitch_volumetric_update_interval;
        public final ForgeConfigSpec.IntValue autoswitch_linear_update_interval;
        public final ForgeConfigSpec.IntValue comparator_switch_update_interval;

        CommonConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Settings affecting the logical server side, but are also configurable in single player.").push("server");
            builder.comment("Opt-out settings").push("optout");
            this.pattern_excludes = builder.translation("rsgauges.config.pattern_excludes").comment("Opt-out any block by its registry name ('*' wildcard matching, comma separated list, whitespaces ignored. You must match the whole name, means maybe add '*' also at the begin and end. Example: '*wood*,*steel*' excludes everything that has 'wood' or 'steel' in the registry name. The matching result is also traced in the log file. ").define("pattern_excludes", (Object)"");
            this.pattern_includes = builder.translation("rsgauges.config.pattern_includes").comment("Prevent blocks from being opt'ed by registry name ('*' wildcard matching, comma separated list, whitespaces ignored. Evaluated before all other opt-out checks. You must match the whole name, means maybe add '*' also at the begin and end. Example: '*wood*,*steel*' includes everything that has 'wood' or 'steel' in the registry name.The matching result is also traced in the log file.").define("pattern_includes", (Object)"");
            this.without_switch_linking = builder.translation("rsgauges.config.without_switch_linking").comment("Disables switch remote linking.").define("without_switch_linking", false);
            builder.pop();
            builder.comment("Miscellaneous settings").push("miscellaneous");
            this.with_experimental = builder.translation("rsgauges.config.with_experimental").comment("Enables experimental features. Use at own risk.").define("with_experimental", false);
            this.max_switch_linking_distance = builder.translation("rsgauges.config.max_switch_linking_distance").comment("Defines how far you or a link source switch can be away from the target to activate it. The value 0 means 'no limitation',  as long as the target chunk is loaded.").defineInRange("max_switch_linking_distance", 48, 0, 64);
            this.accepted_wrenches = builder.translation("rsgauges.config.accepted_wrenches").comment("Comma separated list of items names that can be used alter configurable blocks of this mod. This applies when the display side of the block is right click (activated) with the item in the main hand.").define("accepted_wrenches", (Object)"minecraft:redstone_torch,immersiveengineering:screwdriver,immersiveengineering:hammer");
            this.with_config_logging = builder.translation("rsgauges.config.with_config_logging").comment("Enable detailed logging of the config values and resulting calculations in each mod feature config.").define("with_config_logging", false);
            builder.pop();
            builder.comment("Settings to tweak the performance, or use cases normally no change should be required here.").push("tweaks");
            this.without_gauge_weak_power_measurement = builder.translation("rsgauges.config.without_gauge_weak_power_measurement").comment("Gauges shall not frequently lookup weak power provided to the block they are attached to.").define("without_gauge_weak_power_measurement", false);
            this.gauge_update_interval = builder.translation("rsgauges.config.gauge_update_interval").comment("Sample interval of the gauges in ticks. Lower values decrease the display latency for indirect weak power measurements. Minor performance impact for values >= 5.").defineInRange("gauge_update_interval", 8, 2, 100);
            this.autoswitch_volumetric_update_interval = builder.translation("rsgauges.config.autoswitch_volumetric_update_interval").comment("Sample interval of volume sensing automatic switches in ticks (e.g infrared motion detector). Lower values make the switches reacting faster, but also have an impact on the server performance due to ray tracing.").defineInRange("autoswitch_volumetric_update_interval", 10, 5, 50);
            this.autoswitch_linear_update_interval = builder.translation("rsgauges.config.autoswitch_linear_update_interval").comment(new String[]{"Sample interval of the linear switches in ticks (like laser pointer based sensors). Lower values make the switches reacting faster, but also have an impact on the server performance due to ray tracing. Has much less impact", "as the volumetric autoswitch interval."}).defineInRange("autoswitch_linear_update_interval", 4, 1, 50);
            this.comparator_switch_update_interval = builder.translation("rsgauges.config.comparator_switch_update_interval").comment("Sample interval of the Comparator Switch").defineInRange("comparator_switch_update_interval", 4, 1, 50);
            builder.pop();
        }
    }

    public static class ServerConfig {
        ServerConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Settings affecting the logical server side, but are also configurable in single player.").push("server");
        }
    }
}

