/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.blocks;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import wile.rsgauges.ModConfig;
import wile.rsgauges.ModContent;
import wile.rsgauges.blocks.AutoSwitchBlock;
import wile.rsgauges.blocks.RsDirectedBlock;
import wile.rsgauges.detail.ModResources;
import wile.rsgauges.libmc.detail.Auxiliaries;
import wile.rsgauges.libmc.detail.Overlay;

public class EntityDetectorSwitchBlock
extends AutoSwitchBlock {
    public EntityDetectorSwitchBlock(long config, BlockBehaviour.Properties properties, AABB unrotatedBBUnpowered, @Nullable AABB unrotatedBBPowered, @Nullable ModResources.BlockSoundEvent powerOnSound, @Nullable ModResources.BlockSoundEvent powerOffSound) {
        super(config, properties, unrotatedBBUnpowered, unrotatedBBPowered, powerOnSound, powerOffSound);
    }

    public EntityDetectorSwitchBlock(long config, BlockBehaviour.Properties properties, AABB unrotatedBBUnpowered, @Nullable AABB unrotatedBBPowered) {
        super(config, properties, unrotatedBBUnpowered, unrotatedBBPowered, null, null);
    }

    @Override
    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new DetectorSwitchTileEntity(pos, state);
    }

    public static class DetectorSwitchTileEntity
    extends AutoSwitchBlock.AutoSwitchTileEntity {
        public static final Class<?>[] filter_classes = new Class[]{LivingEntity.class, Player.class, Monster.class, Animal.class, Villager.class, ItemEntity.class, Entity.class};
        public static final String[] filter_class_names = new String[]{"creatures", "players", "mobs", "animals", "villagers", "objects", "everything"};
        private static final int max_sensor_range_ = 16;
        private int sensor_entity_count_threshold_ = 1;
        private int sensor_range_ = 5;
        private int filter_ = 0;
        private AABB area_ = null;
        private int update_interval_ = 8;
        private int update_timer_ = 0;

        public DetectorSwitchTileEntity(BlockEntityType<?> te_type, BlockPos pos, BlockState state) {
            super(te_type, pos, state);
        }

        public DetectorSwitchTileEntity(BlockPos pos, BlockState state) {
            super(ModContent.TET_DETECTOR_SWITCH, pos, state);
        }

        public int filter() {
            return this.filter_;
        }

        public void filter(int sel) {
            this.filter_ = sel < 0 ? 0 : (sel >= filter_classes.length ? filter_classes.length - 1 : sel);
        }

        public Class<?> filter_class() {
            return this.filter_ <= 0 ? filter_classes[0] : (this.filter_ >= filter_classes.length ? filter_classes[filter_classes.length - 1] : filter_classes[this.filter_]);
        }

        public void sensor_entity_threshold(int count) {
            this.sensor_entity_count_threshold_ = Math.max(count, 1);
        }

        public int sensor_entity_threshold() {
            return this.sensor_entity_count_threshold_;
        }

        public void sensor_range(int r) {
            this.sensor_range_ = r < 1 ? 1 : Math.min(r, 16);
        }

        public int sensor_range() {
            return this.sensor_range_;
        }

        @Override
        public void write(CompoundTag nbt, boolean updatePacket) {
            super.write(nbt, updatePacket);
            nbt.m_128405_("range", this.sensor_range_);
            nbt.m_128405_("entitythreshold", this.sensor_entity_count_threshold_);
            nbt.m_128405_("filter", this.filter_);
        }

        @Override
        public void read(CompoundTag nbt, boolean updatePacket) {
            super.read(nbt, updatePacket);
            this.sensor_range(nbt.m_128451_("range"));
            this.sensor_entity_threshold(nbt.m_128451_("entitythreshold"));
            this.filter(nbt.m_128451_("filter"));
        }

        @Override
        public void reset(@Nullable LevelReader world) {
            super.reset(world);
            this.update_timer_ = 0;
            this.area_ = null;
            this.sensor_range_ = 5;
            this.filter_ = 0;
        }

        @Override
        public boolean activation_config(BlockState state, @Nullable Player player, double x, double y, boolean show_only) {
            int field;
            int direction;
            if (state == null) {
                return false;
            }
            int n = y >= 12.0 ? 1 : (direction = y <= 5.0 ? -1 : 0);
            int n2 = x >= 2.0 && x <= 3.95 ? 1 : (x >= 4.25 && x <= 7.0 ? 2 : (x >= 8.0 && x <= 10.0 ? 3 : (field = x >= 11.0 && x <= 13.0 ? 4 : 0)));
            if (direction == 0 || field == 0) {
                return false;
            }
            if (!show_only) {
                switch (field) {
                    case 1: {
                        this.sensor_range(this.sensor_range() + direction);
                        this.area_ = null;
                        break;
                    }
                    case 2: {
                        this.sensor_entity_threshold(this.sensor_entity_threshold() + direction);
                        break;
                    }
                    case 3: {
                        this.filter(this.filter() + direction);
                        break;
                    }
                    case 4: {
                        this.setpower(this.setpower() + direction);
                        if (this.setpower() >= 1) break;
                        this.setpower(1);
                    }
                }
                this.m_6596_();
            }
            Overlay.show(player, (Component)new TextComponent("").m_7220_((Component)Auxiliaries.localizable("switchconfig.detector.sensor_range", ChatFormatting.BLUE, new Object[]{this.sensor_range()})).m_130946_(" | ").m_7220_((Component)Auxiliaries.localizable("switchconfig.detector.entity_threshold", ChatFormatting.YELLOW, new Object[]{this.sensor_entity_threshold()})).m_130946_(" | ").m_7220_((Component)Auxiliaries.localizable("switchconfig.detector.entity_filter", ChatFormatting.DARK_GREEN, new Object[]{new TranslatableComponent("rsgauges.switchconfig.detector.entity_filter." + filter_class_names[this.filter()])})).m_130946_(" | ").m_7220_((Component)Auxiliaries.localizable("switchconfig.detector.output_power", ChatFormatting.RED, new Object[]{this.setpower()})));
            return true;
        }

        @Override
        public void tick() {
            if (this.f_58857_.m_5776_() || --this.update_timer_ > 0) {
                return;
            }
            this.update_timer_ = this.update_interval_;
            BlockState state = this.f_58857_.m_8055_(this.m_58899_());
            if (state == null || !(state.m_60734_() instanceof AutoSwitchBlock)) {
                return;
            }
            AutoSwitchBlock block = (AutoSwitchBlock)state.m_60734_();
            if (this.update_interval_ == 0) {
                this.update_interval_ = (block.config & 0x800000000L) != 0L ? ModConfig.autoswitch_linear_update_interval : ModConfig.autoswitch_volumetric_update_interval;
            }
            if (this.area_ == null) {
                int size = this.sensor_range();
                AABB range_bb = (block.config & 0x400000000L) != 0L ? new AABB(0.0, -2.0, (double)(-size), (double)size, 2.0, (double)size) : ((block.config & 0x800000000L) != 0L ? new AABB(-0.5, -0.5, -0.5, (double)size, 0.5, 0.5) : new AABB(0.0, 0.0, 0.0, 1.0, 0.0, 0.0));
                Direction facing = (Direction)state.m_61143_((Property)RsDirectedBlock.FACING);
                AABB bb = Auxiliaries.transform_forward(range_bb, facing).m_82338_(this.m_58899_()).m_82363_(1.0, 1.0, 1.0);
                this.area_ = new AABB(bb.f_82288_, bb.f_82289_, bb.f_82290_, bb.f_82291_, bb.f_82292_, bb.f_82293_);
            }
            boolean active = false;
            List hits = this.f_58857_.m_45976_(this.filter_class(), this.area_);
            if (hits.size() >= this.sensor_entity_count_threshold_) {
                int num_seen = 0;
                Vec3 switch_position = new Vec3((double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5);
                for (Entity e : hits) {
                    if (e instanceof HangingEntity || this.f_58857_.m_45547_(new ClipContext(new Vec3((double)e.m_142538_().m_123341_() - 0.2, (double)((float)e.m_142538_().m_123342_() + e.m_20192_()), (double)e.m_142538_().m_123343_() - 0.2), switch_position, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, e)).m_6662_() == HitResult.Type.BLOCK && this.f_58857_.m_45547_(new ClipContext(new Vec3((double)e.m_142538_().m_123341_() + 0.2, (double)((float)e.m_142538_().m_123342_() + e.m_20192_()), (double)e.m_142538_().m_123343_() + 0.2), switch_position, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, e)).m_6662_() == HitResult.Type.BLOCK || ++num_seen < this.sensor_entity_count_threshold_) continue;
                    active = true;
                    break;
                }
            }
            this.updateSwitchState(state, block, active, this.configured_on_time());
        }
    }
}

