/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.blocks;

import com.google.common.collect.ImmutableList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import wile.rsgauges.blocks.SwitchBlock;
import wile.rsgauges.detail.ModResources;
import wile.rsgauges.detail.SwitchLink;

public class LinkReceiverSwitchBlock
extends SwitchBlock {
    private final boolean is_analog;

    public LinkReceiverSwitchBlock(long config, BlockBehaviour.Properties properties, AABB unrotatedBBUnpowered, @Nullable AABB unrotatedBBPowered, @Nullable ModResources.BlockSoundEvent powerOnSound, @Nullable ModResources.BlockSoundEvent powerOffSound, boolean analog_device) {
        super(config, properties, unrotatedBBUnpowered, unrotatedBBPowered, powerOnSound, powerOffSound);
        this.is_analog = analog_device;
    }

    @Override
    public boolean switchLinkHasAnalogSupport(Level world, BlockPos pos) {
        return this.is_analog;
    }

    @Override
    public ImmutableList<SwitchLink.LinkMode> switchLinkGetSupportedTargetModes() {
        return !this.is_analog ? super.switchLinkGetSupportedTargetModes() : ImmutableList.of((Object)((Object)SwitchLink.LinkMode.AS_STATE), (Object)((Object)SwitchLink.LinkMode.INV_STATE));
    }

    @Override
    public SwitchLink.RequestResult switchLinkTrigger(SwitchLink link) {
        boolean powered;
        BlockPos pos = link.target_position;
        Level world = link.world;
        SwitchBlock.SwitchTileEntity te = this.getTe((LevelReader)world, pos);
        BlockState state = world.m_8055_(pos);
        if (te == null || !te.verifySwitchLinkTarget(link)) {
            return SwitchLink.RequestResult.TARGET_GONE;
        }
        int p = this.is_analog ? link.source_analog_power : link.source_digital_power;
        boolean was_powered = (Boolean)state.m_61143_((Property)POWERED);
        if (!this.is_analog && link.mode() != SwitchLink.LinkMode.AS_STATE) {
            p = was_powered ? 0 : 15;
        }
        boolean bl = powered = p > 0;
        if (powered) {
            te.setpower(p);
        }
        if (powered != was_powered) {
            if ((this.config & 0x20000000L) == 0L) {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(powered)), 27);
                (powered ? this.power_off_sound : this.power_on_sound).play(world, pos);
            } else if (powered) {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true)), 27);
                this.power_on_sound.play(world, pos);
                te.on_timer_reset();
                te.on_timer_extend();
                te.reschedule_block_tick();
            }
        }
        this.notifyNeighbours(world, pos, state, te, false);
        if (!te.activateSwitchLinks(te.setpower(), powered ? 15 : 0, powered != was_powered)) {
            ModResources.BlockSoundEvents.SWITCHLINK_LINK_PEAL_USE_FAILED.play(world, pos);
        }
        return SwitchLink.RequestResult.OK;
    }
}

