/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common.data;

import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.DataFixerUpper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.SimpleReloadableResourceManager;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.common.data.ExistingFileHelper;

public class StructureUpdater
implements DataProvider {
    private final PackType packType;
    private final String basePath;
    private final String modid;
    private final DataGenerator gen;
    private final SimpleReloadableResourceManager resources;

    public StructureUpdater(DataGenerator gen, ExistingFileHelper helper, String modid, PackType packType, String basePath) {
        this.gen = gen;
        this.modid = modid;
        this.packType = packType;
        this.basePath = basePath;
        try {
            Field resourceManager = ExistingFileHelper.class.getDeclaredField(packType == PackType.SERVER_DATA ? "serverData" : "clientResources");
            resourceManager.setAccessible(true);
            this.resources = (SimpleReloadableResourceManager)resourceManager.get(helper);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public void m_6865_(HashCache cache) throws IOException {
        for (ResourceLocation loc : this.resources.m_6540_(this.basePath, file -> file.endsWith(".nbt"))) {
            if (!loc.m_135827_().equals(this.modid)) continue;
            this.process(loc, cache);
        }
    }

    private void process(ResourceLocation loc, HashCache cache) throws IOException {
        CompoundTag inputNBT = NbtIo.m_128939_((InputStream)this.resources.m_142591_(loc).m_6679_());
        CompoundTag converted = StructureUpdater.updateNBT(inputNBT);
        if (!converted.equals((Object)inputNBT)) {
            Class<?> fixerClass = DataFixers.m_14512_().getClass();
            if (!fixerClass.equals(DataFixerUpper.class)) {
                throw new RuntimeException("Structures are not up to date, but unknown data fixer is in use: " + fixerClass.getName());
            }
            this.writeNBTTo(loc, converted, cache);
        }
    }

    private void writeNBTTo(ResourceLocation loc, CompoundTag data, HashCache cache) throws IOException {
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
        NbtIo.m_128947_((CompoundTag)data, (OutputStream)bytearrayoutputstream);
        byte[] bytes = bytearrayoutputstream.toByteArray();
        String hashString = f_123918_.hashBytes(bytes).toString();
        Path outputPath = this.gen.m_123916_().resolve(this.packType.m_10305_() + "/" + loc.m_135827_() + "/" + loc.m_135815_());
        if (!Objects.equals(cache.m_123938_(outputPath), hashString) || !Files.exists(outputPath, new LinkOption[0])) {
            Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
            try (OutputStream outputstream = Files.newOutputStream(outputPath, new OpenOption[0]);){
                outputstream.write(bytes);
            }
        }
        cache.m_123940_(outputPath, hashString);
    }

    private static CompoundTag updateNBT(CompoundTag nbt) {
        CompoundTag updatedNBT = NbtUtils.m_129213_((DataFixer)DataFixers.m_14512_(), (DataFixTypes)DataFixTypes.STRUCTURE, (CompoundTag)nbt, (int)nbt.m_128451_("DataVersion"));
        StructureTemplate template = new StructureTemplate();
        template.m_74638_(updatedNBT);
        return template.m_74618_(new CompoundTag());
    }

    public String m_6055_() {
        return "Update structure files in " + this.basePath;
    }
}

