/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common.data.tags;

import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.tags.BlockTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.ExistingFileHelper;
import slimeknights.mantle.registration.object.BuildingBlockObject;
import slimeknights.mantle.registration.object.EnumObject;
import slimeknights.mantle.registration.object.MetalItemObject;
import slimeknights.mantle.registration.object.WoodBlockObject;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.registration.GeodeItemObject;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.TinkerMaterials;
import slimeknights.tconstruct.shared.block.ClearStainedGlassBlock;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.data.SmelteryCompat;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.world.TinkerHeadType;
import slimeknights.tconstruct.world.TinkerWorld;

public class BlockTagProvider
extends BlockTagsProvider {
    public BlockTagProvider(DataGenerator generatorIn, ExistingFileHelper existingFileHelper) {
        super(generatorIn, "tconstruct", existingFileHelper);
    }

    protected void m_6577_() {
        this.addCommon();
        this.addTools();
        this.addWorld();
        this.addSmeltery();
        this.addFluids();
        this.addHarvest();
    }

    private void addCommon() {
        this.addMetalTags(TinkerMaterials.cobalt, true);
        this.addMetalTags(TinkerMaterials.slimesteel, false);
        this.addMetalTags(TinkerMaterials.tinkersBronze, false);
        this.addMetalTags(TinkerMaterials.roseGold, false);
        this.addMetalTags(TinkerMaterials.pigIron, false);
        this.addMetalTags(TinkerMaterials.queensSlime, true);
        this.addMetalTags(TinkerMaterials.manyullyn, true);
        this.addMetalTags(TinkerMaterials.hepatizon, true);
        this.addMetalTags(TinkerMaterials.soulsteel, true);
        this.addMetalTags(TinkerMaterials.knightslime, false);
        this.m_126548_((Tag.Named)Tags.Blocks.GLASS_COLORLESS).m_126582_((Object)((Block)TinkerCommons.clearGlass.get()));
        this.m_126548_((Tag.Named)Tags.Blocks.GLASS_PANES_COLORLESS).m_126582_((Object)((Block)TinkerCommons.clearGlassPane.get()));
        this.addGlass(TinkerCommons.clearStainedGlass, "glass/", (TagsProvider.TagAppender<Block>)this.m_126548_((Tag.Named)Tags.Blocks.STAINED_GLASS));
        this.addGlass(TinkerCommons.clearStainedGlassPane, "glass_panes/", (TagsProvider.TagAppender<Block>)this.m_126548_((Tag.Named)Tags.Blocks.STAINED_GLASS_PANES));
        TagsProvider.TagAppender impermeable = this.m_126548_(BlockTags.f_13049_);
        impermeable.m_126584_((Object[])new Block[]{(Block)TinkerCommons.clearGlass.get(), (Block)TinkerCommons.soulGlass.get(), (Block)TinkerSmeltery.searedGlass.get(), (Block)TinkerCommons.clearTintedGlass.get()});
        TinkerCommons.clearStainedGlass.values().forEach(arg_0 -> ((TagsProvider.TagAppender)impermeable).m_126582_(arg_0));
        this.m_126548_(BlockTags.f_13080_).m_126584_((Object[])new Block[]{(Block)TinkerCommons.soulGlass.get(), (Block)TinkerCommons.soulGlassPane.get()});
        this.m_126548_(BlockTags.f_13085_).m_126582_((Object)((Block)TinkerCommons.soulGlass.get()));
        TagsProvider.TagAppender builder = this.m_126548_((Tag.Named)TinkerTags.Blocks.ANVIL_METAL).m_126580_((Tag.Named)TinkerMaterials.slimesteel.getBlockTag()).m_126580_((Tag.Named)TinkerMaterials.tinkersBronze.getBlockTag()).m_126580_((Tag.Named)TinkerMaterials.roseGold.getBlockTag()).m_126580_((Tag.Named)TinkerMaterials.pigIron.getBlockTag()).m_126580_((Tag.Named)TinkerMaterials.queensSlime.getBlockTag()).m_126580_((Tag.Named)TinkerMaterials.manyullyn.getBlockTag()).m_126580_((Tag.Named)TinkerMaterials.hepatizon.getBlockTag()).m_126580_((Tag.Named)Tags.Blocks.STORAGE_BLOCKS_NETHERITE);
        for (SmelteryCompat compat : SmelteryCompat.values()) {
            if (compat.isOre()) continue;
            builder.m_176841_(new ResourceLocation("forge", "storage_blocks/" + compat.getName()));
        }
        this.m_126548_((Tag.Named)TinkerTags.Blocks.PLANKLIKE).m_126580_(BlockTags.f_13090_).m_126584_((Object[])new Block[]{(Block)TinkerCommons.lavawood.get(), (Block)TinkerCommons.blazewood.get(), (Block)TinkerMaterials.nahuatl.get()});
        this.m_126548_((Tag.Named)TinkerTags.Blocks.PLATFORM_CONNECTIONS).m_126584_((Object[])new Block[]{Blocks.f_50164_, Blocks.f_50155_, Blocks.f_50183_, (Block)TinkerCommons.goldBars.get(), Blocks.f_50266_, Blocks.f_50082_, Blocks.f_50140_, Blocks.f_50123_, Blocks.f_50088_}).addTags(new Tag.Named[]{Tags.Blocks.GLASS_PANES, BlockTags.f_13093_, Tags.Blocks.FENCES, BlockTags.f_13032_, BlockTags.f_13067_});
        TagsProvider.TagAppender copperPlatforms = this.m_126548_((Tag.Named)TinkerTags.Blocks.COPPER_PLATFORMS);
        TinkerCommons.copperPlatform.forEach(block -> copperPlatforms.m_126582_((Object)block));
        TinkerCommons.waxedCopperPlatform.forEach(block -> copperPlatforms.m_126582_((Object)block));
    }

    private void addTools() {
        this.m_126548_((Tag.Named)TinkerTags.Blocks.WORKBENCHES).m_126584_((Object[])new Block[]{Blocks.f_50091_, (Block)TinkerTables.craftingStation.get()}).m_176841_(new ResourceLocation("forge:workbench"));
        this.m_126548_((Tag.Named)TinkerTags.Blocks.TABLES).m_126584_((Object[])new Block[]{(Block)TinkerTables.craftingStation.get(), (Block)TinkerTables.partBuilder.get(), (Block)TinkerTables.tinkerStation.get()});
        this.m_126548_((Tag.Named)TinkerTags.Blocks.HARVESTABLE_STACKABLE).m_126584_((Object[])new Block[]{Blocks.f_50130_, Blocks.f_50576_});
        this.m_126548_((Tag.Named)TinkerTags.Blocks.HARVESTABLE_CROPS).m_126580_(BlockTags.f_13073_).m_176841_(new ResourceLocation("forge", "crops")).m_126582_((Object)Blocks.f_50200_);
        this.m_126548_((Tag.Named)TinkerTags.Blocks.HARVESTABLE_INTERACT).m_126582_((Object)Blocks.f_50685_);
        this.m_126548_((Tag.Named)TinkerTags.Blocks.HARVESTABLE).m_126584_((Object[])new Block[]{Blocks.f_50133_, Blocks.f_50718_, Blocks.f_50717_}).m_126580_(TinkerTags.Blocks.HARVESTABLE_CROPS).m_126580_(TinkerTags.Blocks.HARVESTABLE_INTERACT).m_126580_(TinkerTags.Blocks.HARVESTABLE_STACKABLE);
        this.m_126548_((Tag.Named)TinkerTags.Blocks.TREE_LOGS).m_126580_(BlockTags.f_13106_);
        this.m_126548_((Tag.Named)TinkerTags.Blocks.CHRYSOPHILITE_ORES).m_126580_((Tag.Named)Tags.Blocks.ORES_GOLD).m_126582_((Object)Blocks.f_50706_);
    }

    private void addWorld() {
        this.m_126548_((Tag.Named)TinkerTags.Blocks.ORES_COBALT).m_126582_((Object)((Block)TinkerWorld.cobaltOre.get()));
        this.m_126548_((Tag.Named)Tags.Blocks.ORES).m_126580_(TinkerTags.Blocks.ORES_COBALT);
        this.m_126548_((Tag.Named)TinkerTags.Blocks.RAW_BLOCK_COBALT).m_126582_((Object)((Block)TinkerWorld.rawCobaltBlock.get()));
        this.m_126548_((Tag.Named)Tags.Blocks.STORAGE_BLOCKS).m_126580_(TinkerTags.Blocks.RAW_BLOCK_COBALT);
        this.m_126548_((Tag.Named)Tags.Blocks.STORAGE_BLOCKS_COPPER).remove((Object)Blocks.f_152510_);
        TagsProvider.TagAppender endermanHoldable = this.m_126548_(BlockTags.f_13046_);
        endermanHoldable.m_126580_(TinkerTags.Blocks.CONGEALED_SLIME).m_126584_((Object[])new Block[]{(Block)TinkerSmeltery.grout.get(), (Block)TinkerSmeltery.netherGrout.get()});
        this.m_126548_((Tag.Named)TinkerTags.Blocks.SLIMY_LOGS).m_126580_((Tag.Named)TinkerWorld.greenheart.getLogBlockTag()).m_126580_((Tag.Named)TinkerWorld.skyroot.getLogBlockTag()).m_126580_((Tag.Named)TinkerWorld.bloodshroom.getLogBlockTag());
        this.m_126548_((Tag.Named)TinkerTags.Blocks.SLIMY_PLANKS).m_126584_((Object[])new Block[]{(Block)TinkerWorld.greenheart.get(), (Block)TinkerWorld.skyroot.get(), (Block)TinkerWorld.bloodshroom.get()});
        this.m_126548_(BlockTags.f_13090_).m_126580_(TinkerTags.Blocks.SLIMY_PLANKS);
        this.m_126548_(BlockTags.f_13106_).m_126580_(TinkerTags.Blocks.SLIMY_LOGS);
        this.addWoodTags(TinkerWorld.greenheart, false);
        this.addWoodTags(TinkerWorld.skyroot, false);
        this.addWoodTags(TinkerWorld.bloodshroom, false);
        TagsProvider.TagAppender slimeBlockTagAppender = this.m_126548_((Tag.Named)TinkerTags.Blocks.SLIME_BLOCK);
        TagsProvider.TagAppender congealedTagAppender = this.m_126548_((Tag.Named)TinkerTags.Blocks.CONGEALED_SLIME);
        for (SlimeType slimeType : SlimeType.values()) {
            slimeBlockTagAppender.m_126582_((Object)((Block)TinkerWorld.slime.get((Enum)slimeType)));
            congealedTagAppender.m_126582_((Object)((Block)TinkerWorld.congealedSlime.get((Enum)slimeType)));
        }
        TagsProvider.TagAppender leavesTagAppender = this.m_126548_((Tag.Named)TinkerTags.Blocks.SLIMY_LEAVES);
        TagsProvider.TagAppender wartTagAppender = this.m_126548_(BlockTags.f_13078_);
        TagsProvider.TagAppender saplingTagAppender = this.m_126548_((Tag.Named)TinkerTags.Blocks.SLIMY_SAPLINGS);
        for (SlimeType type3 : SlimeType.values()) {
            if (type3.isNether()) {
                wartTagAppender.m_126582_((Object)((Block)TinkerWorld.slimeLeaves.get((Enum)type3)));
                endermanHoldable.m_126582_((Object)((Block)TinkerWorld.slimeSapling.get((Enum)type3)));
                continue;
            }
            leavesTagAppender.m_126582_((Object)((Block)TinkerWorld.slimeLeaves.get((Enum)type3)));
            saplingTagAppender.m_126582_((Object)((Block)TinkerWorld.slimeSapling.get((Enum)type3)));
        }
        this.m_126548_(BlockTags.f_13035_).m_126580_(TinkerTags.Blocks.SLIMY_LEAVES);
        this.m_126548_(BlockTags.f_13104_).m_126580_(TinkerTags.Blocks.SLIMY_SAPLINGS);
        TagsProvider.TagAppender tagAppender = this.m_126548_((Tag.Named)TinkerTags.Blocks.SLIMY_GRASS);
        TagsProvider.TagAppender slimyNylium = this.m_126548_((Tag.Named)TinkerTags.Blocks.SLIMY_NYLIUM);
        TagsProvider.TagAppender slimySoil = this.m_126548_((Tag.Named)TinkerTags.Blocks.SLIMY_SOIL);
        for (SlimeType type4 : SlimeType.values()) {
            (type4.isNether() ? slimyNylium : tagAppender).m_126580_(type4.getGrassBlockTag());
            slimySoil.m_126580_(type4.getDirtBlockTag());
        }
        TinkerWorld.slimeGrass.forEach((dirtType, blockObj) -> blockObj.forEach((grassType, block) -> {
            this.m_126548_((Tag.Named)grassType.getGrassBlockTag()).m_126582_(block);
            this.m_126548_((Tag.Named)dirtType.getDirtBlockTag()).m_126582_(block);
        }));
        TinkerWorld.slimeDirt.forEach((type, block) -> this.m_126548_((Tag.Named)type.getDirtBlockTag()).m_126582_(block));
        endermanHoldable.m_126580_(TinkerTags.Blocks.SLIMY_SOIL);
        this.m_126548_((Tag.Named)TinkerTags.Blocks.SKY_SLIME_SPAWN).m_126584_((Object[])new Block[]{TinkerWorld.earthGeode.getBlock(), TinkerWorld.earthGeode.getBudding()}).m_126580_(SlimeType.SKY.getGrassBlockTag());
        this.m_126548_((Tag.Named)TinkerTags.Blocks.EARTH_SLIME_SPAWN).m_126584_((Object[])new Block[]{TinkerWorld.skyGeode.getBlock(), TinkerWorld.skyGeode.getBudding()}).m_126580_(SlimeType.EARTH.getGrassBlockTag());
        this.m_126548_((Tag.Named)TinkerTags.Blocks.ENDER_SLIME_SPAWN).m_126584_((Object[])new Block[]{TinkerWorld.enderGeode.getBlock(), TinkerWorld.enderGeode.getBudding()}).m_126580_(SlimeType.ENDER.getGrassBlockTag());
        this.m_126548_(BlockTags.f_13088_).m_126584_((Object[])new Block[]{(Block)TinkerTables.castChest.get(), (Block)TinkerCommons.goldBars.get(), (Block)TinkerCommons.goldPlatform.get(), (Block)TinkerWorld.heads.get((Enum)TinkerHeadType.PIGLIN), (Block)TinkerWorld.heads.get((Enum)TinkerHeadType.PIGLIN_BRUTE), (Block)TinkerWorld.wallHeads.get((Enum)TinkerHeadType.PIGLIN), (Block)TinkerWorld.wallHeads.get((Enum)TinkerHeadType.PIGLIN_BRUTE)});
        this.m_126548_(BlockTags.f_13042_).m_126584_((Object[])new Block[]{(Block)TinkerWorld.heads.get((Enum)TinkerHeadType.ZOMBIFIED_PIGLIN), (Block)TinkerWorld.wallHeads.get((Enum)TinkerHeadType.ZOMBIFIED_PIGLIN)});
    }

    private void addSmeltery() {
        this.m_126548_((Tag.Named)TinkerTags.Blocks.SEARED_BRICKS).m_126584_((Object[])new Block[]{(Block)TinkerSmeltery.searedBricks.get(), (Block)TinkerSmeltery.searedFancyBricks.get(), (Block)TinkerSmeltery.searedTriangleBricks.get()});
        this.m_126548_((Tag.Named)TinkerTags.Blocks.SEARED_BLOCKS).m_126584_((Object[])new Block[]{(Block)TinkerSmeltery.searedStone.get(), (Block)TinkerSmeltery.searedCrackedBricks.get(), (Block)TinkerSmeltery.searedCobble.get(), (Block)TinkerSmeltery.searedPaver.get()}).m_126580_(TinkerTags.Blocks.SEARED_BRICKS);
        this.m_126548_(BlockTags.f_13032_).m_126584_((Object[])new Block[]{TinkerSmeltery.searedBricks.getWall(), TinkerSmeltery.searedCobble.getWall()});
        this.m_126548_((Tag.Named)TinkerTags.Blocks.SCORCHED_BLOCKS).m_126584_((Object[])new Block[]{(Block)TinkerSmeltery.scorchedStone.get(), (Block)TinkerSmeltery.polishedScorchedStone.get(), (Block)TinkerSmeltery.scorchedBricks.get(), (Block)TinkerSmeltery.scorchedRoad.get(), (Block)TinkerSmeltery.chiseledScorchedBricks.get()});
        this.m_126548_(BlockTags.f_13039_).m_126584_((Object[])new Block[]{TinkerSmeltery.scorchedBricks.getFence(), TinkerMaterials.nahuatl.getFence()});
        this.m_126548_((Tag.Named)TinkerTags.Blocks.CISTERN_CONNECTIONS).m_126584_((Object[])new Block[]{(Block)TinkerSmeltery.searedFaucet.get(), (Block)TinkerSmeltery.scorchedFaucet.get()});
        TagsProvider.TagAppender searedTankTagAppender = this.m_126548_((Tag.Named)TinkerTags.Blocks.SEARED_TANKS);
        TinkerSmeltery.searedTank.values().forEach(arg_0 -> ((TagsProvider.TagAppender)searedTankTagAppender).m_126582_(arg_0));
        TagsProvider.TagAppender scorchedTankTagAppender = this.m_126548_((Tag.Named)TinkerTags.Blocks.SCORCHED_TANKS);
        TinkerSmeltery.scorchedTank.values().forEach(arg_0 -> ((TagsProvider.TagAppender)scorchedTankTagAppender).m_126582_(arg_0));
        this.m_126548_((Tag.Named)TinkerTags.Blocks.HEATER_CONTROLLERS).m_126584_((Object[])new Block[]{(Block)TinkerSmeltery.searedMelter.get(), (Block)TinkerSmeltery.scorchedAlloyer.get()});
        this.m_126548_((Tag.Named)TinkerTags.Blocks.FUEL_TANKS).m_126582_((Object)((Block)TinkerSmeltery.searedHeater.get())).m_126580_(TinkerTags.Blocks.SEARED_TANKS).m_126580_(TinkerTags.Blocks.SCORCHED_TANKS);
        this.m_126548_((Tag.Named)TinkerTags.Blocks.SMELTERY_TANKS).m_126580_(TinkerTags.Blocks.SEARED_TANKS);
        this.m_126548_((Tag.Named)TinkerTags.Blocks.FOUNDRY_TANKS).m_126580_(TinkerTags.Blocks.SCORCHED_TANKS);
        this.m_126548_((Tag.Named)TinkerTags.Blocks.ALLOYER_TANKS).m_126584_((Object[])new Block[]{(Block)TinkerSmeltery.scorchedAlloyer.get(), (Block)TinkerSmeltery.searedMelter.get()}).m_126580_(TinkerTags.Blocks.SEARED_TANKS).m_126580_(TinkerTags.Blocks.SCORCHED_TANKS);
        this.m_126548_((Tag.Named)TinkerTags.Blocks.SMELTERY_FLOOR).m_126580_(TinkerTags.Blocks.SEARED_BLOCKS).m_126584_((Object[])new Block[]{(Block)TinkerSmeltery.searedDrain.get(), (Block)TinkerSmeltery.searedChute.get(), (Block)TinkerSmeltery.searedDuct.get()});
        this.m_126548_((Tag.Named)TinkerTags.Blocks.SMELTERY_WALL).m_126580_(TinkerTags.Blocks.SEARED_BLOCKS).m_126580_(TinkerTags.Blocks.SMELTERY_TANKS).m_126584_((Object[])new Block[]{(Block)TinkerSmeltery.searedGlass.get(), (Block)TinkerSmeltery.searedLadder.get(), (Block)TinkerSmeltery.searedDrain.get(), (Block)TinkerSmeltery.searedChute.get(), (Block)TinkerSmeltery.searedDuct.get()});
        this.m_126548_((Tag.Named)TinkerTags.Blocks.SMELTERY).m_126580_(TinkerTags.Blocks.SMELTERY_WALL).m_126580_(TinkerTags.Blocks.SMELTERY_FLOOR).m_126580_(TinkerTags.Blocks.SMELTERY_TANKS);
        this.m_126548_((Tag.Named)TinkerTags.Blocks.FOUNDRY_FLOOR).m_126580_(TinkerTags.Blocks.SCORCHED_BLOCKS).m_126584_((Object[])new Block[]{(Block)TinkerSmeltery.scorchedDrain.get(), (Block)TinkerSmeltery.scorchedChute.get(), (Block)TinkerSmeltery.scorchedDuct.get()});
        this.m_126548_((Tag.Named)TinkerTags.Blocks.FOUNDRY_WALL).m_126580_(TinkerTags.Blocks.SCORCHED_BLOCKS).m_126580_(TinkerTags.Blocks.FOUNDRY_TANKS).m_126584_((Object[])new Block[]{(Block)TinkerSmeltery.scorchedGlass.get(), (Block)TinkerSmeltery.scorchedLadder.get(), (Block)TinkerSmeltery.scorchedDrain.get(), (Block)TinkerSmeltery.scorchedChute.get(), (Block)TinkerSmeltery.scorchedDuct.get()});
        this.m_126548_((Tag.Named)TinkerTags.Blocks.FOUNDRY).m_126580_(TinkerTags.Blocks.FOUNDRY_WALL).m_126580_(TinkerTags.Blocks.FOUNDRY_FLOOR).m_126580_(TinkerTags.Blocks.FOUNDRY_TANKS);
        this.m_126548_(BlockTags.f_13082_).m_126584_((Object[])new Block[]{(Block)TinkerSmeltery.searedLadder.get(), (Block)TinkerSmeltery.scorchedLadder.get()});
        this.m_126548_(BlockTags.f_13069_).m_126582_((Object)((Block)TinkerCommons.obsidianPane.get()));
    }

    private void addFluids() {
        this.m_126548_(BlockTags.f_13086_).m_126584_((Object[])new Block[]{TinkerFluids.magma.getBlock(), TinkerFluids.blazingBlood.getBlock()});
    }

    private void addHarvest() {
        this.tagBlocks((Tag.Named<Block>)BlockTags.f_144283_, TinkerCommons.mudBricks);
        this.tagBlocks((Tag.Named<Block>)BlockTags.f_144280_, TinkerCommons.lavawood, TinkerCommons.blazewood);
        this.tagBlocks((Tag.Named<Block>)BlockTags.f_144282_, (Tag.Named<Block>)BlockTags.f_144284_, new Supplier[]{TinkerCommons.obsidianPane});
        this.tagBlocks((Tag.Named<Block>)BlockTags.f_144282_, (Tag.Named<Block>)BlockTags.f_144286_, new Supplier[]{TinkerCommons.ironPlatform});
        this.tagBlocks((Tag.Named<Block>)BlockTags.f_144282_, (Tag.Named<Block>)BlockTags.f_144285_, new Supplier[]{TinkerCommons.goldBars, TinkerCommons.goldPlatform, TinkerCommons.cobaltPlatform});
        this.m_126548_(BlockTags.f_144282_).m_126580_(TinkerTags.Blocks.COPPER_PLATFORMS);
        this.m_126548_(BlockTags.f_144286_).m_126580_(TinkerTags.Blocks.COPPER_PLATFORMS);
        this.tagBlocks((Tag.Named<Block>)BlockTags.f_144280_, (Tag.Named<Block>)BlockTags.f_144284_, new BuildingBlockObject[]{TinkerMaterials.nahuatl});
        this.tagBlocks((Tag.Named<Block>)BlockTags.f_144282_, (Tag.Named<Block>)BlockTags.f_144285_, new Supplier[]{TinkerWorld.cobaltOre, TinkerWorld.rawCobaltBlock, TinkerMaterials.cobalt, TinkerMaterials.slimesteel, TinkerMaterials.tinkersBronze, TinkerMaterials.roseGold, TinkerMaterials.pigIron});
        this.tagBlocks((Tag.Named<Block>)BlockTags.f_144282_, (Tag.Named<Block>)BlockTags.f_144284_, new Supplier[]{TinkerMaterials.queensSlime, TinkerMaterials.manyullyn, TinkerMaterials.hepatizon, TinkerMaterials.soulsteel, TinkerModifiers.silkyJewelBlock});
        this.tagBlocks((Tag.Named<Block>)BlockTags.f_144282_, (Tag.Named<Block>)Tags.Blocks.NEEDS_NETHERITE_TOOL, new Supplier[]{TinkerMaterials.knightslime});
        this.tagBlocks((Tag.Named<Block>)BlockTags.f_144283_, TinkerWorld.congealedSlime, TinkerWorld.slimeDirt, TinkerWorld.vanillaSlimeGrass, TinkerWorld.earthSlimeGrass, TinkerWorld.skySlimeGrass, TinkerWorld.enderSlimeGrass, TinkerWorld.ichorSlimeGrass);
        TinkerWorld.slimeDirt.forEach((type, block) -> this.m_126548_((Tag.Named)Objects.requireNonNull(type.getHarvestTier().getTag())).m_126582_(block));
        for (SlimeType dirt : SlimeType.values()) {
            for (SlimeType grass : SlimeType.values()) {
                Tiers dirtTier = dirt.getHarvestTier();
                Tiers grassTier = grass.getHarvestTier();
                Tiers tier = dirtTier.m_6604_() == grassTier.m_6604_() ? (dirtTier.ordinal() > grassTier.ordinal() ? dirtTier : grassTier) : (dirtTier.m_6604_() > grassTier.m_6604_() ? dirtTier : grassTier);
                this.m_126548_((Tag.Named)Objects.requireNonNull(tier.getTag())).m_126582_((Object)((Block)TinkerWorld.slimeGrass.get((Object)dirt).get((Enum)grass)));
            }
        }
        this.tagBlocks((Tag.Named<Block>)BlockTags.f_144281_, TinkerWorld.slimeLeaves);
        this.tagLogs((Tag.Named<Block>)BlockTags.f_144280_, (Tag.Named<Block>)Tags.Blocks.NEEDS_GOLD_TOOL, TinkerWorld.skyroot);
        this.tagLogs((Tag.Named<Block>)BlockTags.f_144280_, (Tag.Named<Block>)BlockTags.f_144286_, TinkerWorld.greenheart);
        this.tagLogs((Tag.Named<Block>)BlockTags.f_144280_, (Tag.Named<Block>)BlockTags.f_144285_, TinkerWorld.bloodshroom);
        this.tagPlanks((Tag.Named<Block>)BlockTags.f_144283_, TinkerWorld.greenheart, TinkerWorld.skyroot, TinkerWorld.bloodshroom);
        this.tagBlocks((Tag.Named<Block>)BlockTags.f_144280_, new Supplier[]{TinkerWorld.skySlimeVine, TinkerWorld.enderSlimeVine});
        this.tagBlocks((Tag.Named<Block>)BlockTags.f_144282_, TinkerWorld.earthGeode, TinkerWorld.skyGeode, TinkerWorld.ichorGeode, TinkerWorld.enderGeode);
        this.tagBlocks((Tag.Named<Block>)BlockTags.f_144283_, new Supplier[]{TinkerSmeltery.grout, TinkerSmeltery.netherGrout});
        this.tagBlocks((Tag.Named<Block>)BlockTags.f_144282_, (Tag.Named<Block>)Tags.Blocks.NEEDS_GOLD_TOOL, new BuildingBlockObject[]{TinkerSmeltery.searedStone, TinkerSmeltery.searedPaver, TinkerSmeltery.searedCobble, TinkerSmeltery.searedBricks});
        this.tagBlocks((Tag.Named<Block>)BlockTags.f_144282_, (Tag.Named<Block>)Tags.Blocks.NEEDS_GOLD_TOOL, new Supplier[]{TinkerSmeltery.searedCrackedBricks, TinkerSmeltery.searedFancyBricks, TinkerSmeltery.searedLadder, TinkerSmeltery.searedGlass, TinkerSmeltery.searedGlassPane});
        this.tagBlocks((Tag.Named<Block>)BlockTags.f_144282_, (Tag.Named<Block>)Tags.Blocks.NEEDS_GOLD_TOOL, new BuildingBlockObject[]{TinkerSmeltery.scorchedBricks, TinkerSmeltery.scorchedRoad});
        this.tagBlocks((Tag.Named<Block>)BlockTags.f_144282_, (Tag.Named<Block>)Tags.Blocks.NEEDS_GOLD_TOOL, new Supplier[]{TinkerSmeltery.scorchedStone, TinkerSmeltery.polishedScorchedStone, TinkerSmeltery.chiseledScorchedBricks, TinkerSmeltery.scorchedLadder, TinkerSmeltery.scorchedGlass, TinkerSmeltery.scorchedGlassPane});
        this.tagBlocks((Tag.Named<Block>)BlockTags.f_144282_, (Tag.Named<Block>)Tags.Blocks.NEEDS_GOLD_TOOL, TinkerSmeltery.searedTank, TinkerSmeltery.scorchedTank);
        this.tagBlocks((Tag.Named<Block>)BlockTags.f_144282_, (Tag.Named<Block>)Tags.Blocks.NEEDS_GOLD_TOOL, new Supplier[]{TinkerSmeltery.searedLantern, TinkerSmeltery.searedFaucet, TinkerSmeltery.searedChannel, TinkerSmeltery.searedBasin, TinkerSmeltery.searedTable});
        this.tagBlocks((Tag.Named<Block>)BlockTags.f_144282_, (Tag.Named<Block>)Tags.Blocks.NEEDS_GOLD_TOOL, new Supplier[]{TinkerSmeltery.scorchedLantern, TinkerSmeltery.scorchedFaucet, TinkerSmeltery.scorchedChannel, TinkerSmeltery.scorchedBasin, TinkerSmeltery.scorchedTable});
        this.tagBlocks((Tag.Named<Block>)BlockTags.f_144282_, (Tag.Named<Block>)Tags.Blocks.NEEDS_GOLD_TOOL, new Supplier[]{TinkerSmeltery.searedHeater, TinkerSmeltery.searedMelter, TinkerSmeltery.scorchedAlloyer});
        this.tagBlocks((Tag.Named<Block>)BlockTags.f_144282_, (Tag.Named<Block>)BlockTags.f_144286_, new Supplier[]{TinkerSmeltery.searedDrain, TinkerSmeltery.searedChute, TinkerSmeltery.smelteryController});
        this.tagBlocks((Tag.Named<Block>)BlockTags.f_144282_, (Tag.Named<Block>)BlockTags.f_144285_, new Supplier[]{TinkerSmeltery.searedDuct, TinkerSmeltery.scorchedDuct});
        this.tagBlocks((Tag.Named<Block>)BlockTags.f_144282_, (Tag.Named<Block>)BlockTags.f_144284_, new Supplier[]{TinkerSmeltery.scorchedDrain, TinkerSmeltery.scorchedDuct, TinkerSmeltery.foundryController});
        this.tagBlocks((Tag.Named<Block>)BlockTags.f_144280_, new Supplier[]{TinkerTables.craftingStation, TinkerTables.tinkerStation, TinkerTables.partBuilder, TinkerTables.tinkersChest, TinkerTables.partChest});
        this.tagBlocks((Tag.Named<Block>)BlockTags.f_144282_, (Tag.Named<Block>)BlockTags.f_144286_, new Supplier[]{TinkerTables.castChest});
        this.tagBlocks((Tag.Named<Block>)BlockTags.f_144282_, (Tag.Named<Block>)BlockTags.f_144285_, new Supplier[]{TinkerTables.tinkersAnvil, TinkerTables.scorchedAnvil});
        this.m_126548_((Tag.Named)TinkerTags.Blocks.MINABLE_WITH_MATTOCK).addTags(new Tag.Named[]{BlockTags.f_144283_, BlockTags.f_13106_}).m_126584_((Object[])new Block[]{Blocks.f_152541_, Blocks.f_50571_, Blocks.f_152475_, Blocks.f_50191_, Blocks.f_50717_, Blocks.f_50718_, Blocks.f_50143_, Blocks.f_50144_, Blocks.f_50133_, Blocks.f_50491_, Blocks.f_50490_, Blocks.f_50262_, Blocks.f_50180_, Blocks.f_50182_, Blocks.f_50181_});
        this.m_126548_((Tag.Named)TinkerTags.Blocks.MINABLE_WITH_PICKADZE).addTags(new Tag.Named[]{BlockTags.f_144283_, BlockTags.f_144282_});
        this.m_126548_((Tag.Named)TinkerTags.Blocks.MINABLE_WITH_HAND_AXE).addTags(new Tag.Named[]{BlockTags.f_144280_, BlockTags.f_13035_});
        this.m_126548_((Tag.Named)TinkerTags.Blocks.MINABLE_WITH_SHEARS).m_126584_((Object[])new Block[]{Blocks.f_50033_, Blocks.f_50088_, Blocks.f_50267_, Blocks.f_50191_, Blocks.f_152475_}).addTags(new Tag.Named[]{BlockTags.f_13035_, BlockTags.f_13089_});
        this.m_126548_((Tag.Named)TinkerTags.Blocks.MINABLE_WITH_SCYTHE).addTags(new Tag.Named[]{BlockTags.f_144281_, TinkerTags.Blocks.MINABLE_WITH_SHEARS});
        this.m_126548_((Tag.Named)TinkerTags.Blocks.MINABLE_WITH_SWORD).m_126582_((Object)Blocks.f_50033_).m_126584_((Object[])new Block[]{Blocks.f_50262_, Blocks.f_50490_, Blocks.f_50491_, Blocks.f_50685_, Blocks.f_50191_, Blocks.f_152543_, Blocks.f_152544_, Blocks.f_152545_, Blocks.f_152546_, Blocks.f_152475_, Blocks.f_50133_, Blocks.f_50143_, Blocks.f_50186_}).addTags(new Tag.Named[]{BlockTags.f_13035_, BlockTags.f_13104_, BlockTags.f_13041_, BlockTags.f_13073_});
        this.m_126548_((Tag.Named)TinkerTags.Blocks.MINABLE_WITH_DAGGER).addTags(new Tag.Named[]{BlockTags.f_144281_, TinkerTags.Blocks.MINABLE_WITH_SWORD});
    }

    public String m_6055_() {
        return "Tinkers Construct Block Tags";
    }

    @SafeVarargs
    private void tagBlocks(Tag.Named<Block> tag, Supplier<? extends Block> ... blocks) {
        TagsProvider.TagAppender appender = this.m_126548_(tag);
        for (Supplier<? extends Block> block : blocks) {
            appender.m_126582_((Object)block.get());
        }
    }

    private void tagBlocks(Tag.Named<Block> tag, GeodeItemObject ... blocks) {
        TagsProvider.TagAppender appender = this.m_126548_(tag);
        for (GeodeItemObject geode : blocks) {
            appender.m_126582_((Object)geode.getBlock());
            appender.m_126582_((Object)geode.getBudding());
            for (GeodeItemObject.BudSize size : GeodeItemObject.BudSize.values()) {
                appender.m_126582_((Object)geode.getBud(size));
            }
        }
    }

    private void tagBlocks(Tag.Named<Block> tag1, Tag.Named<Block> tag2, Supplier<? extends Block> ... blocks) {
        this.tagBlocks(tag1, blocks);
        this.tagBlocks(tag2, blocks);
    }

    @SafeVarargs
    private void tagBlocks(Tag.Named<Block> tag, EnumObject<?, ? extends Block> ... blocks) {
        TagsProvider.TagAppender appender = this.m_126548_(tag);
        for (EnumObject<?, ? extends Block> block : blocks) {
            block.forEach(b -> appender.m_126582_(b));
        }
    }

    @SafeVarargs
    private void tagBlocks(Tag.Named<Block> tag1, Tag.Named<Block> tag2, EnumObject<?, ? extends Block> ... blocks) {
        this.tagBlocks(tag1, blocks);
        this.tagBlocks(tag2, blocks);
    }

    private void tagBlocks(Tag.Named<Block> tag, BuildingBlockObject ... blocks) {
        TagsProvider.TagAppender appender = this.m_126548_(tag);
        for (BuildingBlockObject block : blocks) {
            block.values().forEach(arg_0 -> ((TagsProvider.TagAppender)appender).m_126582_(arg_0));
        }
    }

    private void tagBlocks(Tag.Named<Block> tag1, Tag.Named<Block> tag2, BuildingBlockObject ... blocks) {
        this.tagBlocks(tag1, blocks);
        this.tagBlocks(tag2, blocks);
    }

    private void tagLogs(Tag.Named<Block> tag1, Tag.Named<Block> tag2, WoodBlockObject ... blocks) {
        for (WoodBlockObject block : blocks) {
            this.m_126548_(tag1).m_126584_((Object[])new Block[]{block.getLog(), block.getWood()});
            this.m_126548_(tag2).m_126584_((Object[])new Block[]{block.getLog(), block.getWood()});
        }
    }

    private void tagPlanks(Tag.Named<Block> tag, WoodBlockObject ... blocks) {
        for (WoodBlockObject block : blocks) {
            this.m_126548_(tag).m_126584_((Object[])new Block[]{(Block)block.get(), block.getSlab(), block.getStairs(), block.getFence(), block.getStrippedLog(), block.getStrippedWood(), block.getFenceGate(), block.getDoor(), block.getTrapdoor(), block.getPressurePlate(), block.getButton(), block.getSign(), block.getWallSign()});
        }
    }

    private void addMetalTags(MetalItemObject metal, boolean beacon) {
        this.m_126548_((Tag.Named)metal.getBlockTag()).m_126582_((Object)((Block)metal.get()));
        if (beacon) {
            this.m_126548_(BlockTags.f_13079_).m_126580_((Tag.Named)metal.getBlockTag());
        }
        this.m_126548_((Tag.Named)Tags.Blocks.STORAGE_BLOCKS).m_126580_((Tag.Named)metal.getBlockTag());
    }

    private void addGlass(EnumObject<ClearStainedGlassBlock.GlassColor, ? extends Block> blockObj, String tagPrefix, TagsProvider.TagAppender<Block> blockTag) {
        blockObj.forEach((color, block) -> {
            blockTag.m_126582_(block);
            this.m_126548_((Tag.Named)BlockTags.createOptional((ResourceLocation)new ResourceLocation("forge", tagPrefix + color.m_7912_()))).m_126582_(block);
        });
    }

    private void addWoodTags(WoodBlockObject object, boolean doesBurn) {
        this.m_126548_(BlockTags.f_13097_).m_126582_((Object)object.getSlab());
        this.m_126548_(BlockTags.f_13096_).m_126582_((Object)object.getStairs());
        this.m_126548_((Tag.Named)object.getLogBlockTag()).m_126584_((Object[])new Block[]{object.getLog(), object.getStrippedLog(), object.getWood(), object.getStrippedWood()});
        this.m_126548_(BlockTags.f_13098_).m_126582_((Object)object.getFence());
        this.m_126548_((Tag.Named)Tags.Blocks.FENCES_WOODEN).m_126582_((Object)object.getFence());
        this.m_126548_(BlockTags.f_13055_).m_126582_((Object)object.getFenceGate());
        this.m_126548_((Tag.Named)Tags.Blocks.FENCE_GATES_WOODEN).m_126582_((Object)object.getFenceGate());
        this.m_126548_(BlockTags.f_13095_).m_126582_((Object)object.getDoor());
        this.m_126548_(BlockTags.f_13102_).m_126582_((Object)object.getTrapdoor());
        this.m_126548_(BlockTags.f_13092_).m_126582_((Object)object.getButton());
        this.m_126548_(BlockTags.f_13100_).m_126582_((Object)object.getPressurePlate());
        if (doesBurn) {
            this.m_126548_(BlockTags.f_13105_).m_126580_((Tag.Named)object.getLogBlockTag());
        } else {
            this.m_126548_(BlockTags.f_13044_).m_126584_((Object[])new Block[]{(Block)object.get(), object.getSlab(), object.getStairs(), object.getFence(), object.getFenceGate(), object.getDoor(), object.getTrapdoor(), object.getPressurePlate(), object.getButton()}).m_126580_((Tag.Named)object.getLogBlockTag());
        }
        this.m_126548_(BlockTags.f_13066_).m_126582_((Object)object.getSign());
        this.m_126548_(BlockTags.f_13067_).m_126582_((Object)object.getWallSign());
    }
}

