/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.book;

import net.minecraft.resources.ResourceLocation;
import slimeknights.mantle.client.book.BookLoader;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.repository.BookRepository;
import slimeknights.mantle.client.book.repository.FileRepository;
import slimeknights.mantle.client.book.transformer.BookTransformer;
import slimeknights.tconstruct.library.TinkerBookIDs;
import slimeknights.tconstruct.library.client.book.content.ContentMaterial;
import slimeknights.tconstruct.library.client.book.content.ContentModifier;
import slimeknights.tconstruct.library.client.book.content.ContentTool;
import slimeknights.tconstruct.library.client.book.sectiontransformer.ModifierSectionTransformer;
import slimeknights.tconstruct.library.client.book.sectiontransformer.ToolSectionTransformer;
import slimeknights.tconstruct.library.client.book.sectiontransformer.materials.SkullMaterialSectionTransformer;
import slimeknights.tconstruct.library.client.book.sectiontransformer.materials.TieredMaterialSectionTransformer;
import slimeknights.tconstruct.shared.item.TinkerBookItem;

public class TinkerBook
extends BookData {
    public static final BookData MATERIALS_AND_YOU = BookLoader.registerBook((ResourceLocation)TinkerBookIDs.MATERIALS_BOOK_ID, (boolean)false, (boolean)false, (BookRepository[])new BookRepository[0]);
    public static final BookData PUNY_SMELTING = BookLoader.registerBook((ResourceLocation)TinkerBookIDs.PUNY_SMELTING_ID, (boolean)false, (boolean)false, (BookRepository[])new BookRepository[0]);
    public static final BookData MIGHTY_SMELTING = BookLoader.registerBook((ResourceLocation)TinkerBookIDs.MIGHTY_SMELTING_ID, (boolean)false, (boolean)false, (BookRepository[])new BookRepository[0]);
    public static final BookData TINKERS_GADGETRY = BookLoader.registerBook((ResourceLocation)TinkerBookIDs.TINKERS_GADGETRY_ID, (boolean)false, (boolean)false, (BookRepository[])new BookRepository[0]);
    public static final BookData FANTASTIC_FOUNDRY = BookLoader.registerBook((ResourceLocation)TinkerBookIDs.FANTASTIC_FOUNDRY_ID, (boolean)false, (boolean)false, (BookRepository[])new BookRepository[0]);
    public static final BookData ENCYCLOPEDIA = BookLoader.registerBook((ResourceLocation)TinkerBookIDs.ENCYCLOPEDIA_ID, (boolean)false, (boolean)false, (BookRepository[])new BookRepository[0]);

    public TinkerBook() {
        super(new BookRepository[0]);
    }

    public static void initBook() {
        BookLoader.registerPageType((ResourceLocation)ContentMaterial.ID, ContentMaterial.class);
        BookLoader.registerPageType((ResourceLocation)ContentTool.ID, ContentTool.class);
        BookLoader.registerPageType((ResourceLocation)ContentModifier.ID, ContentModifier.class);
        ToolSectionTransformer armorTransformer = new ToolSectionTransformer("armor");
        MATERIALS_AND_YOU.addTransformer((BookTransformer)ToolSectionTransformer.INSTANCE);
        MATERIALS_AND_YOU.addTransformer((BookTransformer)armorTransformer);
        MIGHTY_SMELTING.addTransformer((BookTransformer)ToolSectionTransformer.INSTANCE);
        FANTASTIC_FOUNDRY.addTransformer((BookTransformer)armorTransformer);
        TINKERS_GADGETRY.addTransformer((BookTransformer)armorTransformer);
        ENCYCLOPEDIA.addTransformer((BookTransformer)new ToolSectionTransformer("small_tools"));
        ENCYCLOPEDIA.addTransformer((BookTransformer)new ToolSectionTransformer("large_tools"));
        ENCYCLOPEDIA.addTransformer((BookTransformer)armorTransformer);
        MATERIALS_AND_YOU.addTransformer((BookTransformer)new TieredMaterialSectionTransformer("tier_one_materials", 1, false));
        PUNY_SMELTING.addTransformer((BookTransformer)new TieredMaterialSectionTransformer("tier_two_materials", 2, false));
        MIGHTY_SMELTING.addTransformer((BookTransformer)new TieredMaterialSectionTransformer("tier_three_materials", 3, false));
        FANTASTIC_FOUNDRY.addTransformer((BookTransformer)new TieredMaterialSectionTransformer("tier_four_materials", 4, false));
        TINKERS_GADGETRY.addTransformer((BookTransformer)new SkullMaterialSectionTransformer("skull_materials", false));
        ENCYCLOPEDIA.addTransformer((BookTransformer)new TieredMaterialSectionTransformer("tier_one_materials", 1, true));
        ENCYCLOPEDIA.addTransformer((BookTransformer)new TieredMaterialSectionTransformer("tier_two_materials", 2, true));
        ENCYCLOPEDIA.addTransformer((BookTransformer)new TieredMaterialSectionTransformer("tier_three_materials", 3, true));
        ENCYCLOPEDIA.addTransformer((BookTransformer)new TieredMaterialSectionTransformer("tier_four_materials", 4, true));
        ENCYCLOPEDIA.addTransformer((BookTransformer)new SkullMaterialSectionTransformer("skull_materials", true));
        ModifierSectionTransformer upgrades = new ModifierSectionTransformer("upgrades");
        ModifierSectionTransformer defense = new ModifierSectionTransformer("defense");
        ModifierSectionTransformer slotless = new ModifierSectionTransformer("slotless");
        ModifierSectionTransformer abilities = new ModifierSectionTransformer("abilities");
        PUNY_SMELTING.addTransformer((BookTransformer)upgrades);
        PUNY_SMELTING.addTransformer((BookTransformer)slotless);
        MIGHTY_SMELTING.addTransformer((BookTransformer)defense);
        MIGHTY_SMELTING.addTransformer((BookTransformer)abilities);
        ENCYCLOPEDIA.addTransformer((BookTransformer)upgrades);
        ENCYCLOPEDIA.addTransformer((BookTransformer)defense);
        ENCYCLOPEDIA.addTransformer((BookTransformer)slotless);
        ENCYCLOPEDIA.addTransformer((BookTransformer)abilities);
        TinkerBook.addStandardData(MATERIALS_AND_YOU, TinkerBookIDs.MATERIALS_BOOK_ID);
        TinkerBook.addStandardData(PUNY_SMELTING, TinkerBookIDs.PUNY_SMELTING_ID);
        TinkerBook.addStandardData(MIGHTY_SMELTING, TinkerBookIDs.MIGHTY_SMELTING_ID);
        TinkerBook.addStandardData(FANTASTIC_FOUNDRY, TinkerBookIDs.FANTASTIC_FOUNDRY_ID);
        TinkerBook.addStandardData(TINKERS_GADGETRY, TinkerBookIDs.TINKERS_GADGETRY_ID);
        TinkerBook.addStandardData(ENCYCLOPEDIA, TinkerBookIDs.ENCYCLOPEDIA_ID);
    }

    private static void addStandardData(BookData book, ResourceLocation id) {
        book.addRepository((BookRepository)new FileRepository(new ResourceLocation(id.m_135827_(), "book/" + id.m_135815_())));
        book.addTransformer(BookTransformer.indexTranformer());
        book.addTransformer(BookTransformer.paddingTransformer());
    }

    public static BookData getBook(TinkerBookItem.BookType bookType) {
        return switch (bookType) {
            default -> throw new IncompatibleClassChangeError();
            case TinkerBookItem.BookType.MATERIALS_AND_YOU -> MATERIALS_AND_YOU;
            case TinkerBookItem.BookType.PUNY_SMELTING -> PUNY_SMELTING;
            case TinkerBookItem.BookType.MIGHTY_SMELTING -> MIGHTY_SMELTING;
            case TinkerBookItem.BookType.TINKERS_GADGETRY -> TINKERS_GADGETRY;
            case TinkerBookItem.BookType.FANTASTIC_FOUNDRY -> FANTASTIC_FOUNDRY;
            case TinkerBookItem.BookType.ENCYCLOPEDIA -> ENCYCLOPEDIA;
        };
    }
}

