/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.modifiers;

import com.google.common.collect.ImmutableList;
import com.mojang.math.Transformation;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.ItemTextureQuadConverter;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.util.ItemLayerPixels;
import slimeknights.tconstruct.library.client.modifiers.IUnbakedModifierModel;
import slimeknights.tconstruct.library.client.modifiers.NormalModifierModel;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.impl.TankModifier;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class FluidModifierModel
extends NormalModifierModel {
    public static final IUnbakedModifierModel UNBAKED_INSTANCE = (smallGetter, largeGetter) -> {
        Material smallTexture = (Material)smallGetter.apply("");
        Material largeTexture = (Material)largeGetter.apply("");
        Material smallFull = (Material)smallGetter.apply("_full");
        Material largeFull = (Material)largeGetter.apply("_full");
        if (smallTexture != null || largeTexture != null) {
            return new FluidModifierModel(smallTexture, largeTexture, smallFull, largeFull);
        }
        return null;
    };
    protected final Material[] fluidTextures;

    protected FluidModifierModel(@Nullable Material smallTexture, @Nullable Material largeTexture, Material[] fluidTextures) {
        super(smallTexture, largeTexture);
        this.fluidTextures = fluidTextures;
    }

    public FluidModifierModel(@Nullable Material smallTexture, @Nullable Material largeTexture, @Nullable Material smallFull, @Nullable Material largeFull) {
        this(smallTexture, largeTexture, new Material[]{smallFull, largeFull});
    }

    @Override
    @Nullable
    public Object getCacheKey(IToolStackView tool, ModifierEntry entry) {
        TankModifier tank;
        FluidStack fluid;
        Modifier modifier = entry.getModifier();
        if (modifier instanceof TankModifier && !(fluid = (tank = (TankModifier)modifier).getFluid(tool)).isEmpty()) {
            return new FluidModifierCacheKey(tank, fluid.getFluid());
        }
        return entry.getModifier();
    }

    @Nullable
    protected Material getTemplate(TankModifier tank, IToolStackView tool, FluidStack fluid, boolean isLarge) {
        return this.fluidTextures[isLarge ? 1 : 0];
    }

    @Override
    public ImmutableList<BakedQuad> getQuads(IToolStackView tool, ModifierEntry entry, Function<Material, TextureAtlasSprite> spriteGetter, Transformation transforms, boolean isLarge, int startTintIndex, @Nullable ItemLayerPixels pixels) {
        Material template;
        TankModifier tank;
        FluidStack fluid;
        ImmutableList quads = super.getQuads(tool, entry, spriteGetter, transforms, isLarge, startTintIndex, pixels);
        Modifier modifier = entry.getModifier();
        if (modifier instanceof TankModifier && !(fluid = (tank = (TankModifier)modifier).getFluid(tool)).isEmpty() && (template = this.getTemplate(tank, tool, fluid, isLarge)) != null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll(quads);
            FluidAttributes attributes = fluid.getFluid().getAttributes();
            TextureAtlasSprite fluidSprite = spriteGetter.apply(ForgeHooksClient.getBlockMaterial((ResourceLocation)attributes.getStillTexture(fluid)));
            int color = attributes.getColor(fluid);
            int luminosity = attributes.getLuminosity(fluid);
            TextureAtlasSprite templateSprite = spriteGetter.apply(template);
            builder.addAll((Iterable)ItemTextureQuadConverter.convertTexture((Transformation)transforms, (TextureAtlasSprite)templateSprite, (TextureAtlasSprite)fluidSprite, (float)0.468625f, (Direction)Direction.NORTH, (int)color, (int)-1, (int)luminosity));
            builder.addAll((Iterable)ItemTextureQuadConverter.convertTexture((Transformation)transforms, (TextureAtlasSprite)templateSprite, (TextureAtlasSprite)fluidSprite, (float)0.531375f, (Direction)Direction.SOUTH, (int)color, (int)-1, (int)luminosity));
            quads = builder.build();
        }
        return quads;
    }

    private record FluidModifierCacheKey(Modifier modifier, Fluid fluid) {
    }
}

