/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.data.recipe;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.tconstruct.library.data.recipe.IRecipeHelper;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialFluidRecipeBuilder;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipeBuilder;
import slimeknights.tconstruct.library.recipe.melting.MaterialMeltingRecipeBuilder;

public interface IMaterialRecipeHelper
extends IRecipeHelper {
    default public void materialRecipe(Consumer<FinishedRecipe> consumer, MaterialVariantId material, Ingredient input, int value, int needed, String saveName) {
        this.materialRecipe(consumer, material, input, value, needed, null, saveName);
    }

    default public void materialRecipe(Consumer<FinishedRecipe> consumer, MaterialVariantId material, Ingredient input, int value, int needed, @Nullable ItemOutput leftover, String saveName) {
        MaterialRecipeBuilder builder = MaterialRecipeBuilder.materialRecipe(material).setIngredient(input).setValue(value).setNeeded(needed);
        if (leftover != null) {
            builder.setLeftover(leftover);
        }
        builder.save(consumer, this.modResource(saveName));
    }

    default public void metalMaterialRecipe(Consumer<FinishedRecipe> consumer, MaterialVariantId material, String folder, String name, boolean optional) {
        Consumer<FinishedRecipe> wrapped = optional ? this.withCondition(consumer, this.tagCondition("ingots/" + name)) : consumer;
        String matName = material.getLocation('/').m_135815_();
        Tag.Named<Item> ingotTag = this.getTag("forge", "ingots/" + name);
        this.materialRecipe(wrapped, material, Ingredient.m_43911_(ingotTag), 1, 1, folder + matName + "/ingot");
        wrapped = optional ? this.withCondition(consumer, this.tagCondition("nuggets/" + name)) : consumer;
        this.materialRecipe(wrapped, material, Ingredient.m_43911_(this.getTag("forge", "nuggets/" + name)), 1, 9, folder + matName + "/nugget");
        wrapped = optional ? this.withCondition(consumer, this.tagCondition("storage_blocks/" + name)) : consumer;
        this.materialRecipe(wrapped, material, Ingredient.m_43911_(this.getTag("forge", "storage_blocks/" + name)), 9, 1, ItemOutput.fromTag(ingotTag, (int)1), folder + matName + "/block");
    }

    default public void materialMelting(Consumer<FinishedRecipe> consumer, MaterialVariantId material, Fluid fluid, int fluidAmount, String folder) {
        MaterialMeltingRecipeBuilder.material(material, new FluidStack(fluid, fluidAmount)).save(consumer, this.modResource(folder + "melting/" + material.getLocation('_').m_135815_()));
    }

    default public void materialMeltingCasting(Consumer<FinishedRecipe> consumer, MaterialVariantId material, FluidObject<?> fluid, boolean forgeTag, int fluidAmount, String folder) {
        MaterialFluidRecipeBuilder.material(material).setFluid((Tag<Fluid>)(forgeTag ? fluid.getForgeTag() : fluid.getLocalTag()), fluidAmount).setTemperature(fluid.get().getAttributes().getTemperature() - 300).save(consumer, this.modResource(folder + "casting/" + material.getLocation('_').m_135815_()));
        this.materialMelting(consumer, material, (Fluid)fluid.get(), fluidAmount, folder);
    }

    default public void materialMeltingCasting(Consumer<FinishedRecipe> consumer, MaterialVariantId material, FluidObject<?> fluid, boolean forgeTag, String folder) {
        this.materialMeltingCasting(consumer, material, fluid, forgeTag, 90, folder);
    }

    default public void compatMeltingCasting(Consumer<FinishedRecipe> consumer, MaterialId material, FluidObject<?> fluid, String folder) {
        this.materialMeltingCasting(this.withCondition(consumer, this.tagCondition("ingots/" + material.m_135815_())), (MaterialVariantId)material, fluid, true, folder);
    }

    default public void materialMeltingCasting(Consumer<FinishedRecipe> consumer, MaterialVariantId material, FluidObject<?> fluid, int fluidAmount, String folder) {
        this.materialMeltingCasting(consumer, material, fluid, false, fluidAmount, folder);
    }

    default public void materialMeltingCasting(Consumer<FinishedRecipe> consumer, MaterialVariantId material, FluidObject<?> fluid, String folder) {
        this.materialMeltingCasting(consumer, material, fluid, 90, folder);
    }

    default public void materialMeltingComposite(Consumer<FinishedRecipe> consumer, MaterialVariantId input, MaterialVariantId output, FluidObject<?> fluid, boolean forgeTag, int amount, String folder) {
        this.materialMelting(consumer, output, (Fluid)fluid.get(), amount, folder);
        this.materialComposite(consumer, input, output, fluid, forgeTag, amount, folder);
    }

    default public void materialComposite(Consumer<FinishedRecipe> consumer, MaterialVariantId input, MaterialVariantId output, FluidObject<?> fluid, boolean forgeTag, int amount, String folder, String name) {
        MaterialFluidRecipeBuilder.material(output).setInputId(input).setFluid((Tag<Fluid>)(forgeTag ? fluid.getForgeTag() : fluid.getLocalTag()), amount).setTemperature(fluid.get().getAttributes().getTemperature() - 300).save(consumer, this.modResource(folder + "composite/" + name));
    }

    default public void materialComposite(Consumer<FinishedRecipe> consumer, MaterialVariantId input, MaterialVariantId output, FluidObject<?> fluid, boolean forgeTag, int amount, String folder) {
        this.materialComposite(consumer, input, output, fluid, forgeTag, amount, folder, output.getLocation('_').m_135815_());
    }
}

