/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.json;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;

public abstract class RandomMaterial {
    private static final Map<ResourceLocation, Function<JsonObject, RandomMaterial>> DESERIALIZERS = new HashMap<ResourceLocation, Function<JsonObject, RandomMaterial>>();
    private static boolean initialized = false;

    public static void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        RandomMaterial.registerDeserializer(Fixed.ID, Fixed::fromJson);
        RandomMaterial.registerDeserializer(First.ID, First::fromJson);
        RandomMaterial.registerDeserializer(RandomInTier.ID, RandomInTier::fromJson);
    }

    public static void registerDeserializer(ResourceLocation id, Function<JsonObject, RandomMaterial> deserializer) {
        DESERIALIZERS.putIfAbsent(id, deserializer);
    }

    public static RandomMaterial fixed(MaterialId materialId) {
        return new Fixed(materialId);
    }

    public static RandomMaterial firstWithStat(MaterialStatsId statsId) {
        return new First(statsId);
    }

    public static RandomBuilder random(MaterialStatsId statType) {
        return new RandomBuilder(statType);
    }

    public abstract MaterialVariantId getMaterial(Random var1);

    public abstract JsonObject serialize();

    public static RandomMaterial deserialize(JsonObject json) {
        ResourceLocation type = JsonHelper.getResourceLocation((JsonObject)json, (String)"type");
        Function<JsonObject, RandomMaterial> parser = DESERIALIZERS.get(type);
        if (parser == null) {
            throw new JsonSyntaxException("Unknown random material type " + type);
        }
        return parser.apply(json);
    }

    private static class Fixed
    extends RandomMaterial {
        private static final ResourceLocation ID = TConstruct.getResource("fixed");
        private final MaterialVariantId material;

        public static Fixed fromJson(JsonObject json) {
            MaterialVariantId materialId = MaterialVariantId.fromJson(json, "name");
            return new Fixed(materialId);
        }

        @Override
        public MaterialVariantId getMaterial(Random random) {
            return this.material;
        }

        @Override
        public JsonObject serialize() {
            JsonObject json = new JsonObject();
            json.addProperty("type", ID.toString());
            json.addProperty("name", this.material.toString());
            return json;
        }

        public Fixed(MaterialVariantId material) {
            this.material = material;
        }
    }

    private static class First
    extends RandomMaterial
    implements Predicate<IMaterial> {
        private static final ResourceLocation ID = TConstruct.getResource("first");
        private final MaterialStatsId statType;
        private MaterialId material;

        public static First fromJson(JsonObject json) {
            MaterialStatsId statType = new MaterialStatsId(JsonHelper.getResourceLocation((JsonObject)json, (String)"stat_type"));
            return new First(statType);
        }

        @Override
        public boolean test(IMaterial material) {
            return MaterialRegistry.getInstance().getMaterialStats(material.getIdentifier(), this.statType).isPresent();
        }

        @Override
        public MaterialVariantId getMaterial(Random random) {
            if (this.material == null) {
                this.material = MaterialRegistry.getInstance().getVisibleMaterials().stream().filter(this).findFirst().orElse(IMaterial.UNKNOWN).getIdentifier();
            }
            return this.material;
        }

        @Override
        public JsonObject serialize() {
            JsonObject json = new JsonObject();
            json.addProperty("type", ID.toString());
            json.addProperty("stat_type", this.statType.toString());
            return json;
        }

        private First(MaterialStatsId statType) {
            this.statType = statType;
        }
    }

    private static class RandomInTier
    extends RandomMaterial
    implements Predicate<IMaterial> {
        private static final ResourceLocation ID = TConstruct.getResource("random");
        private final MaterialStatsId statType;
        private final int minTier;
        private final int maxTier;
        private final boolean allowHidden;
        private List<MaterialId> materialChoices;

        public static RandomInTier fromJson(JsonObject json) {
            MaterialStatsId statType = new MaterialStatsId(JsonHelper.getResourceLocation((JsonObject)json, (String)"stat_type"));
            int minTier = GsonHelper.m_13824_((JsonObject)json, (String)"min_tier", (int)0);
            int maxTier = GsonHelper.m_13824_((JsonObject)json, (String)"min_tier", (int)Integer.MAX_VALUE);
            boolean allowHidden = GsonHelper.m_13855_((JsonObject)json, (String)"allow_hidden", (boolean)false);
            return new RandomInTier(statType, minTier, maxTier, allowHidden);
        }

        @Override
        public boolean test(IMaterial material) {
            int tier = material.getTier();
            return tier >= this.minTier && tier <= this.maxTier && (this.allowHidden || !material.isHidden()) && MaterialRegistry.getInstance().getMaterialStats(material.getIdentifier(), this.statType).isPresent();
        }

        @Override
        public MaterialId getMaterial(Random random) {
            if (this.materialChoices == null) {
                this.materialChoices = MaterialRegistry.getInstance().getAllMaterials().stream().filter(this).map(IMaterial::getIdentifier).collect(Collectors.toList());
                if (this.materialChoices.isEmpty()) {
                    TConstruct.LOG.warn("Random material found no options for statType={}, minTier={}, maxTier={}, allowHidden={}", (Object)this.statType, (Object)this.minTier, (Object)this.maxTier, (Object)this.allowHidden);
                }
            }
            if (this.materialChoices.isEmpty()) {
                return IMaterial.UNKNOWN_ID;
            }
            return this.materialChoices.get(random.nextInt(this.materialChoices.size()));
        }

        @Override
        public JsonObject serialize() {
            JsonObject json = new JsonObject();
            json.addProperty("type", ID.toString());
            json.addProperty("stat_type", this.statType.toString());
            if (this.minTier > 0) {
                json.addProperty("min_tier", (Number)this.minTier);
            }
            if (this.maxTier < Integer.MAX_VALUE) {
                json.addProperty("max_tier", (Number)this.maxTier);
            }
            if (this.allowHidden) {
                json.addProperty("allow_hidden", Boolean.valueOf(true));
            }
            return json;
        }

        public RandomInTier(MaterialStatsId statType, int minTier, int maxTier, boolean allowHidden) {
            this.statType = statType;
            this.minTier = minTier;
            this.maxTier = maxTier;
            this.allowHidden = allowHidden;
        }
    }

    public static class RandomBuilder {
        private final MaterialStatsId statType;
        private int minTier = 0;
        private int maxTier = Integer.MAX_VALUE;
        private boolean allowHidden = false;

        public RandomBuilder tier(int tier) {
            this.minTier = tier;
            this.maxTier = tier;
            return this;
        }

        public RandomBuilder tier(int min, int max) {
            if (min > max) {
                throw new IllegalArgumentException("Min must be smaller than or equal to max");
            }
            this.minTier = min;
            this.maxTier = max;
            return this;
        }

        public RandomBuilder allowHidden() {
            this.allowHidden = true;
            return this;
        }

        public RandomMaterial build() {
            return new RandomInTier(this.statType, this.minTier, this.maxTier, this.allowHidden);
        }

        private RandomBuilder(MaterialStatsId statType) {
            this.statType = statType;
        }
    }
}

