/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.SerializationTags;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagCollection;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;

public class TagDifferencePresentCondition
implements ICondition {
    private static final ResourceLocation NAME = TConstruct.getResource("tag_difference_present");
    public static final Serializer SERIALIZER = new Serializer();
    private final ResourceLocation base;
    private final List<ResourceLocation> subtracted;

    public TagDifferencePresentCondition(ResourceLocation base, ResourceLocation ... names) {
        this(base, Arrays.asList(names));
    }

    public ResourceLocation getID() {
        return NAME;
    }

    public boolean test() {
        TagCollection itemTags = SerializationTags.m_13199_().m_144452_(Registry.f_122904_);
        Tag base = itemTags.m_13404_(this.base);
        if (base == null || base.m_6497_().isEmpty()) {
            return false;
        }
        List<Tag> subtracted = this.subtracted.stream().map(arg_0 -> ((TagCollection)itemTags).m_13404_(arg_0)).filter(tag -> tag == null || tag.m_6497_().isEmpty()).toList();
        if (subtracted.isEmpty()) {
            return true;
        }
        int count = subtracted.size();
        block0: for (Item item : base.m_6497_()) {
            for (Tag tag2 : subtracted) {
                if (!tag2.m_8110_((Object)item)) continue;
                continue block0;
            }
            return true;
        }
        return false;
    }

    public TagDifferencePresentCondition(ResourceLocation base, List<ResourceLocation> subtracted) {
        this.base = base;
        this.subtracted = subtracted;
    }

    private static class Serializer
    implements IConditionSerializer<TagDifferencePresentCondition> {
        private Serializer() {
        }

        public void write(JsonObject json, TagDifferencePresentCondition value) {
            json.addProperty("base", value.base.toString());
            JsonArray names = new JsonArray();
            for (ResourceLocation name : value.subtracted) {
                names.add(name.toString());
            }
            json.add("subtracted", (JsonElement)names);
        }

        public TagDifferencePresentCondition read(JsonObject json) {
            return new TagDifferencePresentCondition(JsonHelper.getResourceLocation((JsonObject)json, (String)"base"), JsonHelper.parseList((JsonObject)json, (String)"subtracted", JsonHelper::convertToResourceLocation));
        }

        public ResourceLocation getID() {
            return NAME;
        }
    }
}

