/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.tconstruct.library.TinkerRegistries;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.utils.JsonUtils;

public class ModifierEntry
implements Comparable<ModifierEntry> {
    public static final Serializer SERIALIZER = new Serializer();
    private final Modifier modifier;
    private final int level;

    @Override
    public int compareTo(ModifierEntry other) {
        int priority2;
        Modifier mod1 = this.getModifier();
        Modifier mod2 = other.getModifier();
        int priority1 = mod1.getPriority();
        if (priority1 != (priority2 = mod2.getPriority())) {
            return Integer.compare(priority2, priority1);
        }
        return mod1.getId().m_135815_().compareTo(mod2.getId().m_135815_());
    }

    public static Modifier deserializeModifier(JsonObject parent, String key) {
        return JsonUtils.getAsEntry(TinkerRegistries.MODIFIERS, parent, key);
    }

    public static ModifierEntry fromJson(JsonObject json) {
        return new ModifierEntry(ModifierEntry.deserializeModifier(json, "name"), GsonHelper.m_13824_((JsonObject)json, (String)"level", (int)1));
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("name", this.modifier.getId().toString());
        json.addProperty("level", (Number)this.level);
        return json;
    }

    public static ModifierEntry read(FriendlyByteBuf buffer) {
        return new ModifierEntry((Modifier)buffer.readRegistryIdUnsafe(TinkerRegistries.MODIFIERS), buffer.m_130242_());
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeRegistryIdUnsafe(TinkerRegistries.MODIFIERS, (IForgeRegistryEntry)this.modifier);
        buffer.m_130130_(this.level);
    }

    public ModifierEntry(Modifier modifier, int level) {
        this.modifier = modifier;
        this.level = level;
    }

    public Modifier getModifier() {
        return this.modifier;
    }

    public int getLevel() {
        return this.level;
    }

    public String toString() {
        return "ModifierEntry(modifier=" + this.getModifier() + ", level=" + this.getLevel() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModifierEntry)) {
            return false;
        }
        ModifierEntry other = (ModifierEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLevel() != other.getLevel()) {
            return false;
        }
        Modifier this$modifier = this.getModifier();
        Modifier other$modifier = other.getModifier();
        return !(this$modifier == null ? other$modifier != null : !this$modifier.equals(other$modifier));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ModifierEntry;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLevel();
        Modifier $modifier = this.getModifier();
        result = result * 59 + ($modifier == null ? 43 : $modifier.hashCode());
        return result;
    }

    private static class Serializer
    implements JsonDeserializer<ModifierEntry>,
    JsonSerializer<ModifierEntry> {
        private Serializer() {
        }

        public ModifierEntry deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            return ModifierEntry.fromJson(GsonHelper.m_13918_((JsonElement)json, (String)"modifier"));
        }

        public JsonElement serialize(ModifierEntry entry, Type type, JsonSerializationContext context) {
            return entry.toJson();
        }
    }
}

