/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting.container;

import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;
import slimeknights.mantle.recipe.IMultiRecipe;
import slimeknights.tconstruct.library.recipe.RecipeTypes;
import slimeknights.tconstruct.library.recipe.casting.DisplayCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.ICastingContainer;
import slimeknights.tconstruct.library.recipe.casting.ICastingRecipe;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public abstract class ContainerFillingRecipe
implements ICastingRecipe,
IMultiRecipe<DisplayCastingRecipe> {
    protected final RecipeType<?> type;
    protected final ResourceLocation id;
    protected final String group;
    protected final int fluidAmount;
    protected final Item container;
    private List<DisplayCastingRecipe> displayRecipes = null;

    @Override
    public int getFluidAmount(ICastingContainer inv) {
        Fluid fluid = inv.getFluid();
        return inv.getStack().getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).map(handler -> handler.fill(new FluidStack(fluid, this.fluidAmount), IFluidHandler.FluidAction.SIMULATE)).orElse(0);
    }

    @Override
    public boolean isConsumed() {
        return true;
    }

    @Override
    public boolean switchSlots() {
        return false;
    }

    @Override
    public int getCoolingTime(ICastingContainer inv) {
        return 5;
    }

    public boolean matches(ICastingContainer inv, Level worldIn) {
        ItemStack stack = inv.getStack();
        Fluid fluid = inv.getFluid();
        return stack.m_41720_() == this.container.m_5456_() && stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).filter(handler -> handler.fill(new FluidStack(fluid, this.fluidAmount), IFluidHandler.FluidAction.SIMULATE) > 0).isPresent();
    }

    @Deprecated
    public ItemStack m_8043_() {
        return new ItemStack((ItemLike)this.container);
    }

    public ItemStack assemble(ICastingContainer inv) {
        ItemStack stack = inv.getStack().m_41777_();
        return stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).map(handler -> {
            handler.fill(new FluidStack(inv.getFluid(), this.fluidAmount, inv.getFluidTag()), IFluidHandler.FluidAction.EXECUTE);
            return handler.getContainer();
        }).orElse(stack);
    }

    public List<DisplayCastingRecipe> getRecipes() {
        if (this.displayRecipes == null) {
            List<ItemStack> casts = Collections.singletonList(new ItemStack((ItemLike)this.container));
            this.displayRecipes = ForgeRegistries.FLUIDS.getValues().stream().filter(fluid -> fluid.m_6859_() != Items.f_41852_ && fluid.m_7444_(fluid.m_76145_())).map(fluid -> {
                FluidStack fluidStack = new FluidStack(fluid, this.fluidAmount);
                ItemStack stack = new ItemStack((ItemLike)this.container);
                stack = FluidUtil.getFluidHandler((ItemStack)stack).map(handler -> {
                    handler.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                    return handler.getContainer();
                }).orElse(stack);
                return new DisplayCastingRecipe(this.m_6671_(), casts, Collections.singletonList(fluidStack), stack, 5, true);
            }).toList();
        }
        return this.displayRecipes;
    }

    public ContainerFillingRecipe(RecipeType<?> type, ResourceLocation id, String group, int fluidAmount, Item container) {
        this.type = type;
        this.id = id;
        this.group = group;
        this.fluidAmount = fluidAmount;
        this.container = container;
    }

    public RecipeType<?> m_6671_() {
        return this.type;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public String m_6076_() {
        return this.group;
    }

    public int getFluidAmount() {
        return this.fluidAmount;
    }

    public Item getContainer() {
        return this.container;
    }

    public static class Table
    extends ContainerFillingRecipe {
        public Table(ResourceLocation idIn, String groupIn, int fluidAmount, Item containerIn) {
            super(RecipeTypes.CASTING_TABLE, idIn, groupIn, fluidAmount, containerIn);
        }

        public RecipeSerializer<?> m_7707_() {
            return (RecipeSerializer)TinkerSmeltery.tableFillingRecipeSerializer.get();
        }
    }

    public static class Basin
    extends ContainerFillingRecipe {
        public Basin(ResourceLocation idIn, String groupIn, int fluidAmount, Item containerIn) {
            super(RecipeTypes.CASTING_BASIN, idIn, groupIn, fluidAmount, containerIn);
        }

        public RecipeSerializer<?> m_7707_() {
            return (RecipeSerializer)TinkerSmeltery.basinFillingRecipeSerializer.get();
        }
    }
}

