/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.melting;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.recipe.melting.IMeltingContainer;
import slimeknights.tconstruct.library.recipe.melting.MeltingRecipe;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class OreMeltingRecipe
extends MeltingRecipe {
    private final IMeltingContainer.OreRateType oreType;

    public OreMeltingRecipe(ResourceLocation id, String group, Ingredient input, FluidStack output, int temperature, int time, List<FluidStack> byproducts, IMeltingContainer.OreRateType oreType) {
        super(id, group, input, output, temperature, time, byproducts.stream().map(fluid -> Config.COMMON.foundryByproductRate.applyOreBoost(oreType, (FluidStack)fluid)).toList());
        this.oreType = oreType;
    }

    @Override
    public FluidStack getOutput(IMeltingContainer inv) {
        FluidStack output = this.getOutput();
        return inv.getOreRate().applyOreBoost(this.oreType, output);
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerSmeltery.oreMeltingSerializer.get();
    }

    @Override
    public IMeltingContainer.OreRateType getOreType() {
        return this.oreType;
    }

    public static class Serializer
    extends MeltingRecipe.AbstractSerializer<OreMeltingRecipe> {
        @Override
        protected OreMeltingRecipe createFromJson(ResourceLocation id, String group, Ingredient input, FluidStack output, int temperature, int time, List<FluidStack> byproducts, JsonObject json) {
            IMeltingContainer.OreRateType rate = IMeltingContainer.OreRateType.parse(json, "rate");
            return new OreMeltingRecipe(id, group, input, output, temperature, time, byproducts, rate);
        }

        @Override
        protected OreMeltingRecipe createFromNetwork(ResourceLocation id, String group, Ingredient input, FluidStack output, int temperature, int time, List<FluidStack> byproducts, FriendlyByteBuf buffer) {
            IMeltingContainer.OreRateType rate = (IMeltingContainer.OreRateType)buffer.m_130066_(IMeltingContainer.OreRateType.class);
            return new OreMeltingRecipe(id, group, input, output, temperature, time, byproducts, rate);
        }

        @Override
        protected void toNetworkSafe(FriendlyByteBuf buffer, OreMeltingRecipe recipe) {
            super.toNetworkSafe(buffer, recipe);
            buffer.m_130068_((Enum)recipe.oreType);
        }
    }
}

