/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.adding;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;
import slimeknights.mantle.recipe.helper.LoggingRecipeSerializer;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IDisplayModifierRecipe;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IncrementalModifierRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.IMutableTinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.modifiers.slotless.OverslimeModifier;

public class OverslimeModifierRecipe
implements ITinkerStationRecipe,
IDisplayModifierRecipe {
    private static final ValidatedResult AT_CAPACITY = ValidatedResult.failure(TConstruct.makeTranslationKey("recipe", "overslime.at_capacity"), new Object[0]);
    private final ResourceLocation id;
    private final Ingredient ingredient;
    private final int restoreAmount;
    private static final Lazy<ModifierEntry> RESULT = Lazy.of(() -> new ModifierEntry((Modifier)TinkerModifiers.overslime.get(), 1));
    private static final Lazy<List<ItemStack>> DISPLAY_TOOLS = Lazy.of(() -> TinkerTags.Items.DURABILITY.m_6497_().stream().map(MAP_TOOL_FOR_RENDERING).collect(Collectors.toList()));
    private List<ItemStack> toolWithModifier = null;
    private List<List<ItemStack>> displayItems = null;

    public OverslimeModifierRecipe(ResourceLocation id, Ingredient ingredient, int restoreAmount) {
        this.id = id;
        this.ingredient = ingredient;
        this.restoreAmount = restoreAmount;
    }

    @Override
    public boolean matches(ITinkerStationContainer inv, Level world) {
        if (!TinkerTags.Items.DURABILITY.m_8110_((Object)inv.getTinkerableStack().m_41720_())) {
            return false;
        }
        return IncrementalModifierRecipe.containsOnlyIngredient(inv, this.ingredient);
    }

    @Override
    public ValidatedResult getValidatedResult(ITinkerStationContainer inv) {
        ItemStack tinkerable = inv.getTinkerableStack();
        ToolStack tool = ToolStack.from(tinkerable);
        OverslimeModifier overslime = (OverslimeModifier)TinkerModifiers.overslime.get();
        if (tool.getUpgrades().getLevel((Modifier)TinkerModifiers.overslime.get()) == 0) {
            if (tool.getModifierLevel((Modifier)TinkerModifiers.overslime.get()) > 0 && overslime.getOverslime(tool) >= overslime.getCapacity(tool)) {
                return AT_CAPACITY;
            }
            tool = tool.copy();
            tool.addModifier((Modifier)TinkerModifiers.overslime.get(), 1);
        } else {
            if (overslime.getOverslime(tool) >= overslime.getCapacity(tool)) {
                return AT_CAPACITY;
            }
            tool = tool.copy();
        }
        int available = IncrementalModifierRecipe.getAvailableAmount(inv, this.ingredient, this.restoreAmount);
        overslime.addOverslime(tool, available);
        return ValidatedResult.success(tool.createStack(Math.min(tinkerable.m_41613_(), this.shrinkToolSlotBy())));
    }

    @Override
    public void updateInputs(ItemStack result, IMutableTinkerStationContainer inv, boolean isServer) {
        ToolStack tool = ToolStack.from(inv.getTinkerableStack());
        int current = 0;
        OverslimeModifier overslime = (OverslimeModifier)TinkerModifiers.overslime.get();
        if (tool.getModifierLevel((Modifier)TinkerModifiers.overslime.get()) != 0) {
            current = overslime.getOverslime(tool);
        }
        int maxNeeded = overslime.getOverslime(ToolStack.from(result)) - current;
        IncrementalModifierRecipe.updateInputs(inv, this.ingredient, maxNeeded, this.restoreAmount, ItemStack.f_41583_);
    }

    @Deprecated
    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerModifiers.overslimeSerializer.get();
    }

    @Override
    public List<List<ItemStack>> getDisplayItems() {
        if (this.displayItems == null) {
            this.displayItems = Arrays.asList((List)DISPLAY_TOOLS.get(), Arrays.asList(this.ingredient.m_43908_()));
        }
        return this.displayItems;
    }

    @Override
    public List<ItemStack> getToolWithModifier() {
        if (this.toolWithModifier == null) {
            OverslimeModifier overslime = (OverslimeModifier)TinkerModifiers.overslime.get();
            this.toolWithModifier = TinkerTags.Items.DURABILITY.m_6497_().stream().map(MAP_TOOL_FOR_RENDERING).map(stack -> IDisplayModifierRecipe.withModifiers(stack, null, (ModifierEntry)RESULT.get(), data -> overslime.setShield((ModDataNBT)data, this.restoreAmount))).toList();
        }
        return this.toolWithModifier;
    }

    @Override
    public ModifierEntry getDisplayResult() {
        return (ModifierEntry)RESULT.get();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public static class Serializer
    extends LoggingRecipeSerializer<OverslimeModifierRecipe> {
        public OverslimeModifierRecipe fromJson(ResourceLocation id, JsonObject json) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)JsonHelper.getElement((JsonObject)json, (String)"ingredient"));
            int restoreAmount = GsonHelper.m_13927_((JsonObject)json, (String)"restore_amount");
            return new OverslimeModifierRecipe(id, ingredient, restoreAmount);
        }

        @Nullable
        protected OverslimeModifierRecipe fromNetworkSafe(ResourceLocation id, FriendlyByteBuf buffer) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int restoreAmount = buffer.m_130242_();
            return new OverslimeModifierRecipe(id, ingredient, restoreAmount);
        }

        protected void toNetworkSafe(FriendlyByteBuf buffer, OverslimeModifierRecipe recipe) {
            recipe.ingredient.m_43923_(buffer);
            buffer.m_130130_(recipe.restoreAmount);
        }
    }
}

