/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.adding;

import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierMatch;
import slimeknights.tconstruct.library.recipe.modifiers.adding.ModifierRecipeBuilder;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class SwappableModifierRecipeBuilder
extends ModifierRecipeBuilder {
    private final String value;

    protected SwappableModifierRecipeBuilder(Modifier modifier, String value) {
        super(new ModifierEntry(modifier, 1));
        this.value = value;
    }

    public static SwappableModifierRecipeBuilder modifier(Modifier modifier, String value) {
        return new SwappableModifierRecipeBuilder(modifier, value);
    }

    @Override
    public ModifierRecipeBuilder setMaxLevel(int level) {
        throw new UnsupportedOperationException("Max level is always 1 for a swappable modifier recipe");
    }

    @Override
    public void save(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        if (this.inputs.isEmpty()) {
            throw new IllegalStateException("Must have at least 1 input");
        }
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "modifiers");
        consumer.accept((FinishedRecipe)new Finished(id, advancementId, false));
        if (this.includeUnarmed) {
            if (this.requirements != ModifierMatch.ALWAYS) {
                throw new IllegalStateException("Cannot use includeUnarmed with requirements");
            }
            consumer.accept((FinishedRecipe)new Finished(new ResourceLocation(id.m_135827_(), id.m_135815_() + "_unarmed"), null, true));
        }
    }

    private class Finished
    extends ModifierRecipeBuilder.FinishedAdding {
        public Finished(@Nullable ResourceLocation ID, ResourceLocation advancementID, boolean withUnarmed) {
            super(SwappableModifierRecipeBuilder.this, ID, advancementID, withUnarmed);
        }

        @Override
        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)TinkerModifiers.swappableModifierSerializer.get();
        }

        @Override
        public void m_7917_(JsonObject json) {
            super.m_7917_(json);
            JsonObject result = json.getAsJsonObject("result");
            result.remove("level");
            result.addProperty("value", SwappableModifierRecipeBuilder.this.value);
        }
    }
}

