/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.salvage;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierRecipeLookup;
import slimeknights.tconstruct.library.recipe.modifiers.salvage.AbstractModifierSalvage;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class IncrementalModifierSalvage
extends AbstractModifierSalvage {
    private final ItemOutput result;
    private final boolean fullSalvage;

    public IncrementalModifierSalvage(ResourceLocation id, Ingredient toolIngredient, int maxToolSize, Modifier modifier, int minLevel, int maxLevel, ItemOutput result, boolean fullSalvage, @Nullable SlotType.SlotCount slots) {
        super(id, toolIngredient, maxToolSize, modifier, minLevel, maxLevel, slots);
        this.result = result;
        this.fullSalvage = fullSalvage;
        ModifierRecipeLookup.addSalvage(this);
    }

    @Override
    public void updateTool(IToolStackView tool) {
        super.updateTool(tool);
        tool.getPersistentData().remove(this.getModifier().getId());
    }

    @Override
    public void acceptItems(IToolStackView tool, Consumer<ItemStack> stackConsumer, Random random) {
        ModifierId key = this.getModifier().getId();
        int maxValue = tool.getPersistentData().contains(key, 99) ? tool.getPersistentData().getInt(this.getModifier().getId()) : ModifierRecipeLookup.getNeededPerLevel(this.getModifier());
        if (maxValue > 0) {
            int amount;
            int n = amount = this.fullSalvage ? maxValue : random.nextInt(maxValue);
            if (amount > 0) {
                ItemStack result = this.result.get();
                stackConsumer.accept(ItemHandlerHelper.copyStackWithSize((ItemStack)result, (int)(amount * result.m_41613_())));
            }
        }
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerModifiers.incrementalModifierSalvageSerializer.get();
    }

    public static class Serializer
    extends AbstractModifierSalvage.AbstractSerializer<IncrementalModifierSalvage> {
        @Override
        protected IncrementalModifierSalvage fromJson(ResourceLocation id, JsonObject json, Ingredient toolIngredient, int maxToolSize, Modifier modifier, int minLevel, int maxLevel, @Nullable SlotType.SlotCount slots) {
            JsonElement salvageElement = JsonHelper.getElement((JsonObject)json, (String)"salvage");
            ItemOutput result = ItemOutput.fromJson((JsonElement)salvageElement);
            boolean fullSalvage = false;
            if (salvageElement.isJsonObject()) {
                fullSalvage = GsonHelper.m_13855_((JsonObject)salvageElement.getAsJsonObject(), (String)"full", (boolean)false);
            }
            return new IncrementalModifierSalvage(id, toolIngredient, maxToolSize, modifier, minLevel, maxLevel, result, fullSalvage, slots);
        }

        @Override
        protected IncrementalModifierSalvage fromNetwork(ResourceLocation id, FriendlyByteBuf buffer, Ingredient toolIngredient, int maxToolSize, Modifier modifier, int minLevel, int maxLevel, @Nullable SlotType.SlotCount slots) {
            ItemOutput result = ItemOutput.read((FriendlyByteBuf)buffer);
            boolean fullSalvage = buffer.readBoolean();
            return new IncrementalModifierSalvage(id, toolIngredient, maxToolSize, modifier, minLevel, maxLevel, result, fullSalvage, slots);
        }

        @Override
        protected void toNetworkSafe(FriendlyByteBuf buffer, IncrementalModifierSalvage recipe) {
            super.toNetworkSafe(buffer, recipe);
            recipe.result.write(buffer);
            buffer.writeBoolean(recipe.fullSalvage);
        }
    }
}

