/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.severing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.crafting.RecipeManager;
import slimeknights.mantle.recipe.helper.RecipeHelper;
import slimeknights.tconstruct.common.recipe.RecipeCacheInvalidator;
import slimeknights.tconstruct.library.recipe.RecipeTypes;
import slimeknights.tconstruct.library.recipe.modifiers.severing.SeveringRecipe;

public class SeveringRecipeCache {
    private static final Map<EntityType<?>, List<SeveringRecipe>> CACHE = new HashMap();

    public static List<SeveringRecipe> findRecipe(RecipeManager manager, EntityType<?> type) {
        if (CACHE.containsKey(type)) {
            return CACHE.get(type);
        }
        ArrayList<SeveringRecipe> list = new ArrayList();
        for (SeveringRecipe recipe : RecipeHelper.getRecipes((RecipeManager)manager, RecipeTypes.SEVERING, SeveringRecipe.class)) {
            if (!recipe.matches(type)) continue;
            list.add(recipe);
        }
        if (list.isEmpty()) {
            list = Collections.emptyList();
        }
        CACHE.put(type, list);
        return list;
    }

    private SeveringRecipeCache() {
    }

    static {
        RecipeCacheInvalidator.addReloadListener(client -> CACHE.clear());
    }
}

