/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.spilling;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.material.Fluid;
import slimeknights.mantle.recipe.helper.RecipeHelper;
import slimeknights.tconstruct.common.recipe.RecipeCacheInvalidator;
import slimeknights.tconstruct.library.recipe.RecipeTypes;
import slimeknights.tconstruct.library.recipe.modifiers.spilling.SpillingRecipe;

public class SpillingRecipeLookup {
    private static final Map<Fluid, SpillingRecipe> CACHE = new HashMap<Fluid, SpillingRecipe>();

    @Nullable
    public static SpillingRecipe findRecipe(RecipeManager manager, Fluid fluid) {
        if (CACHE.containsKey(fluid)) {
            return CACHE.get(fluid);
        }
        for (SpillingRecipe recipe : RecipeHelper.getRecipes((RecipeManager)manager, RecipeTypes.SPILLING, SpillingRecipe.class)) {
            if (!recipe.matches(fluid)) continue;
            CACHE.put(fluid, recipe);
            return recipe;
        }
        CACHE.put(fluid, null);
        return null;
    }

    private SpillingRecipeLookup() {
    }

    static {
        RecipeCacheInvalidator.addReloadListener(client -> CACHE.clear());
    }
}

