/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.spilling.effects;

import com.google.gson.JsonObject;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.tconstruct.library.recipe.modifiers.spilling.effects.ISpillingEffect;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;

public class CureEffectsSpillingEffect
implements ISpillingEffect {
    public static final Loader LOADER = new Loader();
    private final ItemStack stack;

    @Override
    public void applyEffects(FluidStack fluid, float scale, ToolAttackContext context) {
        LivingEntity target = context.getLivingTarget();
        if (target != null) {
            target.curePotionEffects(this.stack);
        }
    }

    @Override
    public GenericLoaderRegistry.IGenericLoader<?> getLoader() {
        return LOADER;
    }

    public CureEffectsSpillingEffect(ItemStack stack) {
        this.stack = stack;
    }

    private static class Loader
    implements GenericLoaderRegistry.IGenericLoader<CureEffectsSpillingEffect> {
        private Loader() {
        }

        public CureEffectsSpillingEffect deserialize(JsonObject json) {
            ItemStack curativeItem = CraftingHelper.getItemStack((JsonObject)json, (boolean)true);
            return new CureEffectsSpillingEffect(curativeItem);
        }

        public CureEffectsSpillingEffect fromNetwork(FriendlyByteBuf buffer) {
            ItemStack curativeItem = buffer.m_130267_();
            return new CureEffectsSpillingEffect(curativeItem);
        }

        public void serialize(CureEffectsSpillingEffect effect, JsonObject json) {
            json.addProperty("item", Objects.requireNonNull(effect.stack.m_41720_().getRegistryName()).toString());
            CompoundTag nbt = effect.stack.m_41783_();
            if (nbt != null) {
                json.addProperty("nbt", nbt.toString());
            }
        }

        public void toNetwork(CureEffectsSpillingEffect effect, FriendlyByteBuf buffer) {
            buffer.m_130055_(effect.stack);
        }
    }
}

