/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.spilling.effects;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.recipe.ingredient.EntityIngredient;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.recipe.modifiers.spilling.effects.ISpillingEffect;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.helper.ToolAttackUtil;

public class DamageSpillingEffect
implements ISpillingEffect {
    public static final Loader LOADER = new Loader();
    @Nullable
    private final EntityIngredient entity;
    private final LivingEntityPredicate predicate;
    private final DamageType type;
    private final float damage;

    public DamageSpillingEffect(EntityIngredient entity, DamageType type, float damage) {
        this(entity, LivingEntityPredicate.ANY, type, damage);
    }

    public DamageSpillingEffect(LivingEntityPredicate entity, DamageType type, float damage) {
        this(null, entity, type, damage);
    }

    public DamageSpillingEffect(DamageType type, float damage) {
        this(LivingEntityPredicate.ANY, type, damage);
    }

    @Override
    public void applyEffects(FluidStack fluid, float scale, ToolAttackContext context) {
        Entity target = context.getTarget();
        LivingEntity livingTarget = context.getLivingTarget();
        if ((this.entity == null || this.entity.test((Object)target.m_6095_())) && (livingTarget == null ? this.predicate == LivingEntityPredicate.ANY : this.predicate.test(livingTarget))) {
            Player player = context.getPlayerAttacker();
            DamageSource source = player != null ? DamageSource.m_19344_((Player)player) : DamageSource.m_19370_((LivingEntity)context.getAttacker());
            this.type.apply(source);
            ToolAttackUtil.attackEntitySecondary(source, this.damage * scale, context.getTarget(), livingTarget, true);
        }
    }

    @Override
    public GenericLoaderRegistry.IGenericLoader<?> getLoader() {
        return LOADER;
    }

    protected DamageSpillingEffect(@Nullable EntityIngredient entity, LivingEntityPredicate predicate, DamageType type, float damage) {
        this.entity = entity;
        this.predicate = predicate;
        this.type = type;
        this.damage = damage;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum LivingEntityPredicate {
        ANY{

            @Override
            public boolean test(LivingEntity living) {
                return true;
            }
        }
        ,
        WATER_SENSITIVE{

            @Override
            public boolean test(LivingEntity living) {
                return living.m_6126_();
            }
        }
        ,
        UNDEAD{

            @Override
            public boolean test(LivingEntity living) {
                return living.m_6336_() == MobType.f_21641_;
            }
        }
        ,
        ARTHROPOD{

            @Override
            public boolean test(LivingEntity living) {
                return living.m_6336_() == MobType.f_21642_;
            }
        }
        ,
        NOT_FIRE_IMMUNE{

            @Override
            public boolean test(LivingEntity living) {
                return !living.m_5825_();
            }
        };

        private final String name = this.name().toLowerCase(Locale.US);

        public abstract boolean test(LivingEntity var1);

        @Nullable
        public static LivingEntityPredicate byName(String name) {
            for (LivingEntityPredicate type : LivingEntityPredicate.values()) {
                if (!type.getName().equals(name)) continue;
                return type;
            }
            return null;
        }

        public String getName() {
            return this.name;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum DamageType {
        NORMAL{

            @Override
            public void apply(DamageSource source) {
            }
        }
        ,
        FIRE{

            @Override
            public void apply(DamageSource source) {
                source.m_19383_();
            }
        }
        ,
        MAGIC{

            @Override
            public void apply(DamageSource source) {
                source.m_19389_();
            }
        }
        ,
        EXPLOSION{

            @Override
            public void apply(DamageSource source) {
                source.m_19375_();
            }
        }
        ,
        PIERCING{

            @Override
            public void apply(DamageSource source) {
                source.m_19380_();
            }
        };

        private final String name = this.name().toLowerCase(Locale.US);

        public abstract void apply(DamageSource var1);

        @Nullable
        public static DamageType byName(String name) {
            for (DamageType type : DamageType.values()) {
                if (!type.getName().equals(name)) continue;
                return type;
            }
            return null;
        }

        public String getName() {
            return this.name;
        }
    }

    private static class Loader
    implements GenericLoaderRegistry.IGenericLoader<DamageSpillingEffect> {
        private Loader() {
        }

        public DamageSpillingEffect deserialize(JsonObject json) {
            String typeName;
            DamageType type;
            EntityIngredient entity = null;
            LivingEntityPredicate predicate = LivingEntityPredicate.ANY;
            if (json.has("entity")) {
                JsonElement element = JsonHelper.getElement((JsonObject)json, (String)"entity");
                if (element.isJsonPrimitive()) {
                    predicate = LivingEntityPredicate.byName(element.getAsString());
                    if (predicate == null) {
                        throw new JsonSyntaxException("Invalid entity predicate " + element.getAsString());
                    }
                } else {
                    entity = EntityIngredient.deserialize((JsonElement)element);
                }
            }
            if ((type = DamageType.byName(typeName = GsonHelper.m_13906_((JsonObject)json, (String)"damage_type"))) == null) {
                throw new JsonSyntaxException("Unknown damage type '" + typeName + "'");
            }
            float damage = GsonHelper.m_13915_((JsonObject)json, (String)"damage_amount");
            return new DamageSpillingEffect(entity, predicate, type, damage);
        }

        public DamageSpillingEffect fromNetwork(FriendlyByteBuf buffer) {
            EntityIngredient entity = null;
            if (buffer.readBoolean()) {
                entity = EntityIngredient.read((FriendlyByteBuf)buffer);
            }
            LivingEntityPredicate predicate = (LivingEntityPredicate)buffer.m_130066_(LivingEntityPredicate.class);
            DamageType type = (DamageType)buffer.m_130066_(DamageType.class);
            float damage = buffer.readFloat();
            return new DamageSpillingEffect(entity, predicate, type, damage);
        }

        public void serialize(DamageSpillingEffect effect, JsonObject json) {
            if (effect.entity != null) {
                json.add("entity", effect.entity.serialize());
            } else if (effect.predicate != LivingEntityPredicate.ANY) {
                json.addProperty("entity", effect.predicate.getName());
            }
            json.addProperty("damage_type", effect.type.getName());
            json.addProperty("damage_amount", (Number)Float.valueOf(effect.damage));
        }

        public void toNetwork(DamageSpillingEffect effect, FriendlyByteBuf buffer) {
            if (effect.entity != null) {
                buffer.writeBoolean(true);
                effect.entity.write(buffer);
            } else {
                buffer.writeBoolean(false);
            }
            buffer.m_130068_((Enum)effect.predicate);
            buffer.m_130068_((Enum)effect.type);
            buffer.writeFloat(effect.damage);
        }
    }
}

