/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.spilling.effects;

import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.tconstruct.library.recipe.modifiers.spilling.effects.ISpillingEffect;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;

public class RestoreHungerSpillingEffect
implements ISpillingEffect {
    public static final Loader LOADER = new Loader();
    private final int hunger;
    private final float saturation;

    @Override
    public void applyEffects(FluidStack fluid, float scale, ToolAttackContext context) {
        Player player;
        LivingEntity target = context.getLivingTarget();
        if (target instanceof Player && (player = (Player)target).m_36391_(false)) {
            player.m_36324_().m_38707_((int)((float)this.hunger * scale), this.saturation * scale);
        }
    }

    @Override
    public GenericLoaderRegistry.IGenericLoader<?> getLoader() {
        return LOADER;
    }

    public RestoreHungerSpillingEffect(int hunger, float saturation) {
        this.hunger = hunger;
        this.saturation = saturation;
    }

    private static class Loader
    implements GenericLoaderRegistry.IGenericLoader<RestoreHungerSpillingEffect> {
        private Loader() {
        }

        public RestoreHungerSpillingEffect deserialize(JsonObject json) {
            int hunger = GsonHelper.m_13927_((JsonObject)json, (String)"hunger");
            float saturation = GsonHelper.m_13915_((JsonObject)json, (String)"saturation");
            return new RestoreHungerSpillingEffect(hunger, saturation);
        }

        public void serialize(RestoreHungerSpillingEffect effect, JsonObject json) {
            json.addProperty("hunger", (Number)effect.hunger);
            json.addProperty("saturation", (Number)Float.valueOf(effect.saturation));
        }

        public RestoreHungerSpillingEffect fromNetwork(FriendlyByteBuf buffer) {
            int hunger = buffer.m_130242_();
            float saturation = buffer.readFloat();
            return new RestoreHungerSpillingEffect(hunger, saturation);
        }

        public void toNetwork(RestoreHungerSpillingEffect effect, FriendlyByteBuf buffer) {
            buffer.m_130130_(effect.hunger);
            buffer.writeFloat(effect.saturation);
        }
    }
}

