/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.spilling.effects;

import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.tconstruct.library.events.teleport.SpillingTeleportEvent;
import slimeknights.tconstruct.library.recipe.modifiers.spilling.effects.ISpillingEffect;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.utils.TeleportHelper;

public class TeleportSpillingEffect
implements ISpillingEffect {
    public static final TeleportSpillingEffect INSTANCE = new TeleportSpillingEffect();
    public static final GenericLoaderRegistry.IGenericLoader<TeleportSpillingEffect> LOADER = new GenericLoaderRegistry.SingletonLoader((GenericLoaderRegistry.IHaveLoader)INSTANCE);
    private static final TeleportHelper.ITeleportEventFactory TELEPORT_PREDICATE = SpillingTeleportEvent::new;

    private TeleportSpillingEffect() {
    }

    @Override
    public void applyEffects(FluidStack fluid, float scale, ToolAttackContext context) {
        LivingEntity target = context.getLivingTarget();
        if (target != null) {
            TeleportHelper.randomNearbyTeleport(target, TELEPORT_PREDICATE);
        }
    }

    @Override
    public GenericLoaderRegistry.IGenericLoader<?> getLoader() {
        return LOADER;
    }
}

