/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.tinkerstation.repairing;

import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ModifierRepairRecipeBuilder
extends AbstractRecipeBuilder<ModifierRepairRecipeBuilder> {
    private final Modifier modifier;
    private final Ingredient ingredient;
    private final int repairAmount;

    public void save(Consumer<FinishedRecipe> consumer) {
        this.save(consumer, this.modifier.getId());
    }

    public ModifierRepairRecipeBuilder buildCraftingTable(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "tinker_station");
        consumer.accept((FinishedRecipe)new Finished(id, advancementId, (RecipeSerializer)TinkerModifiers.craftingModifierRepair.get()));
        return this;
    }

    public void save(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "tinker_station");
        consumer.accept((FinishedRecipe)new Finished(id, advancementId, (RecipeSerializer)TinkerModifiers.modifierRepair.get()));
    }

    private ModifierRepairRecipeBuilder(Modifier modifier, Ingredient ingredient, int repairAmount) {
        this.modifier = modifier;
        this.ingredient = ingredient;
        this.repairAmount = repairAmount;
    }

    public static ModifierRepairRecipeBuilder repair(Modifier modifier, Ingredient ingredient, int repairAmount) {
        return new ModifierRepairRecipeBuilder(modifier, ingredient, repairAmount);
    }

    private class Finished
    extends AbstractRecipeBuilder.AbstractFinishedRecipe {
        private final RecipeSerializer<?> type;

        public Finished(@Nullable ResourceLocation ID, ResourceLocation advancementID, RecipeSerializer<?> type) {
            super((AbstractRecipeBuilder)ModifierRepairRecipeBuilder.this, ID, advancementID);
            this.type = type;
        }

        public void m_7917_(JsonObject json) {
            json.addProperty("modifier", ModifierRepairRecipeBuilder.this.modifier.getId().toString());
            json.add("ingredient", ModifierRepairRecipeBuilder.this.ingredient.m_43942_());
            json.addProperty("repair_amount", (Number)ModifierRepairRecipeBuilder.this.repairAmount);
        }

        public RecipeSerializer<?> m_6637_() {
            return this.type;
        }
    }
}

