/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.capability;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import slimeknights.tconstruct.TConstruct;

public class TinkerDataCapability {
    private static final ResourceLocation ID = TConstruct.getResource("modifier_data");
    public static final Capability<Holder> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<Holder>(){});

    private TinkerDataCapability() {
    }

    public static void register() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(EventPriority.NORMAL, false, RegisterCapabilitiesEvent.class, TinkerDataCapability::register);
        MinecraftForge.EVENT_BUS.addGenericListener(Entity.class, TinkerDataCapability::attachCapability);
    }

    private static void register(RegisterCapabilitiesEvent event) {
        event.register(Holder.class);
    }

    private static void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof LivingEntity) {
            Provider provider = new Provider();
            event.addCapability(ID, (ICapabilityProvider)provider);
            event.addListener((Runnable)provider);
        }
    }

    public static class Holder {
        private final Map<TinkerDataKey<?>, Object> data = new IdentityHashMap();

        public <T> void put(TinkerDataKey<T> key, T value) {
            this.data.put(key, value);
        }

        public void remove(TinkerDataKey<?> key) {
            this.data.remove(key);
        }

        public <S, T extends S> S get(TinkerDataKey<T> key, S defaultValue) {
            return (S)this.data.getOrDefault(key, defaultValue);
        }

        @Nullable
        public <T> T get(TinkerDataKey<T> key) {
            return (T)this.data.get(key);
        }

        public <T, U extends TinkerDataKey<T>> T computeIfAbsent(U key) {
            return (T)this.data.computeIfAbsent(key, (Function)((Object)key));
        }

        public boolean contains(TinkerDataKey<?> key) {
            return this.data.containsKey(key);
        }
    }

    private static class Provider
    implements ICapabilityProvider,
    Runnable {
        private LazyOptional<Holder> data = LazyOptional.of(Holder::new);

        private Provider() {
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
            return CAPABILITY.orEmpty(cap, this.data);
        }

        @Override
        public void run() {
            this.data.invalidate();
            this.data = LazyOptional.of(Holder::new);
        }
    }

    public static class ComputableDataKey<T>
    extends TinkerDataKey<T>
    implements Function<TinkerDataKey<?>, T> {
        private final Supplier<T> constructor;

        private ComputableDataKey(ResourceLocation name, Supplier<T> constructor) {
            super(name);
            this.constructor = constructor;
        }

        public static <T> ComputableDataKey<T> of(ResourceLocation name, Supplier<T> constructor) {
            return new ComputableDataKey<T>(name, constructor);
        }

        @Override
        public T apply(TinkerDataKey<?> tinkerDataKey) {
            return this.constructor.get();
        }
    }

    public static class TinkerDataKey<T> {
        private final ResourceLocation name;

        public String toString() {
            return "TinkerDataKey{" + this.name + "}";
        }

        private TinkerDataKey(ResourceLocation name) {
            this.name = name;
        }

        public static <T> TinkerDataKey<T> of(ResourceLocation name) {
            return new TinkerDataKey<T>(name);
        }
    }
}

