/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.capability;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.NetworkHooks;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.partbuilder.Pattern;
import slimeknights.tconstruct.library.tools.capability.ToolCapabilityProvider;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.helper.TooltipUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.tools.menu.ToolContainerMenu;

public class ToolInventoryCapability
implements IItemHandlerModifiable {
    public static final ResourceLocation TOTAL_SLOTS = TConstruct.getResource("total_item_slots");
    public static final ResourceLocation INCLUDE_OFFHAND = TConstruct.getResource("inventory_show_offhand");
    private final Supplier<? extends IToolStackView> tool;
    private ItemStack[] cachedStacks;
    private int slots = -1;
    private int startForSlot = 0;
    private int modifierLevel = 0;

    public int getSlots() {
        if (this.slots == -1) {
            this.slots = this.tool.get().getVolatileData().getInt(TOTAL_SLOTS);
        }
        return this.slots;
    }

    @Nullable
    private IInventoryModifier getInventory(int slot) {
        IToolStackView tool = this.tool.get();
        if (slot < this.getSlots()) {
            int start = 0;
            for (ModifierEntry entry : tool.getModifierList()) {
                IInventoryModifier inventory = entry.getModifier().getModule(IInventoryModifier.class);
                if (inventory == null) continue;
                int slots = inventory.getSlots(tool, entry.getLevel());
                if (slot < slots + start) {
                    this.startForSlot = start;
                    this.modifierLevel = entry.getLevel();
                    return inventory;
                }
                start += slots;
            }
        }
        return null;
    }

    public static boolean isBlacklisted(ItemStack stack) {
        return TinkerTags.Items.TOOL_INVENTORY_BLACKLIST.m_8110_((Object)stack.m_41720_()) || stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent();
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        if (!stack.m_41619_() && ToolInventoryCapability.isBlacklisted(stack)) {
            return false;
        }
        IInventoryModifier inventory = this.getInventory(slot);
        if (inventory != null) {
            return inventory.isItemValid(this.tool.get(), slot - this.startForSlot, stack);
        }
        return false;
    }

    public int getSlotLimit(int slot) {
        IInventoryModifier inventory = this.getInventory(slot);
        if (inventory != null) {
            return inventory.getSlotLimit(this.tool.get(), slot - this.startForSlot);
        }
        return 0;
    }

    private void clearCache() {
        this.slots = -1;
        this.cachedStacks = null;
    }

    private void cacheStack(int slot, ItemStack stack) {
        int slots;
        if (slot >= 0 && slot < (slots = this.getSlots())) {
            if (this.cachedStacks == null) {
                this.cachedStacks = new ItemStack[this.getSlots()];
            }
            this.cachedStacks[slot] = stack;
        }
    }

    @Nullable
    private ItemStack getCachedStack(int slot) {
        if (this.cachedStacks != null && slot >= 0 && slot < this.getSlots()) {
            return this.cachedStacks[slot];
        }
        return null;
    }

    private void setAndCache(IInventoryModifier inventory, int localSlot, int globalSlot, ItemStack stack) {
        inventory.setStack(this.tool.get(), this.modifierLevel, localSlot, stack);
        this.cacheStack(globalSlot, stack);
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        IInventoryModifier inventory = this.getInventory(slot);
        if (inventory != null) {
            this.setAndCache(inventory, slot - this.startForSlot, slot, stack);
        }
    }

    private ItemStack getAndCache(IInventoryModifier inventory, int localSlot, int globalSlot) {
        ItemStack stack = inventory.getStack(this.tool.get(), this.modifierLevel, localSlot);
        this.cacheStack(globalSlot, stack);
        return stack;
    }

    private ItemStack getCached(IInventoryModifier inventory, int localSlot, int globalSlot) {
        ItemStack stack = this.getCachedStack(globalSlot);
        if (stack == null) {
            stack = this.getAndCache(inventory, localSlot, globalSlot);
        }
        return stack;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        ItemStack cached = this.getCachedStack(slot);
        if (cached != null) {
            return cached;
        }
        IInventoryModifier inventory = this.getInventory(slot);
        if (inventory != null) {
            return this.getAndCache(inventory, slot - this.startForSlot, slot);
        }
        return ItemStack.f_41583_;
    }

    @Nonnull
    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        int leftover;
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (ToolInventoryCapability.isBlacklisted(stack)) {
            return stack;
        }
        IInventoryModifier inventory = this.getInventory(slot);
        if (inventory == null) {
            return stack;
        }
        int localSlot = slot - this.startForSlot;
        IToolStackView tool = this.tool.get();
        if (!inventory.isItemValid(tool, localSlot, stack)) {
            return stack;
        }
        ItemStack current = this.getCached(inventory, localSlot, slot);
        int slotLimit = inventory.getSlotLimit(tool, localSlot);
        if (current.m_41619_()) {
            int canInsert = Math.min(stack.m_41613_(), Math.min(stack.m_41741_(), slotLimit));
            leftover = stack.m_41613_() - canInsert;
            if (!simulate) {
                this.setAndCache(inventory, localSlot, slot, ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)canInsert));
            }
        } else {
            int limit = Math.min(current.m_41741_(), slotLimit);
            if (current.m_41613_() >= limit || !current.m_41656_(stack)) {
                return stack;
            }
            int maxSize = current.m_41613_() + stack.m_41613_();
            int newSize = Math.min(maxSize, limit);
            leftover = maxSize - newSize;
            if (!simulate) {
                current.m_41764_(newSize);
                inventory.setStack(tool, this.modifierLevel, localSlot, current);
            }
        }
        if (leftover == 0) {
            return ItemStack.f_41583_;
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)leftover);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount <= 0) {
            return ItemStack.f_41583_;
        }
        IInventoryModifier inventory = this.getInventory(slot);
        if (inventory == null) {
            return ItemStack.f_41583_;
        }
        int localSlot = slot - this.startForSlot;
        ItemStack current = this.getCached(inventory, localSlot, slot);
        if (current.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (amount > current.m_41613_()) {
            amount = current.m_41613_();
        }
        ItemStack result = ItemHandlerHelper.copyStackWithSize((ItemStack)current, (int)amount);
        if (!simulate) {
            if (amount == current.m_41613_()) {
                this.setAndCache(inventory, localSlot, slot, ItemStack.f_41583_);
            } else {
                current.m_41774_(amount);
                inventory.setStack(this.tool.get(), this.modifierLevel, localSlot, current);
            }
        }
        return result;
    }

    public static void addSlots(ModDataNBT volatileData, int count) {
        volatileData.putInt(TOTAL_SLOTS, volatileData.getInt(TOTAL_SLOTS) + count);
    }

    public static InteractionResult tryOpenContainer(ItemStack stack, IToolStackView tool, Player player, EquipmentSlot slotType) {
        return ToolInventoryCapability.tryOpenContainer(stack, tool, tool.getDefinition(), player, slotType);
    }

    public static InteractionResult tryOpenContainer(ItemStack stack, @Nullable IToolStackView tool, ToolDefinition definition, Player player, EquipmentSlot slotType) {
        IItemHandler handler = stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(cap -> cap instanceof IItemHandlerModifiable).orElse(null);
        if (handler != null) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                NetworkHooks.openGui((ServerPlayer)serverPlayer, (MenuProvider)new SimpleMenuProvider((id, inventory, p) -> new ToolContainerMenu(id, inventory, stack, (IItemHandlerModifiable)handler, slotType), TooltipUtil.getDisplayName(stack, tool, definition)), buf -> buf.m_130068_((Enum)slotType));
            }
            return InteractionResult.m_19078_((boolean)player.f_19853_.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public ToolInventoryCapability(Supplier<? extends IToolStackView> tool) {
        this.tool = tool;
    }

    public static interface IInventoryModifier {
        public int getSlots(IToolStackView var1, int var2);

        public ItemStack getStack(IToolStackView var1, int var2, int var3);

        public void setStack(IToolStackView var1, int var2, int var3, ItemStack var4);

        default public int getSlotLimit(IToolStackView tool, int slot) {
            return 64;
        }

        default public boolean isItemValid(IToolStackView tool, int slot, ItemStack stack) {
            return true;
        }

        @Nullable
        default public Pattern getPattern(IToolStackView tool, int level, int slot, boolean hasStack) {
            return null;
        }
    }

    public static class Provider
    implements ToolCapabilityProvider.IToolCapabilityProvider {
        private final LazyOptional<ToolInventoryCapability> handler = LazyOptional.of(() -> new ToolInventoryCapability(tool));

        public Provider(ItemStack stack, Supplier<? extends IToolStackView> tool) {
        }

        @Override
        public <T> LazyOptional<T> getCapability(IToolStackView tool, Capability<T> cap) {
            if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && tool.getVolatileData().getInt(TOTAL_SLOTS) > 0) {
                return this.handler.cast();
            }
            return LazyOptional.empty();
        }

        @Override
        public void clearCache() {
            this.handler.ifPresent(ToolInventoryCapability::clearCache);
        }
    }
}

