/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition.aoe;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.definition.aoe.BoxAOEIterator;
import slimeknights.tconstruct.library.tools.definition.aoe.IAreaOfEffectIterator;
import slimeknights.tconstruct.library.tools.definition.aoe.IBoxExpansion;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.JsonUtils;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class CircleAOEIterator
implements IAreaOfEffectIterator {
    public static final Loader LOADER = new Loader();
    @VisibleForTesting
    protected final int diameter;
    @VisibleForTesting
    protected final boolean is3D;

    public GenericLoaderRegistry.IGenericLoader<?> getLoader() {
        return LOADER;
    }

    @Override
    public Iterable<BlockPos> getBlocks(IToolStackView tool, ItemStack stack, Player player, BlockState state, Level world, BlockPos origin, Direction sideHit, IAreaOfEffectIterator.AOEMatchType matchType) {
        int expanded = tool.getModifierLevel((Modifier)TinkerModifiers.expanded.get());
        return CircleAOEIterator.calculate(tool, stack, world, player, origin, sideHit, this.diameter + expanded, this.is3D, matchType);
    }

    public static Iterable<BlockPos> calculate(IToolStackView tool, ItemStack stack, Level world, Player player, BlockPos origin, Direction sideHit, int diameter, boolean is3D, IAreaOfEffectIterator.AOEMatchType matchType) {
        if (diameter == 1) {
            return Collections.emptyList();
        }
        int radiusSq = diameter * diameter / 4;
        Predicate<BlockPos> posPredicate = IAreaOfEffectIterator.defaultBlockPredicate(tool, stack, world, origin, matchType);
        IBoxExpansion.ExpansionDirections directions = IBoxExpansion.SIDE_HIT.getDirections(player, sideHit);
        return () -> new CircleIterator(origin, directions.width(), directions.height(), directions.traverseDown(), directions.depth(), radiusSq, diameter / 2, is3D, posPredicate);
    }

    public CircleAOEIterator(int diameter, boolean is3D) {
        this.diameter = diameter;
        this.is3D = is3D;
    }

    public int getDiameter() {
        return this.diameter;
    }

    public boolean is3D() {
        return this.is3D;
    }

    private static class Loader
    implements GenericLoaderRegistry.IGenericLoader<CircleAOEIterator> {
        private Loader() {
        }

        public CircleAOEIterator deserialize(JsonObject json) {
            int diameter = JsonUtils.getIntMin(json, "diameter", 1);
            boolean is3D = GsonHelper.m_13855_((JsonObject)json, (String)"3D", (boolean)false);
            return new CircleAOEIterator(diameter, is3D);
        }

        public CircleAOEIterator fromNetwork(FriendlyByteBuf buffer) {
            int diameter = buffer.m_130242_();
            boolean is3D = buffer.readBoolean();
            return new CircleAOEIterator(diameter, is3D);
        }

        public void serialize(CircleAOEIterator object, JsonObject json) {
            json.addProperty("diameter", (Number)object.diameter);
            json.addProperty("3D", Boolean.valueOf(object.is3D));
        }

        public void toNetwork(CircleAOEIterator object, FriendlyByteBuf buffer) {
            buffer.m_130130_(object.diameter);
            buffer.writeBoolean(object.is3D);
        }
    }

    private static class CircleIterator
    extends BoxAOEIterator.RectangleIterator {
        private final int radiusSq;

        private CircleIterator(BlockPos origin, Direction widthDir, Direction heightDir, boolean traverseDown, Direction depthDir, int radiusSq, int extra, boolean is3D, Predicate<BlockPos> posPredicate) {
            super(origin, widthDir, extra, heightDir, extra, traverseDown, depthDir, is3D ? extra : 0, posPredicate);
            this.radiusSq = radiusSq;
        }

        private int distanceSq() {
            int dx = this.origin.m_123341_() - this.mutablePos.m_123341_();
            int dy = this.origin.m_123342_() - this.mutablePos.m_123342_();
            int dz = this.origin.m_123343_() - this.mutablePos.m_123343_();
            return dx * dx + dy * dy + dz * dz;
        }

        @Override
        protected BlockPos computeNext() {
            this.mutablePos.m_122178_(this.lastX, this.lastY, this.lastZ);
            while (this.incrementPosition()) {
                if (this.mutablePos.equals((Object)this.origin) || this.distanceSq() > this.radiusSq || !this.posPredicate.test(this.mutablePos)) continue;
                this.lastX = this.mutablePos.m_123341_();
                this.lastY = this.mutablePos.m_123342_();
                this.lastZ = this.mutablePos.m_123343_();
                return this.mutablePos;
            }
            return (BlockPos)this.endOfData();
        }
    }
}

