/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition.aoe;

import com.google.common.collect.AbstractIterator;
import com.google.gson.JsonObject;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.definition.aoe.IAreaOfEffectIterator;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.JsonUtils;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class TreeAOEIterator
implements IAreaOfEffectIterator {
    public static final Loader LOADER = new Loader();
    private static final int MAX_BRANCH_DISTANCE = 10;
    private final int width;
    private final int depth;

    public GenericLoaderRegistry.IGenericLoader<?> getLoader() {
        return LOADER;
    }

    @Override
    public Iterable<BlockPos> getBlocks(IToolStackView tool, ItemStack stack, Player player, BlockState state, Level world, BlockPos origin, Direction sideHit, IAreaOfEffectIterator.AOEMatchType matchType) {
        int expanded = tool.getModifierLevel((Modifier)TinkerModifiers.expanded.get());
        return TreeAOEIterator.calculate(tool, stack, player, state, world, origin, sideHit, this.width + (expanded + 1) / 2, this.depth + expanded / 2, matchType);
    }

    public static Iterable<BlockPos> calculate(IToolStackView tool, ItemStack stack, Player player, BlockState state, Level world, BlockPos origin, Direction sideHit, int extraWidth, int extraDepth, IAreaOfEffectIterator.AOEMatchType matchType) {
        Direction widthDir;
        Direction depthDir;
        if (extraDepth > 0 || extraWidth > 0) {
            depthDir = sideHit.m_122434_().m_122478_() ? player.m_6350_() : sideHit.m_122424_();
            widthDir = depthDir.m_122427_();
        } else {
            depthDir = Direction.UP;
            widthDir = Direction.UP;
        }
        return () -> new TreeIterator(world, state.m_60734_(), origin, widthDir, extraWidth, depthDir, extraDepth);
    }

    public TreeAOEIterator(int width, int depth) {
        this.width = width;
        this.depth = depth;
    }

    private static class Loader
    implements GenericLoaderRegistry.IGenericLoader<TreeAOEIterator> {
        private Loader() {
        }

        public TreeAOEIterator deserialize(JsonObject json) {
            int width = JsonUtils.getIntMin(json, "width_bonus", 0);
            int depth = JsonUtils.getIntMin(json, "depth_bonus", 0);
            return new TreeAOEIterator(width, depth);
        }

        public TreeAOEIterator fromNetwork(FriendlyByteBuf buffer) {
            int width = buffer.m_130242_();
            int depth = buffer.m_130242_();
            return new TreeAOEIterator(width, depth);
        }

        public void serialize(TreeAOEIterator object, JsonObject json) {
            json.addProperty("width_bonus", (Number)object.width);
            json.addProperty("depth_bonus", (Number)object.depth);
        }

        public void toNetwork(TreeAOEIterator object, FriendlyByteBuf buffer) {
            buffer.m_130130_(object.width);
            buffer.m_130130_(object.depth);
        }
    }

    public static class TreeIterator
    extends AbstractIterator<BlockPos> {
        private final Queue<TreePos> upcomingPositions = new ArrayDeque<TreePos>();
        private final BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        private final Set<BlockPos> branchVisited = new HashSet<BlockPos>();
        private final Level world;
        private final Block filter;
        private final int minX;
        private final int maxX;
        private final int minZ;
        private final int maxZ;

        public TreeIterator(Level world, Block filter, BlockPos origin, Direction widthDir, int extraWidth, Direction depthDir, int extraDepth) {
            int minZ;
            int minX;
            this.world = world;
            this.filter = filter;
            this.upcomingPositions.add(new TreePos(origin.m_7494_(), false));
            int maxX = minX = origin.m_123341_();
            int maxZ = minZ = origin.m_123343_();
            if (extraDepth > 0 || extraWidth > 0) {
                for (int d = 0; d <= extraDepth; ++d) {
                    for (int w = -extraWidth; w <= extraWidth; ++w) {
                        if (d == 0 && w == 0) continue;
                        this.mutable.m_122190_((Vec3i)origin).m_122175_(depthDir, d).m_122175_(widthDir, w);
                        if (!this.isValidBlock((BlockPos)this.mutable)) continue;
                        this.upcomingPositions.add(new TreePos((BlockPos)this.mutable, true));
                        if (this.mutable.m_123341_() < minX) {
                            minX = this.mutable.m_123341_();
                        }
                        if (this.mutable.m_123341_() > maxX) {
                            maxX = this.mutable.m_123341_();
                        }
                        if (this.mutable.m_123343_() < minZ) {
                            minZ = this.mutable.m_123343_();
                        }
                        if (this.mutable.m_123343_() <= maxZ) continue;
                        maxZ = this.mutable.m_123343_();
                    }
                }
            }
            this.minX = minX;
            this.maxX = maxX;
            this.minZ = minZ;
            this.maxZ = maxZ;
        }

        private boolean isValidBlock(BlockPos pos) {
            return this.world.m_8055_(pos).m_60734_() == this.filter;
        }

        private boolean outsideTrunk(BlockPos pos) {
            return pos.m_123341_() < this.minX || pos.m_123341_() > this.maxX || pos.m_123343_() < this.minZ || pos.m_123343_() > this.maxZ;
        }

        private boolean isBranch(BlockPos pos) {
            int deltaZ;
            if (!this.outsideTrunk(pos)) {
                return false;
            }
            int deltaX = Math.min(Math.abs(pos.m_123341_() - this.minX), Math.abs(pos.m_123341_() - this.maxX));
            if (deltaX + (deltaZ = Math.min(Math.abs(pos.m_123343_() - this.minZ), Math.abs(pos.m_123343_() - this.maxZ))) > 10 || this.branchVisited.contains(pos)) {
                return false;
            }
            this.branchVisited.add(pos.m_7949_());
            return this.isValidBlock(pos);
        }

        private void addBranch(Direction direction) {
            this.upcomingPositions.add(new TreePos((BlockPos)this.mutable, direction));
        }

        private void tryBranch(Direction direction) {
            if (this.isBranch((BlockPos)this.mutable)) {
                TreePos branchPos = new TreePos((BlockPos)this.mutable, direction);
                if (!this.world.m_8055_((BlockPos)this.mutable.m_122184_(0, -1, 0)).m_60815_()) {
                    this.upcomingPositions.add(branchPos);
                }
            }
        }

        protected BlockPos computeNext() {
            while (!this.upcomingPositions.isEmpty()) {
                TreePos treePos = this.upcomingPositions.remove();
                if (treePos.direction == Direction.UP) {
                    boolean isMaxZ;
                    boolean isTreeUp = treePos.isChecked || this.isValidBlock((BlockPos)treePos.pos);
                    for (Direction direction : Direction.Plane.HORIZONTAL) {
                        this.mutable.m_122190_((Vec3i)treePos.pos).m_122173_(direction);
                        this.tryBranch(!isTreeUp ? Direction.UP : direction);
                    }
                    if (!isTreeUp) continue;
                    boolean isMinX = treePos.pos.m_123341_() == this.minX;
                    boolean isMaxX = treePos.pos.m_123341_() == this.maxX;
                    boolean isMinZ = treePos.pos.m_123343_() == this.minZ;
                    boolean bl = isMaxZ = treePos.pos.m_123343_() == this.maxZ;
                    if (isMinX) {
                        if (isMinZ) {
                            this.mutable.m_122190_((Vec3i)treePos.pos).m_122184_(-1, 0, -1);
                            this.tryBranch(Direction.WEST);
                        }
                        if (isMaxZ) {
                            this.mutable.m_122190_((Vec3i)treePos.pos).m_122184_(-1, 0, 1);
                            this.tryBranch(Direction.WEST);
                        }
                    }
                    if (isMaxX) {
                        if (isMinZ) {
                            this.mutable.m_122190_((Vec3i)treePos.pos).m_122184_(1, 0, -1);
                            this.tryBranch(Direction.EAST);
                        }
                        if (isMaxZ) {
                            this.mutable.m_122190_((Vec3i)treePos.pos).m_122184_(1, 0, 1);
                            this.tryBranch(Direction.EAST);
                        }
                    }
                    this.mutable.m_122190_((Vec3i)treePos.pos);
                    this.upcomingPositions.add(treePos.move());
                    if (this.outsideTrunk((BlockPos)treePos.pos)) {
                        this.branchVisited.add((BlockPos)treePos.pos);
                    }
                    return this.mutable;
                }
                this.mutable.m_122190_((Vec3i)treePos.pos).m_122184_(0, 1, 0);
                if (this.isBranch((BlockPos)this.mutable)) {
                    this.addBranch(treePos.direction);
                } else if (this.isBranch((BlockPos)this.mutable.m_122173_(treePos.direction).m_122184_(0, -1, 0))) {
                    this.addBranch(treePos.direction);
                } else if (this.isBranch((BlockPos)this.mutable.m_122184_(0, 1, 0))) {
                    this.addBranch(treePos.direction);
                }
                Direction rotated = treePos.direction.m_122427_();
                this.mutable.m_122190_((Vec3i)treePos.pos).m_122173_(rotated);
                if (this.isBranch((BlockPos)this.mutable)) {
                    this.addBranch(rotated);
                } else if (this.isBranch((BlockPos)this.mutable.m_122184_(0, 1, 0))) {
                    this.addBranch(rotated);
                } else if (this.isBranch((BlockPos)this.mutable.m_122173_(treePos.direction).m_122184_(0, -1, 0))) {
                    this.addBranch(rotated);
                } else if (this.isBranch((BlockPos)this.mutable.m_122184_(0, 1, 0))) {
                    this.addBranch(rotated);
                }
                rotated = rotated.m_122424_();
                this.mutable.m_122190_((Vec3i)treePos.pos).m_122173_(rotated);
                if (this.isBranch((BlockPos)this.mutable)) {
                    this.addBranch(rotated);
                } else if (this.isBranch((BlockPos)this.mutable.m_122184_(0, 1, 0))) {
                    this.addBranch(rotated);
                } else if (this.isBranch((BlockPos)this.mutable.m_122173_(treePos.direction).m_122184_(0, -1, 0))) {
                    this.addBranch(rotated);
                } else if (this.isBranch((BlockPos)this.mutable.m_122184_(0, 1, 0))) {
                    this.addBranch(rotated);
                }
                return treePos.pos;
            }
            return (BlockPos)this.endOfData();
        }
    }

    private static class TreePos {
        private final BlockPos.MutableBlockPos pos;
        private final Direction direction;
        private boolean isChecked;

        TreePos(BlockPos pos, boolean isChecked) {
            this.pos = pos.m_122032_();
            this.direction = Direction.UP;
            this.isChecked = isChecked;
        }

        TreePos(BlockPos pos, Direction direction) {
            this.pos = pos.m_122032_();
            this.direction = direction;
            this.isChecked = true;
        }

        public TreePos move() {
            this.pos.m_122173_(this.direction);
            this.isChecked = false;
            return this;
        }
    }
}

