/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition.harvest;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.tags.Tag;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.json.LazyTag;
import slimeknights.tconstruct.library.tools.definition.harvest.TagHarvestLogic;
import slimeknights.tconstruct.library.tools.definition.harvest.predicate.BlockPredicate;
import slimeknights.tconstruct.library.tools.definition.harvest.predicate.SetBlockPredicate;
import slimeknights.tconstruct.library.tools.definition.harvest.predicate.TagBlockPredicate;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class ModifiedHarvestLogic
extends TagHarvestLogic {
    public static final Loader LOADER = new Loader();
    private final SpeedModifier[] speedModifiers;

    protected ModifiedHarvestLogic(LazyTag<Block> tag, SpeedModifier[] speedModifiers) {
        super(tag);
        this.speedModifiers = speedModifiers;
    }

    public static Builder builder(Tag.Named<Block> tag) {
        return new Builder(LazyTag.of(tag));
    }

    @Override
    public GenericLoaderRegistry.IGenericLoader<?> getLoader() {
        return LOADER;
    }

    @Override
    public float getDestroySpeed(IToolStackView tool, BlockState state) {
        float speed = super.getDestroySpeed(tool, state);
        for (SpeedModifier modifier : this.speedModifiers) {
            if (!modifier.predicate.matches(state)) continue;
            return Math.max(1.0f, speed * modifier.modifier);
        }
        return speed;
    }

    private static class SpeedModifier {
        protected final float modifier;
        protected final BlockPredicate predicate;

        public JsonObject toJson() {
            JsonObject json = new JsonObject();
            json.addProperty("modifier", (Number)Float.valueOf(this.modifier));
            json.add("predicate", (JsonElement)BlockPredicate.LOADER.serialize((GenericLoaderRegistry.IHaveLoader)this.predicate));
            return json;
        }

        public void toNetwork(FriendlyByteBuf buffer) {
            buffer.writeFloat(this.modifier);
            BlockPredicate.LOADER.toNetwork((GenericLoaderRegistry.IHaveLoader)this.predicate, buffer);
        }

        private static SpeedModifier fromJson(JsonObject json) {
            float modifier = GsonHelper.m_13915_((JsonObject)json, (String)"modifier");
            BlockPredicate predicate = (BlockPredicate)BlockPredicate.LOADER.deserialize(GsonHelper.m_13930_((JsonObject)json, (String)"predicate"));
            return new SpeedModifier(modifier, predicate);
        }

        private static SpeedModifier fromNetwork(FriendlyByteBuf buffer) {
            float modifier = buffer.readFloat();
            BlockPredicate predicate = (BlockPredicate)BlockPredicate.LOADER.fromNetwork(buffer);
            return new SpeedModifier(modifier, predicate);
        }

        public SpeedModifier(float modifier, BlockPredicate predicate) {
            this.modifier = modifier;
            this.predicate = predicate;
        }
    }

    public static class Builder {
        private final LazyTag<Block> tag;
        private final List<SpeedModifier> speedModifiers = new ArrayList<SpeedModifier>();

        public Builder addModifier(float modifier, BlockPredicate predicate) {
            this.speedModifiers.add(new SpeedModifier(modifier, predicate));
            return this;
        }

        public Builder tagModifier(Tag.Named<Block> tag, float modifier) {
            return this.addModifier(modifier, new TagBlockPredicate(LazyTag.of(tag)));
        }

        public Builder notTagModifier(Tag.Named<Block> tag, float modifier) {
            return this.addModifier(modifier, new TagBlockPredicate(LazyTag.of(tag)).inverted());
        }

        public Builder blockModifier(float modifier, Block ... blocks) {
            return this.addModifier(modifier, new SetBlockPredicate((Set<Block>)ImmutableSet.copyOf((Object[])blocks)));
        }

        public Builder notBlockModifier(float modifier, Block ... blocks) {
            return this.addModifier(modifier, new SetBlockPredicate((Set<Block>)ImmutableSet.copyOf((Object[])blocks)).inverted());
        }

        public ModifiedHarvestLogic build() {
            return new ModifiedHarvestLogic(this.tag, this.speedModifiers.toArray(new SpeedModifier[0]));
        }

        protected Builder(LazyTag<Block> tag) {
            this.tag = tag;
        }
    }

    private static class Loader
    implements GenericLoaderRegistry.IGenericLoader<ModifiedHarvestLogic> {
        private Loader() {
        }

        public ModifiedHarvestLogic deserialize(JsonObject json) {
            LazyTag<Block> tag = LazyTag.fromJson(Registry.f_122901_, json, "effective");
            SpeedModifier[] modifiers = JsonHelper.parseList((JsonObject)json, (String)"modifiers", SpeedModifier::fromJson).toArray(new SpeedModifier[0]);
            return new ModifiedHarvestLogic(tag, modifiers);
        }

        public ModifiedHarvestLogic fromNetwork(FriendlyByteBuf buffer) {
            LazyTag<Block> tag = LazyTag.fromNetwork(Registry.f_122901_, buffer);
            SpeedModifier[] modifiers = new SpeedModifier[buffer.m_130242_()];
            for (int i = 0; i < modifiers.length; ++i) {
                modifiers[i] = SpeedModifier.fromNetwork(buffer);
            }
            return new ModifiedHarvestLogic(tag, modifiers);
        }

        public void serialize(ModifiedHarvestLogic object, JsonObject json) {
            json.addProperty("effective", object.tag.m_6979_().toString());
            JsonArray modifiers = new JsonArray();
            for (SpeedModifier modifier : object.speedModifiers) {
                modifiers.add((JsonElement)modifier.toJson());
            }
            json.add("modifiers", (JsonElement)modifiers);
        }

        public void toNetwork(ModifiedHarvestLogic object, FriendlyByteBuf buffer) {
            object.tag.toNetwork(buffer);
            buffer.m_130130_(object.speedModifiers.length);
            for (SpeedModifier modifier : object.speedModifiers) {
                modifier.toNetwork(buffer);
            }
        }
    }
}

