/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition.harvest;

import com.google.gson.JsonObject;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.TierSortingRegistry;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.tconstruct.library.json.LazyTag;
import slimeknights.tconstruct.library.tools.definition.harvest.IHarvestLogic;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class TagHarvestLogic
implements IHarvestLogic {
    public static final Loader LOADER = new Loader();
    protected final LazyTag<Block> tag;

    public TagHarvestLogic(Tag.Named<Block> tag) {
        this.tag = LazyTag.of(tag);
    }

    @Override
    public boolean isEffective(IToolStackView tool, BlockState state) {
        return state.m_60620_(this.tag) && TierSortingRegistry.isCorrectTierForDrops((Tier)tool.getStats().get(ToolStats.HARVEST_TIER), (BlockState)state);
    }

    @Override
    public float getDestroySpeed(IToolStackView tool, BlockState state) {
        return state.m_60620_(this.tag) ? tool.getStats().get(ToolStats.MINING_SPEED).floatValue() : 1.0f;
    }

    public GenericLoaderRegistry.IGenericLoader<?> getLoader() {
        return LOADER;
    }

    public TagHarvestLogic(LazyTag<Block> tag) {
        this.tag = tag;
    }

    private static class Loader
    implements GenericLoaderRegistry.IGenericLoader<TagHarvestLogic> {
        private Loader() {
        }

        public TagHarvestLogic deserialize(JsonObject json) {
            LazyTag<Block> tag = LazyTag.fromJson(Registry.f_122901_, json, "effective");
            return new TagHarvestLogic(tag);
        }

        public TagHarvestLogic fromNetwork(FriendlyByteBuf buffer) {
            LazyTag<Block> tag = LazyTag.fromNetwork(Registry.f_122901_, buffer);
            return new TagHarvestLogic(tag);
        }

        public void serialize(TagHarvestLogic object, JsonObject json) {
            json.addProperty("effective", object.tag.m_6979_().toString());
        }

        public void toNetwork(TagHarvestLogic object, FriendlyByteBuf buffer) {
            object.tag.toNetwork(buffer);
        }
    }
}

