/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.helper;

import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.client.materials.MaterialTooltipCache;
import slimeknights.tconstruct.library.materials.IMaterialRegistry;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.definition.PartRequirement;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.helper.TooltipBuilder;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.item.IModifiableDisplay;
import slimeknights.tconstruct.library.tools.item.ITinkerStationDisplay;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.MaterialNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.SafeClientAccess;
import slimeknights.tconstruct.library.utils.TooltipKey;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class TooltipUtil {
    public static final String KEY_DISPLAY = "tic_display";
    public static final BiPredicate<Attribute, AttributeModifier.Operation> SHOW_ALL_ATTRIBUTES = (att, op) -> true;
    public static final BiPredicate<Attribute, AttributeModifier.Operation> SHOW_MELEE_ATTRIBUTES = (att, op) -> op != AttributeModifier.Operation.ADDITION || att != Attributes.f_22281_ && att != Attributes.f_22283_;
    public static final BiPredicate<Attribute, AttributeModifier.Operation> SHOW_ARMOR_ATTRIBUTES = (att, op) -> op != AttributeModifier.Operation.ADDITION || att != Attributes.f_22284_ && att != Attributes.f_22285_ && att != Attributes.f_22278_;
    public static final Component TOOLTIP_HOLD_SHIFT = TConstruct.makeTranslation("tooltip", "hold_shift", TConstruct.makeTranslation("key", "shift").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.ITALIC}));
    public static final Component TOOLTIP_HOLD_CTRL = TConstruct.makeTranslation("tooltip", "hold_ctrl", TConstruct.makeTranslation("key", "ctrl").m_130944_(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.ITALIC}));
    private static final Component NO_DATA = TConstruct.makeTranslation("tooltip", "missing_data").m_130940_(ChatFormatting.GRAY);
    private static final Component UNINITIALIZED = TConstruct.makeTranslation("tooltip", "uninitialized").m_130940_(ChatFormatting.GRAY);
    private static final Component RANDOM_MATERIALS = TConstruct.makeTranslation("tooltip", "random_materials").m_130940_(ChatFormatting.GRAY);

    private TooltipUtil() {
    }

    public static boolean isDisplay(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        return nbt != null && nbt.m_128471_(KEY_DISPLAY);
    }

    @Nullable
    private static Component nameFor(String itemKey, Component itemName, MaterialVariantId variantId) {
        String materialKey = MaterialTooltipCache.getKey(variantId);
        String key = itemKey + "." + materialKey;
        if (Util.canTranslate(key)) {
            return new TranslatableComponent(key);
        }
        String formatKey = materialKey + ".format";
        if (Util.canTranslate(formatKey)) {
            return new TranslatableComponent(formatKey, new Object[]{itemName});
        }
        if (Util.canTranslate(materialKey)) {
            return new TranslatableComponent(materialKey).m_130946_(" ").m_7220_(itemName);
        }
        return null;
    }

    private static Component getMaterialItemName(ItemStack stack, Component itemName, MaterialVariantId material) {
        Component component;
        String itemKey = stack.m_41778_();
        if (material.hasVariant() && (component = TooltipUtil.nameFor(itemKey, itemName, material)) != null) {
            return component;
        }
        component = TooltipUtil.nameFor(itemKey, itemName, material.getId());
        if (component != null) {
            return component;
        }
        return itemName;
    }

    private static Component getCombinedItemName(Component itemName, Collection<Component> materials) {
        if (materials.isEmpty()) {
            return itemName;
        }
        TextComponent name = new TextComponent("");
        Iterator<Component> iter = materials.iterator();
        name.m_7220_(iter.next());
        while (iter.hasNext()) {
            name.m_130946_("-").m_7220_(iter.next());
        }
        name.m_130946_(" ").m_7220_(itemName);
        return name;
    }

    public static Component getDisplayName(ItemStack stack, ToolDefinition toolDefinition) {
        return TooltipUtil.getDisplayName(stack, null, toolDefinition);
    }

    public static Component getDisplayName(ItemStack stack, @Nullable IToolStackView tool, ToolDefinition toolDefinition) {
        MaterialNBT materials;
        List<PartRequirement> components = toolDefinition.getData().getParts();
        TranslatableComponent baseName = new TranslatableComponent(stack.m_41778_());
        if (components.isEmpty()) {
            return baseName;
        }
        if (tool == null) {
            tool = ToolStack.from(stack);
        }
        if ((materials = tool.getMaterials()).size() != components.size()) {
            return baseName;
        }
        LinkedHashSet nameMaterials = Sets.newLinkedHashSet();
        MaterialVariantId firstMaterial = null;
        IMaterialRegistry registry = MaterialRegistry.getInstance();
        for (int i = 0; i < components.size(); ++i) {
            MaterialVariantId material;
            if (i >= materials.size() || !registry.canRepair(components.get(i).getStatType()) || IMaterial.UNKNOWN_ID.equals(material = materials.get(i).getVariant())) continue;
            if (firstMaterial == null) {
                firstMaterial = material;
            }
            nameMaterials.add(MaterialTooltipCache.getDisplayName(material));
        }
        if (nameMaterials.size() == 1) {
            return TooltipUtil.getMaterialItemName(stack, (Component)baseName, firstMaterial);
        }
        return TooltipUtil.getCombinedItemName((Component)baseName, nameMaterials);
    }

    public static void addInformation(IModifiableDisplay item, ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        Player player = world == null ? null : SafeClientAccess.getPlayer();
        TooltipUtil.addInformation(item, stack, player, tooltip, tooltipKey, tooltipFlag);
    }

    public static void addInformation(IModifiableDisplay item, ItemStack stack, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        ToolDefinition definition = item.getToolDefinition();
        if (TooltipUtil.isDisplay(stack)) {
            ToolStack tool = ToolStack.from(stack);
            TooltipUtil.addModifierNames(stack, tool, tooltip);
        } else if (!definition.isDataLoaded()) {
            tooltip.add(NO_DATA);
        } else if (!ToolStack.isInitialized(stack)) {
            CompoundTag nbt;
            tooltip.add(UNINITIALIZED);
            if (definition.isMultipart() && ((nbt = stack.m_41783_()) == null || !nbt.m_128425_("tic_materials", 9))) {
                tooltip.add(RANDOM_MATERIALS);
            }
        } else {
            switch (tooltipKey) {
                case SHIFT: {
                    item.getStatInformation(ToolStack.from(stack), player, tooltip, tooltipKey, tooltipFlag);
                    break;
                }
                case CONTROL: {
                    if (definition.isMultipart()) {
                        TooltipUtil.getComponents(item, stack, tooltip);
                        break;
                    }
                }
                default: {
                    ToolStack tool = ToolStack.from(stack);
                    TooltipUtil.getDefaultInfo(stack, tool, tooltip);
                    TooltipUtil.addAttributes(item, tool, player, tooltip, SHOW_ALL_ATTRIBUTES, EquipmentSlot.values());
                }
            }
        }
    }

    public static void getDefaultInfo(ItemStack stack, List<Component> tooltips) {
        TooltipUtil.getDefaultInfo(stack, ToolStack.from(stack), tooltips);
    }

    public static void addModifierNames(ItemStack stack, IToolStackView tool, List<Component> tooltips) {
        CompoundTag tag;
        for (ModifierEntry entry : tool.getModifierList()) {
            if (!entry.getModifier().shouldDisplay(false)) continue;
            tooltips.add(entry.getModifier().getDisplayName(tool, entry.getLevel()));
        }
        if (!stack.m_41619_() && (tag = stack.m_41783_()) != null && tag.m_128425_("Enchantments", 9)) {
            ListTag enchantments = tag.m_128437_("Enchantments", 10);
            for (int i = 0; i < enchantments.size(); ++i) {
                CompoundTag enchantmentTag = enchantments.m_128728_(i);
                Registry.f_122825_.m_6612_(ResourceLocation.m_135820_((String)enchantmentTag.m_128461_("id"))).ifPresent(enchantment -> tooltips.add(enchantment.m_44700_(enchantmentTag.m_128451_("lvl"))));
            }
        }
    }

    public static void getDefaultInfo(ItemStack stack, IToolStackView tool, List<Component> tooltips) {
        if (tool.getItem().m_41465_() && !tool.isUnbreakable()) {
            tooltips.add(TooltipBuilder.formatDurability(tool.getCurrentDurability(), tool.getStats().getInt(ToolStats.DURABILITY), true));
        }
        TooltipUtil.addModifierNames(stack, tool, tooltips);
        tooltips.add(TextComponent.f_131282_);
        tooltips.add(TOOLTIP_HOLD_SHIFT);
        if (tool.getDefinition().isMultipart()) {
            tooltips.add(TOOLTIP_HOLD_CTRL);
        }
    }

    public static List<Component> getDefaultStats(IToolStackView tool, @Nullable Player player, List<Component> tooltip, TooltipKey key, TooltipFlag flag) {
        TooltipBuilder builder = new TooltipBuilder(tool, tooltip);
        Item item = tool.getItem();
        if (TinkerTags.Items.DURABILITY.m_8110_((Object)item)) {
            builder.addDurability();
        }
        if (TinkerTags.Items.MELEE.m_8110_((Object)item)) {
            builder.addWithAttribute(ToolStats.ATTACK_DAMAGE, Attributes.f_22281_);
            builder.add(ToolStats.ATTACK_SPEED);
        }
        if (TinkerTags.Items.HARVEST.m_8110_((Object)item)) {
            if (TinkerTags.Items.HARVEST_PRIMARY.m_8110_((Object)tool.getItem())) {
                builder.addTier();
            }
            builder.add(ToolStats.MINING_SPEED);
        }
        builder.addAllFreeSlots();
        for (ModifierEntry entry : tool.getModifierList()) {
            entry.getModifier().addInformation(tool, entry.getLevel(), player, tooltip, key, flag);
        }
        return builder.getTooltips();
    }

    public static List<Component> getArmorStats(IToolStackView tool, @Nullable Player player, List<Component> tooltip, TooltipKey key, TooltipFlag flag) {
        TooltipBuilder builder = new TooltipBuilder(tool, tooltip);
        Item item = tool.getItem();
        if (TinkerTags.Items.DURABILITY.m_8110_((Object)item)) {
            builder.addDurability();
        }
        if (TinkerTags.Items.ARMOR.m_8110_((Object)item)) {
            builder.add(ToolStats.ARMOR);
            builder.addOptional(ToolStats.ARMOR_TOUGHNESS);
            builder.addOptional(ToolStats.KNOCKBACK_RESISTANCE, 10.0f);
        }
        if (TinkerTags.Items.CHESTPLATES.m_8110_((Object)item) && tool.getModifierLevel((Modifier)TinkerModifiers.unarmed.get()) > 0) {
            builder.addWithAttribute(ToolStats.ATTACK_DAMAGE, Attributes.f_22281_);
        }
        builder.addAllFreeSlots();
        for (ModifierEntry entry : tool.getModifierList()) {
            entry.getModifier().addInformation(tool, entry.getLevel(), player, tooltip, key, flag);
        }
        return builder.getTooltips();
    }

    public static void getComponents(IModifiable item, ItemStack stack, List<Component> tooltips) {
        List<PartRequirement> components = item.getToolDefinition().getData().getParts();
        if (components.isEmpty()) {
            return;
        }
        MaterialNBT materials = ToolStack.from(stack).getMaterials();
        if (materials.size() == 0) {
            tooltips.add(NO_DATA);
            return;
        }
        if (materials.size() < components.size()) {
            return;
        }
        int max = components.size() - 1;
        for (int i = 0; i <= max; ++i) {
            PartRequirement requirement = components.get(i);
            MaterialVariantId material = materials.get(i).getVariant();
            tooltips.add((Component)requirement.nameForMaterial(material).m_6881_().m_130940_(ChatFormatting.UNDERLINE).m_130938_(style -> style.m_131148_(MaterialTooltipCache.getColor(material))));
            MaterialRegistry.getInstance().getMaterialStats(material.getId(), requirement.getStatType()).ifPresent(stat -> tooltips.addAll(stat.getLocalizedInfo()));
            if (i == max) continue;
            tooltips.add(TextComponent.f_131282_);
        }
    }

    public static void addAttributes(ITinkerStationDisplay item, IToolStackView tool, @Nullable Player player, List<Component> tooltip, BiPredicate<Attribute, AttributeModifier.Operation> showAttribute, EquipmentSlot ... slots) {
        for (EquipmentSlot slot : slots) {
            Multimap<Attribute, AttributeModifier> modifiers = item.getAttributeModifiers(tool, slot);
            if (modifiers.isEmpty()) continue;
            if (slots.length > 1) {
                tooltip.add(TextComponent.f_131282_);
                tooltip.add((Component)new TranslatableComponent("item.modifiers." + slot.m_20751_()).m_130940_(ChatFormatting.GRAY));
            }
            for (Map.Entry entry : modifiers.entries()) {
                AttributeModifier modifier;
                AttributeModifier.Operation operation;
                Attribute attribute = (Attribute)entry.getKey();
                if (!showAttribute.test(attribute, operation = (modifier = (AttributeModifier)entry.getValue()).m_22217_())) continue;
                double amount = modifier.m_22218_();
                boolean showEquals = false;
                if (player != null) {
                    if (modifier.m_22209_() == Item.f_41374_) {
                        amount += player.m_21172_(Attributes.f_22281_);
                        showEquals = true;
                    } else if (modifier.m_22209_() == Item.f_41375_) {
                        amount += player.m_21172_(Attributes.f_22283_);
                        showEquals = true;
                    }
                }
                double displayValue = amount;
                if (modifier.m_22217_() == AttributeModifier.Operation.ADDITION) {
                    if (attribute.equals(Attributes.f_22278_)) {
                        displayValue *= 10.0;
                    }
                } else {
                    displayValue *= 100.0;
                }
                TranslatableComponent name = new TranslatableComponent(attribute.m_22087_());
                if (showEquals) {
                    tooltip.add((Component)new TextComponent(" ").m_7220_((Component)new TranslatableComponent("attribute.modifier.equals." + operation.m_22235_(), new Object[]{ItemStack.f_41584_.format(displayValue), name})).m_130940_(ChatFormatting.DARK_GREEN));
                    continue;
                }
                if (amount > 0.0) {
                    tooltip.add((Component)new TranslatableComponent("attribute.modifier.plus." + operation.m_22235_(), new Object[]{ItemStack.f_41584_.format(displayValue), name}).m_130940_(ChatFormatting.BLUE));
                    continue;
                }
                if (!(amount < 0.0)) continue;
                tooltip.add((Component)new TranslatableComponent("attribute.modifier.take." + operation.m_22235_(), new Object[]{ItemStack.f_41584_.format(displayValue *= -1.0), name}).m_130940_(ChatFormatting.RED));
            }
        }
    }
}

