/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.nbt;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;
import slimeknights.tconstruct.library.tools.stat.INumericToolStat;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class MultiplierNBT {
    public static Serializer SERIALIZER = new Serializer();
    public static final MultiplierNBT EMPTY = new MultiplierNBT((Map<INumericToolStat<?>, Float>)ImmutableMap.of());
    private final Map<INumericToolStat<?>, Float> stats;

    public static Builder builder() {
        return new Builder();
    }

    public Set<INumericToolStat<?>> getContainedStats() {
        return this.stats.keySet();
    }

    public boolean hasStat(INumericToolStat<?> stat) {
        return this.stats.containsKey(stat);
    }

    public float get(INumericToolStat<?> stat) {
        return this.stats.getOrDefault(stat, Float.valueOf(1.0f)).floatValue();
    }

    public static MultiplierNBT readFromNBT(@Nullable Tag inbt) {
        if (inbt == null || inbt.m_7060_() != 10) {
            return EMPTY;
        }
        Builder builder = MultiplierNBT.builder();
        CompoundTag nbt = (CompoundTag)inbt;
        for (String key : nbt.m_128431_()) {
            IToolStat<?> iToolStat;
            if (!nbt.m_128425_(key, 99) || !((iToolStat = StatsNBT.readStatIdFromNBT(key)) instanceof INumericToolStat)) continue;
            INumericToolStat stat = (INumericToolStat)iToolStat;
            builder.set(stat, nbt.m_128457_(key));
        }
        return builder.build();
    }

    public CompoundTag serializeToNBT() {
        CompoundTag nbt = new CompoundTag();
        for (Map.Entry<INumericToolStat<?>, Float> entry : this.stats.entrySet()) {
            nbt.m_128350_(entry.getKey().getName().toString(), entry.getValue().floatValue());
        }
        return nbt;
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.stats.size());
        for (Map.Entry<INumericToolStat<?>, Float> entry : this.stats.entrySet()) {
            buffer.m_130070_(entry.getKey().getName().toString());
            buffer.writeFloat(entry.getValue().floatValue());
        }
    }

    public static MultiplierNBT fromNetwork(FriendlyByteBuf buffer) {
        Builder builder = MultiplierNBT.builder();
        int max = buffer.m_130242_();
        for (int i = 0; i < max; ++i) {
            IToolStat<?> stat = StatsNBT.statIdFromNetwork(buffer);
            float value = buffer.readFloat();
            if (!(stat instanceof INumericToolStat)) continue;
            INumericToolStat numericStat = (INumericToolStat)stat;
            builder.set(numericStat, value);
        }
        return builder.build();
    }

    MultiplierNBT(Map<INumericToolStat<?>, Float> stats) {
        this.stats = stats;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultiplierNBT)) {
            return false;
        }
        MultiplierNBT other = (MultiplierNBT)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<INumericToolStat<?>, Float> this$stats = this.stats;
        Map<INumericToolStat<?>, Float> other$stats = other.stats;
        return !(this$stats == null ? other$stats != null : !((Object)this$stats).equals(other$stats));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MultiplierNBT;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<INumericToolStat<?>, Float> $stats = this.stats;
        result = result * 59 + ($stats == null ? 43 : ((Object)$stats).hashCode());
        return result;
    }

    public String toString() {
        return "MultiplierNBT(stats=" + this.stats + ")";
    }

    public static class Builder {
        private final ImmutableMap.Builder<INumericToolStat<?>, Float> builder = ImmutableMap.builder();

        public Builder set(INumericToolStat<?> stat, float value) {
            if (value != 1.0f) {
                this.builder.put(stat, (Object)Float.valueOf(Math.max(value, 0.0f)));
            }
            return this;
        }

        public MultiplierNBT build() {
            ImmutableMap map = this.builder.build();
            if (map.isEmpty()) {
                return EMPTY;
            }
            return new MultiplierNBT((Map<INumericToolStat<?>, Float>)map);
        }

        private Builder() {
        }
    }

    protected static class Serializer
    implements JsonDeserializer<MultiplierNBT>,
    JsonSerializer<MultiplierNBT> {
        protected Serializer() {
        }

        public MultiplierNBT deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject object = GsonHelper.m_13918_((JsonElement)json, (String)"stats");
            Builder builder = MultiplierNBT.builder();
            for (Map.Entry entry : object.entrySet()) {
                String key = (String)entry.getKey();
                builder.set(ToolStats.numericFromJson(key), GsonHelper.m_13888_((JsonElement)((JsonElement)entry.getValue()), (String)key));
            }
            return builder.build();
        }

        public JsonElement serialize(MultiplierNBT stats, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject json = new JsonObject();
            for (Map.Entry<INumericToolStat<?>, Float> entry : stats.stats.entrySet()) {
                json.addProperty(entry.getKey().getName().toString(), (Number)entry.getValue());
            }
            return json;
        }
    }
}

