/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.stat;

import com.google.gson.JsonElement;
import javax.annotation.Nullable;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStatId;
import slimeknights.tconstruct.library.utils.Util;

public interface IToolStat<T> {
    public ToolStatId getName();

    public T getDefaultValue();

    default public T clamp(T value) {
        return value;
    }

    public Object makeBuilder();

    public T build(Object var1, T var2);

    public void update(ModifierStatsBuilder var1, T var2);

    @Nullable
    public T read(Tag var1);

    @Nullable
    public Tag write(T var1);

    public T deserialize(JsonElement var1);

    public JsonElement serialize(T var1);

    public T fromNetwork(FriendlyByteBuf var1);

    public void toNetwork(FriendlyByteBuf var1, T var2);

    default public MutableComponent getPrefix() {
        return new TranslatableComponent(Util.makeTranslationKey("tool_stat", this.getName()));
    }

    default public MutableComponent getDescription() {
        return new TranslatableComponent(Util.makeTranslationKey("tool_stat", this.getName()) + ".description");
    }

    public Component formatValue(T var1);

    public static Component formatNumber(String loc, TextColor color, int number) {
        return IToolStat.formatNumber(loc, color, (float)number);
    }

    public static Component formatNumber(String loc, TextColor color, float number) {
        return new TranslatableComponent(loc).m_7220_((Component)new TextComponent(Util.COMMA_FORMAT.format(number)).m_130938_(style -> style.m_131148_(color)));
    }

    public static Component formatNumberPercent(String loc, TextColor color, float number) {
        return new TranslatableComponent(loc).m_7220_((Component)new TextComponent(Util.PERCENT_FORMAT.format(number)).m_130938_(style -> style.m_131148_(color)));
    }

    public static Component formatColoredMultiplier(String loc, float number) {
        float hue = Mth.m_14091_((float)(number - 0.5f), (float)2.0f);
        return new TranslatableComponent(loc).m_7220_((Component)new TextComponent(Util.MULTIPLIER_FORMAT.format(number)).m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)Mth.m_14169_((float)(hue / 1.5f), (float)1.0f, (float)0.75f)))));
    }
}

