/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.SerializationTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.ModList;
import slimeknights.mantle.item.RetexturedBlockItem;
import slimeknights.mantle.recipe.helper.RecipeHelper;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.common.registration.CastItemObject;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.RecipeTypes;
import slimeknights.tconstruct.library.recipe.alloying.AlloyRecipe;
import slimeknights.tconstruct.library.recipe.casting.IDisplayableCastingRecipe;
import slimeknights.tconstruct.library.recipe.entitymelting.EntityMeltingRecipe;
import slimeknights.tconstruct.library.recipe.fuel.MeltingFuel;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipe;
import slimeknights.tconstruct.library.recipe.melting.MeltingRecipe;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IDisplayModifierRecipe;
import slimeknights.tconstruct.library.recipe.modifiers.severing.SeveringRecipe;
import slimeknights.tconstruct.library.recipe.molding.MoldingRecipe;
import slimeknights.tconstruct.library.recipe.partbuilder.IDisplayPartBuilderRecipe;
import slimeknights.tconstruct.library.recipe.partbuilder.Pattern;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.item.IModifiableDisplay;
import slimeknights.tconstruct.library.tools.nbt.MaterialIdNBT;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.plugin.jei.AlloyRecipeCategory;
import slimeknights.tconstruct.plugin.jei.CraftingStationTransferInfo;
import slimeknights.tconstruct.plugin.jei.MoldingRecipeCategory;
import slimeknights.tconstruct.plugin.jei.TConstructRecipeCategoryUid;
import slimeknights.tconstruct.plugin.jei.casting.CastingBasinCategory;
import slimeknights.tconstruct.plugin.jei.casting.CastingTableCategory;
import slimeknights.tconstruct.plugin.jei.entity.DefaultEntityMeltingRecipe;
import slimeknights.tconstruct.plugin.jei.entity.EntityIngredientHelper;
import slimeknights.tconstruct.plugin.jei.entity.EntityIngredientRenderer;
import slimeknights.tconstruct.plugin.jei.entity.EntityMeltingRecipeCategory;
import slimeknights.tconstruct.plugin.jei.entity.SeveringCategory;
import slimeknights.tconstruct.plugin.jei.melting.FoundryCategory;
import slimeknights.tconstruct.plugin.jei.melting.MeltingCategory;
import slimeknights.tconstruct.plugin.jei.melting.MeltingFuelHandler;
import slimeknights.tconstruct.plugin.jei.modifiers.ModifierBookmarkIngredientRenderer;
import slimeknights.tconstruct.plugin.jei.modifiers.ModifierIngredientHelper;
import slimeknights.tconstruct.plugin.jei.modifiers.ModifierRecipeCategory;
import slimeknights.tconstruct.plugin.jei.partbuilder.MaterialItemList;
import slimeknights.tconstruct.plugin.jei.partbuilder.PartBuilderCategory;
import slimeknights.tconstruct.plugin.jei.partbuilder.PatternIngredientHelper;
import slimeknights.tconstruct.plugin.jei.partbuilder.PatternIngredientRenderer;
import slimeknights.tconstruct.plugin.jei.transfer.TinkerStationTransferInfo;
import slimeknights.tconstruct.shared.TinkerMaterials;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.client.screen.HeatingStructureScreen;
import slimeknights.tconstruct.smeltery.client.screen.IScreenWithFluidTank;
import slimeknights.tconstruct.smeltery.client.screen.MelterScreen;
import slimeknights.tconstruct.smeltery.data.SmelteryCompat;
import slimeknights.tconstruct.smeltery.item.CopperCanItem;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.item.ArmorSlotType;
import slimeknights.tconstruct.tools.item.CreativeSlotItem;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public static final IIngredientType<EntityType> ENTITY_TYPE = () -> EntityType.class;
    public static final IIngredientType<ModifierEntry> MODIFIER_TYPE = () -> ModifierEntry.class;
    public static final IIngredientType<Pattern> PATTERN_TYPE = () -> Pattern.class;

    public ResourceLocation getPluginUid() {
        return TConstructRecipeCategoryUid.pluginUid;
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new CastingBasinCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new CastingTableCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new MoldingRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new MeltingCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new AlloyRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new EntityMeltingRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new FoundryCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ModifierRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new SeveringCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new PartBuilderCategory(guiHelper)});
    }

    public void registerIngredients(IModIngredientRegistration registration) {
        assert (Minecraft.m_91087_().f_91073_ != null);
        RecipeManager manager = Minecraft.m_91087_().f_91073_.m_7465_();
        List modifiers = Collections.emptyList();
        if (((Boolean)Config.CLIENT.showModifiersInJEI.get()).booleanValue()) {
            modifiers = RecipeHelper.getJEIRecipes((RecipeManager)manager, RecipeTypes.TINKER_STATION, IDisplayModifierRecipe.class).stream().map(recipe -> recipe.getDisplayResult().getModifier()).distinct().sorted(Comparator.comparing(Modifier::getId)).map(mod -> new ModifierEntry((Modifier)mod, 1)).collect(Collectors.toList());
        }
        registration.register(ENTITY_TYPE, Collections.emptyList(), (IIngredientHelper)new EntityIngredientHelper(), (IIngredientRenderer)new EntityIngredientRenderer(16));
        registration.register(MODIFIER_TYPE, modifiers, (IIngredientHelper)new ModifierIngredientHelper(), (IIngredientRenderer)ModifierBookmarkIngredientRenderer.INSTANCE);
        registration.register(PATTERN_TYPE, Collections.emptyList(), (IIngredientHelper)new PatternIngredientHelper(), (IIngredientRenderer)PatternIngredientRenderer.INSTANCE);
    }

    public void registerRecipes(IRecipeRegistration register) {
        assert (Minecraft.m_91087_().f_91073_ != null);
        RecipeManager manager = Minecraft.m_91087_().f_91073_.m_7465_();
        List castingBasinRecipes = RecipeHelper.getJEIRecipes((RecipeManager)manager, RecipeTypes.CASTING_BASIN, IDisplayableCastingRecipe.class);
        register.addRecipes((Collection)castingBasinRecipes, TConstructRecipeCategoryUid.castingBasin);
        List castingTableRecipes = RecipeHelper.getJEIRecipes((RecipeManager)manager, RecipeTypes.CASTING_TABLE, IDisplayableCastingRecipe.class);
        register.addRecipes((Collection)castingTableRecipes, TConstructRecipeCategoryUid.castingTable);
        List meltingRecipes = RecipeHelper.getJEIRecipes((RecipeManager)manager, RecipeTypes.MELTING, MeltingRecipe.class);
        register.addRecipes((Collection)meltingRecipes, TConstructRecipeCategoryUid.melting);
        register.addRecipes((Collection)meltingRecipes, TConstructRecipeCategoryUid.foundry);
        MeltingFuelHandler.setMeltngFuels(RecipeHelper.getRecipes((RecipeManager)manager, RecipeTypes.FUEL, MeltingFuel.class));
        List entityMeltingRecipes = RecipeHelper.getJEIRecipes((RecipeManager)manager, RecipeTypes.ENTITY_MELTING, EntityMeltingRecipe.class);
        entityMeltingRecipes.add(new DefaultEntityMeltingRecipe(entityMeltingRecipes));
        register.addRecipes((Collection)entityMeltingRecipes, TConstructRecipeCategoryUid.entityMelting);
        List alloyRecipes = RecipeHelper.getJEIRecipes((RecipeManager)manager, RecipeTypes.ALLOYING, AlloyRecipe.class);
        register.addRecipes((Collection)alloyRecipes, TConstructRecipeCategoryUid.alloy);
        ImmutableList moldingRecipes = ImmutableList.builder().addAll((Iterable)RecipeHelper.getJEIRecipes((RecipeManager)manager, RecipeTypes.MOLDING_TABLE, MoldingRecipe.class)).addAll((Iterable)RecipeHelper.getJEIRecipes((RecipeManager)manager, RecipeTypes.MOLDING_BASIN, MoldingRecipe.class)).build();
        register.addRecipes((Collection)moldingRecipes, TConstructRecipeCategoryUid.molding);
        List modifierRecipes = RecipeHelper.getJEIRecipes((RecipeManager)manager, RecipeTypes.TINKER_STATION, IDisplayModifierRecipe.class).stream().sorted((r1, r2) -> {
            SlotType t1 = r1.getSlotType();
            SlotType t2 = r2.getSlotType();
            String n1 = t1 == null ? "zzzzzzzzzz" : t1.getName();
            String n2 = t2 == null ? "zzzzzzzzzz" : t2.getName();
            return n1.compareTo(n2);
        }).collect(Collectors.toList());
        register.addRecipes(modifierRecipes, TConstructRecipeCategoryUid.modifiers);
        List severingRecipes = RecipeHelper.getJEIRecipes((RecipeManager)manager, RecipeTypes.SEVERING, SeveringRecipe.class);
        register.addRecipes((Collection)severingRecipes, TConstructRecipeCategoryUid.severing);
        List materialRecipes = RecipeHelper.getRecipes((RecipeManager)manager, RecipeTypes.MATERIAL, MaterialRecipe.class);
        MaterialItemList.setRecipes(materialRecipes);
        List partRecipes = RecipeHelper.getJEIRecipes((RecipeManager)manager, RecipeTypes.PART_BUILDER, IDisplayPartBuilderRecipe.class);
        register.addRecipes((Collection)partRecipes, TConstructRecipeCategoryUid.partBuilder);
    }

    private static <T extends Recipe<C>, C extends Container> void addCastingCatalyst(IRecipeCatalystRegistration registry, ItemLike item, ResourceLocation ownCategory, RecipeType<T> type) {
        ItemStack stack = new ItemStack(item);
        registry.addRecipeCatalyst(stack, new ResourceLocation[]{ownCategory});
        assert (Minecraft.m_91087_().f_91073_ != null);
        if (!Minecraft.m_91087_().f_91073_.m_7465_().m_44054_(type).isEmpty()) {
            registry.addRecipeCatalyst(stack, new ResourceLocation[]{TConstructRecipeCategoryUid.molding});
        }
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        registry.addRecipeCatalyst(new ItemStack(TinkerTables.partBuilder), new ResourceLocation[]{TConstructRecipeCategoryUid.partBuilder});
        registry.addRecipeCatalyst(new ItemStack(TinkerTables.tinkerStation), new ResourceLocation[]{TConstructRecipeCategoryUid.modifiers});
        registry.addRecipeCatalyst(new ItemStack(TinkerTables.tinkersAnvil), new ResourceLocation[]{TConstructRecipeCategoryUid.modifiers});
        registry.addRecipeCatalyst(new ItemStack(TinkerTables.scorchedAnvil), new ResourceLocation[]{TConstructRecipeCategoryUid.modifiers});
        registry.addRecipeCatalyst(new ItemStack(TinkerSmeltery.searedMelter), new ResourceLocation[]{TConstructRecipeCategoryUid.melting});
        registry.addRecipeCatalyst(new ItemStack(TinkerSmeltery.searedHeater), new ResourceLocation[]{VanillaRecipeCategoryUid.FUEL});
        JEIPlugin.addCastingCatalyst(registry, TinkerSmeltery.searedTable, TConstructRecipeCategoryUid.castingTable, RecipeTypes.MOLDING_TABLE);
        JEIPlugin.addCastingCatalyst(registry, TinkerSmeltery.searedBasin, TConstructRecipeCategoryUid.castingBasin, RecipeTypes.MOLDING_BASIN);
        registry.addRecipeCatalyst(new ItemStack(TinkerSmeltery.smelteryController), new ResourceLocation[]{TConstructRecipeCategoryUid.melting, TConstructRecipeCategoryUid.alloy, TConstructRecipeCategoryUid.entityMelting});
        registry.addRecipeCatalyst(new ItemStack(TinkerSmeltery.scorchedAlloyer), new ResourceLocation[]{TConstructRecipeCategoryUid.alloy});
        JEIPlugin.addCastingCatalyst(registry, TinkerSmeltery.scorchedTable, TConstructRecipeCategoryUid.castingTable, RecipeTypes.MOLDING_TABLE);
        JEIPlugin.addCastingCatalyst(registry, TinkerSmeltery.scorchedBasin, TConstructRecipeCategoryUid.castingBasin, RecipeTypes.MOLDING_BASIN);
        registry.addRecipeCatalyst(new ItemStack(TinkerSmeltery.foundryController), new ResourceLocation[]{TConstructRecipeCategoryUid.foundry});
        for (Item item : TinkerTags.Items.MELEE.m_6497_()) {
            registry.addRecipeCatalyst(IModifiableDisplay.getDisplayStack(item), new ResourceLocation[]{TConstructRecipeCategoryUid.severing});
        }
    }

    public void registerItemSubtypes(ISubtypeRegistration registry) {
        IIngredientSubtypeInterpreter tables = (stack, context) -> {
            if (context == UidContext.Ingredient) {
                return RetexturedBlockItem.getTextureName((ItemStack)stack);
            }
            return "";
        };
        registry.registerSubtypeInterpreter(TinkerTables.craftingStation.m_5456_(), tables);
        registry.registerSubtypeInterpreter(TinkerTables.partBuilder.m_5456_(), tables);
        registry.registerSubtypeInterpreter(TinkerTables.tinkerStation.m_5456_(), tables);
        registry.registerSubtypeInterpreter(TinkerTables.tinkersAnvil.m_5456_(), tables);
        registry.registerSubtypeInterpreter(TinkerTables.scorchedAnvil.m_5456_(), tables);
        IIngredientSubtypeInterpreter toolPartInterpreter = (stack, context) -> {
            MaterialVariantId materialId = IMaterialItem.getMaterialFromStack(stack);
            if (materialId.equals(IMaterial.UNKNOWN_ID)) {
                return "";
            }
            return materialId.getId().toString();
        };
        for (Item item : TinkerTags.Items.TOOL_PARTS.m_6497_()) {
            registry.registerSubtypeInterpreter(item, toolPartInterpreter);
        }
        Item slimeskull = (Item)TinkerTools.slimesuit.get((Enum)ArmorSlotType.HELMET);
        registry.registerSubtypeInterpreter(slimeskull, (IIngredientSubtypeInterpreter)ToolSubtypeInterpreter.ALWAYS);
        for (Item item : TinkerTags.Items.MULTIPART_TOOL.m_6497_()) {
            if (item == slimeskull) continue;
            registry.registerSubtypeInterpreter(item, (IIngredientSubtypeInterpreter)ToolSubtypeInterpreter.INGREDIENT);
        }
        registry.registerSubtypeInterpreter((Item)TinkerSmeltery.copperCan.get(), (stack, context) -> CopperCanItem.getSubtype(stack));
        registry.registerSubtypeInterpreter((Item)TinkerModifiers.creativeSlotItem.get(), (stack, context) -> {
            SlotType slotType = CreativeSlotItem.getSlot(stack);
            return slotType != null ? slotType.getName() : "";
        });
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGenericGuiContainerHandler(MelterScreen.class, new GuiContainerTankHandler());
        registration.addGenericGuiContainerHandler(HeatingStructureScreen.class, new GuiContainerTankHandler());
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler((IRecipeTransferInfo)new CraftingStationTransferInfo());
        registration.addRecipeTransferHandler((IRecipeTransferInfo)new TinkerStationTransferInfo());
    }

    private static void removeFluid(IIngredientManager manager, Fluid fluid, Item bucket) {
        manager.removeIngredientsAtRuntime(VanillaTypes.FLUID, Collections.singleton(new FluidStack(fluid, 1000)));
        manager.removeIngredientsAtRuntime(VanillaTypes.ITEM, Collections.singleton(new ItemStack((ItemLike)bucket)));
    }

    private static void optionalItem(IIngredientManager manager, ItemLike item, String tagName) {
        Tag tag = SerializationTags.m_13199_().m_144452_(Registry.f_122904_).m_13404_(new ResourceLocation("forge", tagName));
        if (tag == null || tag.m_6497_().isEmpty()) {
            manager.removeIngredientsAtRuntime(VanillaTypes.ITEM, Collections.singletonList(new ItemStack(item)));
        }
    }

    private static void optionalCast(IIngredientManager manager, CastItemObject cast) {
        Tag tag = SerializationTags.m_13199_().m_144452_(Registry.f_122904_).m_13404_(new ResourceLocation("forge", cast.getName().m_135815_() + "s"));
        if (tag == null || tag.m_6497_().isEmpty()) {
            manager.removeIngredientsAtRuntime(VanillaTypes.ITEM, (Collection)cast.values().stream().map(ItemStack::new).collect(Collectors.toList()));
        }
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        IIngredientManager manager = jeiRuntime.getIngredientManager();
        JEIPlugin.removeFluid(manager, (Fluid)TinkerFluids.moltenSoulsteel.get(), TinkerFluids.moltenSoulsteel.m_5456_());
        JEIPlugin.removeFluid(manager, (Fluid)TinkerFluids.moltenKnightslime.get(), TinkerFluids.moltenKnightslime.m_5456_());
        for (SmelteryCompat compat : SmelteryCompat.values()) {
            Tag ingot = SerializationTags.m_13199_().m_144452_(Registry.f_122904_).m_13404_(new ResourceLocation("forge", "ingots/" + compat.getName()));
            if (ingot != null && !ingot.m_6497_().isEmpty()) continue;
            JEIPlugin.removeFluid(manager, (Fluid)compat.getFluid().get(), compat.getBucket());
        }
        if (!ModList.get().isLoaded("ceramics")) {
            JEIPlugin.removeFluid(manager, (Fluid)TinkerFluids.moltenPorcelain.get(), TinkerFluids.moltenPorcelain.m_5456_());
        }
        JEIPlugin.optionalCast(manager, TinkerSmeltery.plateCast);
        JEIPlugin.optionalCast(manager, TinkerSmeltery.gearCast);
        JEIPlugin.optionalCast(manager, TinkerSmeltery.coinCast);
        JEIPlugin.optionalCast(manager, TinkerSmeltery.wireCast);
        JEIPlugin.optionalItem(manager, TinkerMaterials.necroniumBone, "ingots/uranium");
    }

    public static enum ToolSubtypeInterpreter implements IIngredientSubtypeInterpreter<ItemStack>
    {
        ALWAYS,
        INGREDIENT;


        public String apply(ItemStack itemStack, UidContext context) {
            if (this == ALWAYS || context == UidContext.Ingredient) {
                StringBuilder builder = new StringBuilder();
                List<MaterialVariantId> materialList = MaterialIdNBT.from(itemStack).getMaterials();
                if (!materialList.isEmpty()) {
                    builder.append(materialList.get(0));
                    for (int i = 1; i < materialList.size(); ++i) {
                        builder.append(',');
                        builder.append(materialList.get(i).getId());
                    }
                }
                return builder.toString();
            }
            return "";
        }
    }

    public static class GuiContainerTankHandler<C extends AbstractContainerMenu, T extends AbstractContainerScreen<C>>
    implements IGuiContainerHandler<T> {
        @Nullable
        public Object getIngredientUnderMouse(T containerScreen, double mouseX, double mouseY) {
            return ((IScreenWithFluidTank)containerScreen).getIngredientUnderMouse(mouseX, mouseY);
        }
    }

    public static class RetexturedSubtypeInterpreter
    implements IIngredientSubtypeInterpreter<ItemStack> {
        public String apply(ItemStack itemStack, UidContext context) {
            if (context == UidContext.Ingredient) {
                return RetexturedBlockItem.getTextureName((ItemStack)itemStack);
            }
            return "";
        }
    }
}

