/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei.entity;

import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.IFocus;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import slimeknights.tconstruct.plugin.jei.JEIPlugin;

public class EntityIngredientHelper
implements IIngredientHelper<EntityType> {
    public IIngredientType<EntityType> getIngredientType() {
        return JEIPlugin.ENTITY_TYPE;
    }

    @Nullable
    public EntityType getMatch(Iterable<EntityType> iterable, EntityType type, UidContext context) {
        for (EntityType match : iterable) {
            if (match != type) continue;
            return match;
        }
        return null;
    }

    public String getDisplayName(EntityType type) {
        return type.m_20676_().getString();
    }

    public String getUniqueId(EntityType type, UidContext context) {
        return Objects.requireNonNull(type.getRegistryName()).toString();
    }

    public String getModId(EntityType type) {
        return Objects.requireNonNull(type.getRegistryName()).m_135827_();
    }

    public String getResourceId(EntityType type) {
        return Objects.requireNonNull(type.getRegistryName()).m_135815_();
    }

    public EntityType copyIngredient(EntityType type) {
        return type;
    }

    public String getErrorInfo(@Nullable EntityType type) {
        if (type == null) {
            return "null";
        }
        ResourceLocation name = type.getRegistryName();
        if (name == null) {
            return "unnamed sadface :(";
        }
        return name.toString();
    }

    public static void setFocus(IRecipeLayout layout, IGuiIngredientGroup<EntityType> group, Collection<EntityType<?>> entities, int index) {
        IFocus focus = layout.getFocus(VanillaTypes.ITEM);
        if (focus != null && ((ItemStack)focus.getValue()).m_41720_() instanceof SpawnEggItem) {
            EntityType type = ((SpawnEggItem)((ItemStack)focus.getValue()).m_41720_()).m_43228_(null);
            group.set(index, entities.stream().filter(type::equals).collect(Collectors.toList()));
        }
    }
}

