/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.command.argument;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.resources.ResourceLocation;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;

public class MaterialArgument
implements ArgumentType<IMaterial> {
    private static final Collection<String> EXAMPLES = Arrays.asList("tconstruct:wood", "tconstruct:iron");
    private static final DynamicCommandExceptionType NOT_FOUND = new DynamicCommandExceptionType(name -> TConstruct.makeTranslation("command", "material.not_found", name));

    public static IMaterial getMaterial(CommandContext<CommandSourceStack> context, String name) {
        return (IMaterial)context.getArgument(name, IMaterial.class);
    }

    public IMaterial parse(StringReader reader) throws CommandSyntaxException {
        MaterialId name = new MaterialId(ResourceLocation.m_135818_((StringReader)reader));
        IMaterial material = MaterialRegistry.getMaterial(name);
        if (material == IMaterial.UNKNOWN) {
            throw NOT_FOUND.createWithContext((ImmutableStringReader)reader, (Object)name);
        }
        return material;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.m_82926_(MaterialRegistry.getMaterials().stream().map(IMaterial::getIdentifier)::iterator, (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    private MaterialArgument() {
    }

    public static MaterialArgument material() {
        return new MaterialArgument();
    }
}

