/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity.module;

import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.mantle.block.entity.MantleBlockEntity;
import slimeknights.tconstruct.common.network.InventorySlotSyncPacket;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.library.recipe.RecipeTypes;
import slimeknights.tconstruct.library.recipe.melting.IMeltingContainer;
import slimeknights.tconstruct.library.recipe.melting.IMeltingRecipe;

public class MeltingModule
implements IMeltingContainer,
ContainerData {
    public static final int NO_SPACE = -1;
    private static final String TAG_CURRENT_TIME = "time";
    private static final String TAG_REQUIRED_TIME = "required";
    private static final String TAG_REQUIRED_TEMP = "temp";
    private static final int CURRENT_TIME = 0;
    private static final int REQUIRED_TIME = 1;
    private static final int REQUIRED_TEMP = 2;
    private final MantleBlockEntity parent;
    private final Predicate<IMeltingRecipe> outputFunction;
    private final IMeltingContainer.IOreRate oreRate;
    private final int slotIndex;
    private int currentTime = 0;
    private int requiredTime = 0;
    private int requiredTemp = 0;
    private IMeltingRecipe lastRecipe;
    private ItemStack stack = ItemStack.f_41583_;

    @Override
    public IMeltingContainer.IOreRate getOreRate() {
        return this.oreRate;
    }

    private void resetRecipe() {
        this.currentTime = 0;
        this.requiredTime = 0;
        this.requiredTemp = 0;
    }

    public void setStack(ItemStack newStack) {
        IMeltingRecipe recipe;
        Level world = this.parent.m_58904_();
        if (this.slotIndex != -1 && world != null && !world.f_46443_ && !ItemStack.m_41728_((ItemStack)this.stack, (ItemStack)newStack)) {
            TinkerNetwork.getInstance().sendToClientsAround(new InventorySlotSyncPacket(newStack, this.slotIndex, this.parent.m_58899_()), (LevelAccessor)world, this.parent.m_58899_());
        }
        if (newStack.m_41619_()) {
            this.resetRecipe();
        } else if (this.stack.m_41619_() || !ItemHandlerHelper.canItemStacksStack((ItemStack)this.stack, (ItemStack)newStack)) {
            this.currentTime = 0;
        }
        this.stack = newStack;
        int newTime = 0;
        int newTemp = 0;
        if (!this.stack.m_41619_() && (recipe = this.findRecipe()) != null) {
            newTime = recipe.getTime(this) * 10;
            newTemp = recipe.getTemperature(this);
        }
        this.requiredTime = newTime;
        this.requiredTemp = newTemp;
        this.parent.setChangedFast();
    }

    public boolean canHeatItem(int temperature) {
        if (this.requiredTime > 0) {
            if (this.stack.m_41619_()) {
                this.resetRecipe();
                return false;
            }
            return this.currentTime != -1 && temperature >= this.requiredTemp;
        }
        return false;
    }

    public void heatItem(int temperature) {
        if (this.currentTime == -1 || this.canHeatItem(temperature)) {
            if (this.currentTime == -1 || this.currentTime >= this.requiredTime) {
                if (this.onItemFinishedHeating()) {
                    this.resetRecipe();
                }
            } else {
                this.currentTime += temperature / 100;
            }
        }
    }

    public void coolItem() {
        if (this.currentTime == -1) {
            if (this.onItemFinishedHeating()) {
                this.resetRecipe();
            }
        } else if (this.currentTime > 0 && this.requiredTime > 0) {
            this.currentTime -= 5;
        }
    }

    @Nullable
    private IMeltingRecipe findRecipe() {
        Level world = this.parent.m_58904_();
        if (world == null) {
            return null;
        }
        IMeltingRecipe last = this.lastRecipe;
        if (last != null && last.m_5818_((Container)this, world)) {
            return last;
        }
        Optional newRecipe = world.m_7465_().m_44015_(RecipeTypes.MELTING, (Container)this, world);
        if (newRecipe.isPresent()) {
            this.lastRecipe = (IMeltingRecipe)newRecipe.get();
            return this.lastRecipe;
        }
        return null;
    }

    private boolean onItemFinishedHeating() {
        IMeltingRecipe recipe = this.findRecipe();
        if (recipe == null) {
            return true;
        }
        if (this.outputFunction.test(recipe)) {
            this.setStack(ItemStack.f_41583_);
            return true;
        }
        this.currentTime = -1;
        return false;
    }

    public CompoundTag writeToTag() {
        CompoundTag nbt = new CompoundTag();
        if (!this.stack.m_41619_()) {
            this.stack.m_41739_(nbt);
            nbt.m_128405_(TAG_CURRENT_TIME, this.currentTime);
            nbt.m_128405_(TAG_REQUIRED_TIME, this.requiredTime);
            nbt.m_128405_(TAG_REQUIRED_TEMP, this.requiredTemp);
        }
        return nbt;
    }

    public void readFromTag(CompoundTag nbt) {
        this.stack = ItemStack.m_41712_((CompoundTag)nbt);
        if (!this.stack.m_41619_()) {
            this.currentTime = nbt.m_128451_(TAG_CURRENT_TIME);
            this.requiredTime = nbt.m_128451_(TAG_REQUIRED_TIME);
            this.requiredTemp = nbt.m_128451_(TAG_REQUIRED_TEMP);
        }
    }

    public int m_6499_() {
        return 3;
    }

    public int m_6413_(int index) {
        return switch (index) {
            case 0 -> this.currentTime;
            case 1 -> this.requiredTime;
            case 2 -> this.requiredTemp;
            default -> 0;
        };
    }

    public void m_8050_(int index, int value) {
        switch (index) {
            case 0: {
                this.currentTime = value;
                break;
            }
            case 1: {
                this.requiredTime = value;
                break;
            }
            case 2: {
                this.requiredTemp = value;
            }
        }
    }

    public MeltingModule(MantleBlockEntity parent, Predicate<IMeltingRecipe> outputFunction, IMeltingContainer.IOreRate oreRate, int slotIndex) {
        this.parent = parent;
        this.outputFunction = outputFunction;
        this.oreRate = oreRate;
        this.slotIndex = slotIndex;
    }

    public int getCurrentTime() {
        return this.currentTime;
    }

    public int getRequiredTime() {
        return this.requiredTime;
    }

    public int getRequiredTemp() {
        return this.requiredTemp;
    }

    public ItemStack getStack() {
        return this.stack;
    }
}

