/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity.tank;

import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import slimeknights.tconstruct.smeltery.block.entity.ChannelBlockEntity;

public class ChannelTank
extends FluidTank {
    private static final String TAG_LOCKED = "locked";
    private int locked;
    private final ChannelBlockEntity parent;

    public ChannelTank(int capacity, ChannelBlockEntity parent) {
        super(capacity, fluid -> !fluid.getFluid().getAttributes().isGaseous(fluid));
        this.parent = parent;
    }

    public void freeFluid() {
        this.locked = 0;
    }

    public int getMaxUsable() {
        return Math.max(this.fluid.getAmount() - this.locked, 0);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        boolean wasEmpty = this.isEmpty();
        int amount = super.fill(resource, action);
        if (action.execute()) {
            this.locked += amount;
            if (wasEmpty && !this.isEmpty()) {
                this.parent.sendFluidUpdate();
            }
        }
        return amount;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        boolean wasEmpty = this.isEmpty();
        FluidStack stack = super.drain(maxDrain, action);
        if (action.execute() && !wasEmpty && this.isEmpty()) {
            this.parent.sendFluidUpdate();
        }
        return stack;
    }

    public FluidTank readFromNBT(CompoundTag nbt) {
        this.locked = nbt.m_128451_(TAG_LOCKED);
        super.readFromNBT(nbt);
        return this;
    }

    public CompoundTag writeToNBT(CompoundTag nbt) {
        nbt = super.writeToNBT(nbt);
        nbt.m_128405_(TAG_LOCKED, this.locked);
        return nbt;
    }
}

