/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.client.inventory.module;

import java.util.List;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import slimeknights.tconstruct.library.client.Icons;
import slimeknights.tconstruct.library.tools.layout.StationSlotLayout;
import slimeknights.tconstruct.library.tools.layout.StationSlotLayoutLoader;
import slimeknights.tconstruct.tables.client.inventory.TinkerStationScreen;
import slimeknights.tconstruct.tables.client.inventory.module.SideButtonsScreen;
import slimeknights.tconstruct.tables.client.inventory.widget.SlotButtonItem;

public class TinkerStationButtonsScreen
extends SideButtonsScreen {
    protected final TinkerStationScreen parent;
    protected int selected = 0;
    private int style = 0;
    private final Button.OnPress ON_BUTTON_PRESSED = self -> {
        for (Widget widget : this.f_169369_) {
            if (!(widget instanceof SlotButtonItem)) continue;
            ((SlotButtonItem)widget).pressed = false;
        }
        if (self instanceof SlotButtonItem) {
            SlotButtonItem slotInformationButton = (SlotButtonItem)self;
            slotInformationButton.pressed = true;
            this.selected = slotInformationButton.buttonId;
            this.parent.onToolSelection(slotInformationButton.getLayout());
        }
    };
    public static final int WOOD_STYLE = 2;
    public static final int METAL_STYLE = 1;

    public TinkerStationButtonsScreen(TinkerStationScreen parent, AbstractContainerMenu container, Inventory playerInventory, Component title) {
        super(parent, container, playerInventory, title, 5, false);
        this.parent = parent;
    }

    public void updatePosition(int parentX, int parentY, int parentSizeX, int parentSizeY) {
        super.updatePosition(parentX, parentY, parentSizeX, parentSizeY);
        this.buttonCount = 0;
        SlotButtonItem slotButtonItem = new SlotButtonItem(0, -1, -1, this.parent.getDefaultLayout(), this.ON_BUTTON_PRESSED);
        this.addInfoButton(slotButtonItem);
        if (0 == this.selected) {
            slotButtonItem.pressed = true;
        }
        int index = 1;
        for (StationSlotLayout layout : StationSlotLayoutLoader.getInstance().getSortedSlots()) {
            if (layout.getInputSlots().size() > this.parent.getMaxInputs()) continue;
            slotButtonItem = new SlotButtonItem(index, -1, -1, layout, this.ON_BUTTON_PRESSED);
            this.addInfoButton(slotButtonItem);
            if (index == this.selected) {
                slotButtonItem.pressed = true;
            }
            ++index;
        }
        super.updatePosition(parentX, parentY, parentSizeX, parentSizeY);
    }

    public void addInfoButton(SlotButtonItem slotButtonItem) {
        this.shiftButton(slotButtonItem, 0, -18 * this.style);
        this.addSideButton(slotButtonItem);
    }

    public void shiftStyle(int style) {
        for (Widget widget : this.f_169369_) {
            if (!(widget instanceof SlotButtonItem)) continue;
            this.shiftButton((SlotButtonItem)widget, 0, -18);
        }
        this.style = style;
    }

    protected void shiftButton(SlotButtonItem button, int xd, int yd) {
        button.setGraphics(Icons.BUTTON.shift(xd, yd), Icons.BUTTON_HOVERED.shift(xd, yd), Icons.BUTTON_PRESSED.shift(xd, yd), Icons.ICONS);
    }

    public List<Widget> getButtons() {
        return this.f_169369_;
    }
}

