/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.recipe;

import com.mojang.datafixers.util.Pair;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipe;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tables.recipe.TinkerStationRepairRecipe;
import slimeknights.tconstruct.tools.TinkerToolParts;

public class CraftingTableRepairKitRecipe
extends CustomRecipe {
    public CraftingTableRepairKitRecipe(ResourceLocation id) {
        super(id);
    }

    protected boolean toolMatches(ItemStack stack) {
        Item item = stack.m_41720_();
        return TinkerTags.Items.MULTIPART_TOOL.m_8110_((Object)item) && TinkerTags.Items.DURABILITY.m_8110_((Object)item);
    }

    @Nullable
    protected Pair<ToolStack, MaterialId> getRelevantInputs(CraftingContainer inv) {
        ToolStack tool = null;
        MaterialId material = null;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() == TinkerToolParts.repairKit.get()) {
                if (material != null) {
                    return null;
                }
                MaterialId inputMaterial = IMaterialItem.getMaterialFromStack(stack).getId();
                if (inputMaterial.equals(IMaterial.UNKNOWN_ID)) {
                    return null;
                }
                material = inputMaterial;
                continue;
            }
            if (this.toolMatches(stack)) {
                if (tool != null) {
                    return null;
                }
                tool = ToolStack.from(stack);
                if (tool.isBroken() || tool.getDamage() != 0) continue;
                return null;
            }
            return null;
        }
        if (tool == null || material == null) {
            return null;
        }
        return Pair.of(tool, material);
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        Pair<ToolStack, MaterialId> inputs = this.getRelevantInputs(inv);
        return inputs != null && TinkerStationRepairRecipe.getRepairIndex((IToolStackView)inputs.getFirst(), (MaterialId)inputs.getSecond()) >= 0;
    }

    protected float getRepairAmount(IToolStackView tool, MaterialId repairMaterial) {
        MaterialStatsId repairStats = TinkerStationRepairRecipe.getDefaultStatsId(tool, repairMaterial);
        float repairAmount = (float)(MaterialRecipe.getRepairDurability(tool.getDefinition().getData(), repairMaterial, repairStats) * 2) / 3.0f;
        if (repairAmount > 0.0f) {
            repairAmount *= TinkerStationRepairRecipe.getRepairWeight(tool, repairMaterial);
        }
        return repairAmount;
    }

    public ItemStack assemble(CraftingContainer inv) {
        Pair<ToolStack, MaterialId> inputs = this.getRelevantInputs(inv);
        if (inputs == null) {
            TConstruct.LOG.error("Recipe repair on {} failed to find items after matching", (Object)this.m_6423_());
            return ItemStack.f_41583_;
        }
        ToolStack tool = ((ToolStack)inputs.getFirst()).copy();
        float repairAmount = this.getRepairAmount(tool, (MaterialId)inputs.getSecond());
        if (repairAmount > 0.0f) {
            for (ModifierEntry entry : tool.getModifierList()) {
                repairAmount = entry.getModifier().getRepairFactor(tool, entry.getLevel(), repairAmount);
                if (!(repairAmount <= 0.0f)) continue;
                return tool.createStack();
            }
            ToolDamageUtil.repair(tool, (int)repairAmount);
        }
        return tool.createStack();
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerTables.craftingTableRepairSerializer.get();
    }
}

