/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.FOVModifierEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.client.gui.IIngameOverlay;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.client.Icons;
import slimeknights.tconstruct.library.events.ToolEquipmentChangeEvent;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.data.FloatMultiplier;
import slimeknights.tconstruct.library.modifiers.impl.InventoryModifier;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.capability.TinkerDataKeys;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.item.IModifiableDisplay;
import slimeknights.tconstruct.library.tools.nbt.IModDataView;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.utils.Orientation2D;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.modifiers.ability.armor.ShieldStrapModifier;
import slimeknights.tconstruct.tools.modifiers.upgrades.armor.ItemFrameModifier;

@Mod.EventBusSubscriber(modid="tconstruct", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ModifierClientEvents {
    private static final int SLOT_BACKGROUND_SIZE = 22;
    @Nonnull
    private static ItemStack nextOffhand = ItemStack.f_41583_;
    private static final List<ItemStack> itemFrames = new ArrayList<ItemStack>();

    @SubscribeEvent
    static void onTooltipEvent(ItemTooltipEvent event) {
        if (event.getItemStack().m_41720_() instanceof IModifiableDisplay) {
            event.getToolTip().removeIf(text -> {
                if (text instanceof TranslatableComponent) {
                    return ((TranslatableComponent)text).m_131328_().equals("item.durability");
                }
                return false;
            });
        }
    }

    @SubscribeEvent
    static void renderHand(RenderHandEvent event) {
        InteractionHand hand = event.getHand();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (hand != InteractionHand.OFF_HAND || player == null) {
            return;
        }
        ItemStack mainhand = player.m_21205_();
        ItemStack offhand = event.getItemStack();
        if (mainhand.m_150922_(TinkerTags.Items.TWO_HANDED)) {
            ToolStack tool = ToolStack.from(mainhand);
            IModDataView volatileData = tool.getVolatileData();
            boolean noInteraction = volatileData.getBoolean(IModifiable.NO_INTERACTION);
            if (!(noInteraction || volatileData.getBoolean(IModifiable.DEFER_OFFHAND) || offhand.m_41720_() instanceof BlockItem && tool.getModifierLevel((Modifier)TinkerModifiers.exchanging.get()) != 0)) {
                event.setCanceled(true);
                return;
            }
            if (!noInteraction && offhand.m_41619_()) {
                return;
            }
        }
        if (offhand.m_41619_()) {
            if (!player.m_20145_() && mainhand.m_41720_() != Items.f_42573_ && ModifierUtil.getTotalModifierLevel((LivingEntity)player, TinkerDataKeys.SHOW_EMPTY_OFFHAND) > 0) {
                PoseStack matrices = event.getPoseStack();
                matrices.m_85836_();
                Minecraft.m_91087_().m_91292_().m_109346_(matrices, event.getMultiBufferSource(), event.getPackedLight(), event.getEquipProgress(), event.getSwingProgress(), player.m_5737_().m_20828_());
                matrices.m_85849_();
                event.setCanceled(true);
            }
        } else if (offhand.m_150922_(TinkerTags.Items.TWO_HANDED) && !ModifierUtil.checkVolatileFlag(offhand, IModifiable.DEFER_OFFHAND)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    static void handleZoom(FOVModifierEvent event) {
        event.getEntity().getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> {
            FloatMultiplier zoom = data.get(TinkerDataKeys.FOV_MODIFIER);
            if (zoom != null) {
                event.setNewfov(event.getNewfov() * zoom.getValue());
            }
        });
    }

    @SubscribeEvent
    static void equipmentChange(ToolEquipmentChangeEvent event) {
        InventoryModifier modifier;
        int level;
        IToolStackView tool;
        EquipmentChangeContext context = event.getContext();
        if (((Boolean)Config.CLIENT.renderShieldSlotItem.get()).booleanValue() && event.getEntityLiving() == Minecraft.m_91087_().f_91074_ && context.getChangedSlot() == EquipmentSlot.LEGS) {
            tool = context.getToolInSlot(EquipmentSlot.LEGS);
            if (tool != null && (level = tool.getModifierLevel(modifier = (ShieldStrapModifier)TinkerModifiers.shieldStrap.get())) > 0) {
                nextOffhand = modifier.getStack(tool, level, 0);
                return;
            }
            nextOffhand = ItemStack.f_41583_;
        }
        if (((Boolean)Config.CLIENT.renderItemFrame.get()).booleanValue() && event.getEntityLiving() == Minecraft.m_91087_().f_91074_ && context.getChangedSlot() == EquipmentSlot.HEAD) {
            itemFrames.clear();
            tool = context.getToolInSlot(EquipmentSlot.HEAD);
            if (tool != null && (level = tool.getModifierLevel(modifier = (ItemFrameModifier)TinkerModifiers.itemFrame.get())) > 0) {
                ((ItemFrameModifier)modifier).getAllStacks(tool, level, itemFrames);
            }
        }
    }

    @SubscribeEvent
    static void renderHotbar(RenderGameOverlayEvent.PostLayer event) {
        LocalPlayer player;
        boolean renderItemFrame;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91066_.f_92062_) {
            return;
        }
        IIngameOverlay overlay = event.getOverlay();
        if (overlay != ForgeIngameGui.HOTBAR_ELEMENT) {
            return;
        }
        boolean renderShield = (Boolean)Config.CLIENT.renderShieldSlotItem.get() != false && !nextOffhand.m_41619_();
        boolean bl = renderItemFrame = (Boolean)Config.CLIENT.renderItemFrame.get() != false && !itemFrames.isEmpty();
        if (!renderItemFrame && !renderShield) {
            return;
        }
        MultiPlayerGameMode playerController = Minecraft.m_91087_().f_91072_;
        if (playerController != null && playerController.m_105295_() != GameType.SPECTATOR && (player = Minecraft.m_91087_().f_91074_) != null && player == mc.m_91288_()) {
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            int scaledWidth = mc.m_91268_().m_85445_();
            int scaledHeight = mc.m_91268_().m_85446_();
            PoseStack matrixStack = event.getMatrixStack();
            float partialTicks = event.getPartialTicks();
            if (renderShield) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)Icons.ICONS);
                int x = scaledWidth / 2 + (player.m_5737_().m_20828_() == HumanoidArm.LEFT ? -117 : 101);
                int y = scaledHeight - 38;
                Screen.m_93133_((PoseStack)matrixStack, (int)(x - 3), (int)(y - 3), (float)(player.m_21206_().m_41619_() ? 211.0f : 189.0f), (float)0.0f, (int)22, (int)22, (int)256, (int)256);
                mc.f_91065_.m_168677_(x, y, partialTicks, (Player)player, nextOffhand, 11);
            }
            if (renderItemFrame) {
                int c;
                int columns = (Integer)Config.CLIENT.itemsPerRow.get();
                int count = itemFrames.size();
                int rows = count / columns;
                int inLastRow = count % columns;
                if (inLastRow == 0) {
                    inLastRow = columns;
                } else {
                    ++rows;
                }
                Orientation2D location = (Orientation2D)((Object)Config.CLIENT.itemFrameLocation.get());
                Orientation2D.Orientation1D xOrientation = location.getX();
                Orientation2D.Orientation1D yOrientation = location.getY();
                int xStart = xOrientation.align(scaledWidth - 22 * columns) + (Integer)Config.CLIENT.itemFrameXOffset.get();
                int yStart = yOrientation.align(scaledHeight - 22 * rows) + (Integer)Config.CLIENT.itemFrameYOffset.get();
                RenderSystem.m_157456_((int)0, (ResourceLocation)Icons.ICONS);
                int lastRow = rows - 1;
                for (int r = 0; r < lastRow; ++r) {
                    for (c = 0; c < columns; ++c) {
                        Screen.m_93133_((PoseStack)matrixStack, (int)(xStart + c * 22), (int)(yStart + r * 22), (float)167.0f, (float)0.0f, (int)22, (int)22, (int)256, (int)256);
                    }
                }
                int lastRowOffset = xOrientation.align((columns - inLastRow) * 2) * 22 / 2;
                for (c = 0; c < inLastRow; ++c) {
                    Screen.m_93133_((PoseStack)matrixStack, (int)(xStart + c * 22 + lastRowOffset), (int)(yStart + lastRow * 22), (float)167.0f, (float)0.0f, (int)22, (int)22, (int)256, (int)256);
                }
                int i = 0;
                xStart += 3;
                yStart += 3;
                for (int r = 0; r < lastRow; ++r) {
                    for (int c2 = 0; c2 < columns; ++c2) {
                        mc.f_91065_.m_168677_(xStart + c2 * 22, yStart + r * 22, partialTicks, (Player)player, itemFrames.get(i), i);
                        ++i;
                    }
                }
                for (int c3 = 0; c3 < inLastRow; ++c3) {
                    mc.f_91065_.m_168677_(xStart + c3 * 22 + lastRowOffset, yStart + lastRow * 22, partialTicks, (Player)player, itemFrames.get(i), i);
                    ++i;
                }
            }
            RenderSystem.m_69461_();
        }
    }
}

