/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import slimeknights.mantle.data.ISafeManagerReloadListener;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.client.ArmorModelHelper;
import slimeknights.tconstruct.tools.data.material.MaterialIds;

public class PlateArmorModel
extends Model {
    private static final PlateArmorModel INSTANCE = new PlateArmorModel();
    private static final Map<String, RenderType> ARMOR_RENDER_CACHE = new HashMap<String, RenderType>();
    private static final Map<String, RenderType> LEG_RENDER_CACHE = new HashMap<String, RenderType>();
    private static final Function<String, RenderType> ARMOR_GETTER = mat -> RenderType.m_110464_((ResourceLocation)PlateArmorModel.getArmorTexture(mat, 1));
    private static final Function<String, RenderType> LEG_GETTER = mat -> RenderType.m_110464_((ResourceLocation)PlateArmorModel.getArmorTexture(mat, 2));
    public static final ISafeManagerReloadListener RELOAD_LISTENER = manager -> {
        ARMOR_RENDER_CACHE.clear();
        LEG_RENDER_CACHE.clear();
    };
    @Nullable
    private HumanoidModel<?> base;
    private String material = "";
    private boolean isLegs = false;
    private boolean hasGlint = false;

    private static ResourceLocation getArmorTexture(String material, int variant) {
        MaterialVariantId variantId = MaterialVariantId.tryParse(material);
        if (variantId == null) {
            variantId = MaterialIds.cobalt;
        }
        ResourceLocation location = variantId.getLocation('_');
        return TConstruct.getResource(String.format("textures/models/armor/plate/layer_%d_%s_%s.png", variant, location.m_135827_(), location.m_135815_()));
    }

    public static Model getModel(ItemStack stack, EquipmentSlot slot, HumanoidModel<?> baseModel) {
        INSTANCE.setup(baseModel, stack, slot);
        return INSTANCE;
    }

    public PlateArmorModel() {
        super(RenderType::m_110458_);
    }

    public void m_7695_(PoseStack matrices, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (this.base != null) {
            this.base.m_7695_(matrices, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            if (!this.material.isEmpty() && ArmorModelHelper.buffer != null) {
                VertexConsumer overlayBuffer = ItemRenderer.m_115184_((MultiBufferSource)ArmorModelHelper.buffer, (RenderType)(this.isLegs ? LEG_RENDER_CACHE.computeIfAbsent(this.material, LEG_GETTER) : ARMOR_RENDER_CACHE.computeIfAbsent(this.material, ARMOR_GETTER)), (boolean)false, (boolean)this.hasGlint);
                this.base.m_7695_(matrices, overlayBuffer, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            }
        }
    }

    private void setup(HumanoidModel<?> base, ItemStack stack, EquipmentSlot slot) {
        this.base = base;
        this.material = ModifierUtil.getModifierLevel(stack, (Modifier)TinkerModifiers.golden.get()) > 0 ? MaterialIds.gold.toString() : ModifierUtil.getPersistentString(stack, TinkerModifiers.embellishment.getId());
        this.isLegs = slot == EquipmentSlot.LEGS;
        this.hasGlint = stack.m_41790_();
    }
}

