/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.ability.interaction;

import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.ToolAction;
import slimeknights.tconstruct.library.modifiers.impl.InteractionModifier;
import slimeknights.tconstruct.library.tools.definition.aoe.IAreaOfEffectIterator;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.MutableUseOnContext;

public class BlockTransformModifier
extends InteractionModifier.SingleUse {
    private final int priority;
    private final ToolAction action;
    private final SoundEvent sound;
    private final boolean requireGround;
    private final int eventId;

    public BlockTransformModifier(int priority, ToolAction action, SoundEvent sound, boolean requireGround) {
        this(priority, action, sound, requireGround, -1);
    }

    @Override
    public boolean shouldDisplay(boolean advanced) {
        return this.priority > Short.MIN_VALUE;
    }

    @Override
    public boolean canPerformAction(IToolStackView tool, int level, ToolAction toolAction) {
        return this.action == toolAction;
    }

    @Override
    public InteractionResult afterBlockUse(IToolStackView tool, int level, UseOnContext context, EquipmentSlot slotType) {
        if (tool.isBroken()) {
            return InteractionResult.PASS;
        }
        Player player = context.m_43723_();
        if (player != null && player.m_6144_()) {
            return InteractionResult.PASS;
        }
        if (this.requireGround && context.m_43719_() == Direction.DOWN) {
            return InteractionResult.PASS;
        }
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState original = world.m_8055_(pos);
        ItemStack stack = context.m_43722_();
        boolean didTransform = this.transform(context, original, true);
        if (didTransform) {
            if (world.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            if (ToolDamageUtil.damage(tool, 1, (LivingEntity)player, stack)) {
                if (player != null) {
                    player.m_21166_(slotType);
                }
                return InteractionResult.CONSUME;
            }
        }
        if (player != null && !tool.isBroken()) {
            int totalTransformed = 0;
            Iterator<BlockPos> aoePos = tool.getDefinition().getData().getAOE().getBlocks(tool, stack, player, original, world, pos, context.m_43719_(), IAreaOfEffectIterator.AOEMatchType.TRANSFORM).iterator();
            if (aoePos.hasNext()) {
                MutableUseOnContext offsetContext = new MutableUseOnContext(context);
                do {
                    BlockPos newPos;
                    if (pos.equals((Object)(newPos = aoePos.next()))) continue;
                    offsetContext.setOffsetPos(newPos);
                    BlockState newTarget = world.m_8055_(newPos);
                    if (!this.transform(offsetContext, newTarget, totalTransformed < 40)) continue;
                    ++totalTransformed;
                    didTransform = true;
                    if (world.f_46443_ || ToolDamageUtil.damageAnimated(tool, 1, (LivingEntity)player, slotType)) break;
                } while (aoePos.hasNext());
                if (totalTransformed > 0) {
                    player.m_36346_();
                }
            }
        }
        return didTransform ? InteractionResult.m_19078_((boolean)world.f_46443_) : InteractionResult.PASS;
    }

    protected boolean transform(UseOnContext context, BlockState original, boolean playSound) {
        Material material;
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockPos above = pos.m_7494_();
        if (this.requireGround && !(material = level.m_8055_(above).m_60767_()).m_76336_() && material != Material.f_76300_) {
            return false;
        }
        Player player = context.m_43723_();
        BlockState transformed = original.getToolModifiedState(level, pos, player, context.m_43722_(), this.action);
        if (transformed != null) {
            if (playSound) {
                level.m_5594_(player, pos, this.sound, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (this.eventId != -1) {
                    level.m_5898_(player, this.eventId, pos, 0);
                }
            }
            if (!level.f_46443_) {
                level.m_7731_(pos, transformed, 11);
                if (this.requireGround) {
                    level.m_46961_(above, true);
                }
            }
            return true;
        }
        return false;
    }

    public BlockTransformModifier(int priority, ToolAction action, SoundEvent sound, boolean requireGround, int eventId) {
        this.priority = priority;
        this.action = action;
        this.sound = sound;
        this.requireGround = requireGround;
        this.eventId = eventId;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }
}

