/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.harvest;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.TooltipKey;

public class DwarvenModifier
extends Modifier {
    private static final Component MINING_SPEED = TConstruct.makeTranslation("modifier", "dwarven.mining_speed");
    private static final int SEA_LEVEL = 64;
    private static final float BOOST_AT_0 = 0.1f;

    private static float getBoost(int y, int level) {
        return (float)((64 - y) * level) * 0.0015625f;
    }

    @Override
    public void onBreakSpeed(IToolStackView tool, int level, PlayerEvent.BreakSpeed event, Direction sideHit, boolean isEffective, float miningSpeedModifier) {
        if (!isEffective) {
            return;
        }
        float factor = DwarvenModifier.getBoost(event.getPos().m_123342_(), level);
        if (factor > 0.0f) {
            event.setNewSpeed(event.getNewSpeed() * (1.0f + factor));
        }
    }

    @Override
    public void addInformation(IToolStackView tool, int level, @Nullable Player player, List<Component> tooltip, TooltipKey key, TooltipFlag tooltipFlag) {
        double boost;
        if (tool.hasTag((Tag<Item>)TinkerTags.Items.HARVEST) && (boost = player != null && key == TooltipKey.SHIFT ? (double)DwarvenModifier.getBoost((int)player.m_20186_(), level) : (double)(0.1f * (float)level)) > 0.0) {
            this.addPercentTooltip(MINING_SPEED, boost, tooltip);
        }
    }
}

