/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.mantle.recipe.helper.LoggingRecipeSerializer;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierRecipeLookup;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IncrementalModifierRecipe;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IncrementalModifierRecipeBuilder;
import slimeknights.tconstruct.library.recipe.modifiers.salvage.AbstractModifierSalvage;
import slimeknights.tconstruct.library.recipe.tinkerstation.IMutableTinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ModifierRemovalRecipe
implements ITinkerStationRecipe {
    private static final ValidatedResult NO_MODIFIERS = ValidatedResult.failure(TConstruct.makeTranslationKey("recipe", "remove_modifier.no_modifiers"), new Object[0]);
    private final ResourceLocation id;
    private final Ingredient ingredient;
    private final ItemStack container;

    @Override
    public boolean matches(ITinkerStationContainer inv, Level world) {
        if (!TinkerTags.Items.MODIFIABLE.m_8110_((Object)inv.getTinkerableStack().m_41720_())) {
            return false;
        }
        return IncrementalModifierRecipe.containsOnlyIngredient(inv, this.ingredient);
    }

    @Nullable
    private ModifierEntry getModifierToRemove(ITinkerStationContainer inv, List<ModifierEntry> modifiers) {
        int removeIndex = -1;
        for (int i = 0; i < inv.getInputCount(); ++i) {
            ItemStack stack = inv.getInput(i);
            if (stack.m_41619_() || !this.ingredient.test(stack)) continue;
            removeIndex += (i + 1) * stack.m_41613_();
        }
        if (removeIndex == -1) {
            return null;
        }
        removeIndex = removeIndex >= modifiers.size() ? 0 : modifiers.size() - removeIndex - 1;
        return modifiers.get(removeIndex);
    }

    @Override
    public ValidatedResult getValidatedResult(ITinkerStationContainer inv) {
        ValidatedResult validated;
        int newLevel;
        Modifier modifier;
        ItemStack toolStack = inv.getTinkerableStack();
        ToolStack tool = ToolStack.from(toolStack);
        List<ModifierEntry> modifiers = tool.getUpgrades().getModifiers();
        if (modifiers.isEmpty()) {
            return NO_MODIFIERS;
        }
        ModifierEntry toRemove = this.getModifierToRemove(inv, modifiers);
        if (toRemove == null) {
            return ValidatedResult.PASS;
        }
        AbstractModifierSalvage salvage = ModifierRecipeLookup.getSalvage(toolStack, tool = tool.copy(), modifier = toRemove.getModifier(), toRemove.getLevel());
        if (salvage != null) {
            salvage.updateTool(tool);
        }
        if ((newLevel = tool.getModifierLevel(modifier) - 1) <= 0) {
            modifier.beforeRemoved(tool, tool.getRestrictedNBT());
        }
        tool.removeModifier(modifier, 1);
        if (newLevel <= 0) {
            modifier.onRemoved(tool);
        }
        if ((validated = tool.validate()).hasError()) {
            return validated;
        }
        if (newLevel <= 0 && (validated = modifier.validate(tool, 0)).hasError()) {
            return validated;
        }
        ItemStack resultStack = tool.createStack(Math.min(toolStack.m_41613_(), this.shrinkToolSlotBy()));
        validated = ModifierRecipeLookup.checkRequirements(resultStack, tool);
        if (validated.hasError()) {
            return validated;
        }
        return ValidatedResult.success(resultStack);
    }

    @Override
    public int shrinkToolSlotBy() {
        return 64;
    }

    @Override
    public void updateInputs(ItemStack result, IMutableTinkerStationContainer inv, boolean isServer) {
        AbstractModifierSalvage salvage;
        ItemStack toolStack;
        ToolStack tool;
        ModifierEntry toRemove;
        if (isServer && (toRemove = this.getModifierToRemove(inv, (tool = ToolStack.from(toolStack = inv.getTinkerableStack())).getUpgrades().getModifiers())) != null && (salvage = ModifierRecipeLookup.getSalvage(toolStack, tool, toRemove.getModifier(), toRemove.getLevel())) != null) {
            int salvageMax = Math.min(toolStack.m_41741_(), salvage.getMaxToolSize());
            int currentSize = result.m_41613_();
            Consumer<ItemStack> consumer = currentSize < salvageMax ? stack -> {
                int newSize = stack.m_41613_() * currentSize / salvageMax;
                if (newSize > 0) {
                    stack.m_41764_(newSize);
                    inv.giveItem((ItemStack)stack);
                }
            } : (currentSize > salvageMax ? stack -> {
                int newSize;
                int maxStackSize = stack.m_41741_();
                for (newSize = stack.m_41613_() * currentSize / salvageMax; newSize > maxStackSize; newSize -= maxStackSize) {
                    inv.giveItem(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)maxStackSize));
                }
                if (newSize > 0) {
                    stack.m_41764_(newSize);
                    inv.giveItem((ItemStack)stack);
                }
            } : inv::giveItem);
            salvage.acceptItems(tool, consumer, TConstruct.RANDOM);
        }
        for (int i = 0; i < inv.getInputCount(); ++i) {
            ItemStack stack2 = inv.getInput(i);
            if (stack2.m_41619_() || !this.ingredient.test(stack2)) continue;
            inv.shrinkInput(i, 1, this.container.m_41777_());
            break;
        }
    }

    @Deprecated
    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerModifiers.removeModifierSerializer.get();
    }

    public ModifierRemovalRecipe(ResourceLocation id, Ingredient ingredient, ItemStack container) {
        this.id = id;
        this.ingredient = ingredient;
        this.container = container;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public static class Builder
    extends AbstractRecipeBuilder<Builder> {
        private final Ingredient ingredient;
        private final ItemStack container;

        public void save(Consumer<FinishedRecipe> consumer) {
            this.save(consumer, Objects.requireNonNull(this.container.m_41720_().getRegistryName()));
        }

        public void save(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
            if (this.ingredient == Ingredient.f_43901_) {
                throw new IllegalStateException("Empty ingredient not allowed");
            }
            ResourceLocation advancementId = this.buildOptionalAdvancement(id, "modifiers");
            consumer.accept((FinishedRecipe)new Finished(id, advancementId));
        }

        private Builder(Ingredient ingredient, ItemStack container) {
            this.ingredient = ingredient;
            this.container = container;
        }

        public static Builder removal(Ingredient ingredient, ItemStack container) {
            return new Builder(ingredient, container);
        }

        private class Finished
        extends AbstractRecipeBuilder.AbstractFinishedRecipe {
            public Finished(@Nullable ResourceLocation ID, ResourceLocation advancementID) {
                super((AbstractRecipeBuilder)Builder.this, ID, advancementID);
            }

            public void m_7917_(JsonObject json) {
                json.add("ingredient", Builder.this.ingredient.m_43942_());
                if (!Builder.this.container.m_41619_()) {
                    json.add("container", IncrementalModifierRecipeBuilder.serializeResult(Builder.this.container));
                }
            }

            public RecipeSerializer<?> m_6637_() {
                return (RecipeSerializer)TinkerModifiers.removeModifierSerializer.get();
            }
        }
    }

    public static class Serializer
    extends LoggingRecipeSerializer<ModifierRemovalRecipe> {
        public ModifierRemovalRecipe fromJson(ResourceLocation id, JsonObject json) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)JsonHelper.getElement((JsonObject)json, (String)"ingredient"));
            ItemStack container = ItemStack.f_41583_;
            if (json.has("container")) {
                container = IncrementalModifierRecipe.deseralizeResultItem(json, "container");
            }
            return new ModifierRemovalRecipe(id, ingredient, container);
        }

        @Nullable
        public ModifierRemovalRecipe fromNetworkSafe(ResourceLocation id, FriendlyByteBuf buffer) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack container = buffer.m_130267_();
            return new ModifierRemovalRecipe(id, ingredient, container);
        }

        public void toNetworkSafe(FriendlyByteBuf buffer, ModifierRemovalRecipe recipe) {
            recipe.ingredient.m_43923_(buffer);
            buffer.m_130055_(recipe.container);
        }
    }
}

