/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.worldgen.islands;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import slimeknights.tconstruct.world.worldgen.islands.AbstractIslandStructure;
import slimeknights.tconstruct.world.worldgen.islands.variants.IIslandVariant;
import slimeknights.tconstruct.world.worldgen.islands.variants.IslandVariants;

public class BloodSlimeIslandStructure
extends AbstractIslandStructure {
    private static final List<MobSpawnSettings.SpawnerData> STRUCTURE_MONSTERS = ImmutableList.of((Object)new MobSpawnSettings.SpawnerData(EntityType.f_20468_, 150, 4, 6));

    public BloodSlimeIslandStructure() {
        super(new AbstractIslandStructure.IIslandSettings(){

            @Override
            public IIslandVariant getVariant(Random random) {
                return IslandVariants.BLOOD;
            }

            @Override
            public int getHeight(ChunkPos chunkPos, ChunkGenerator generator, LevelHeightAccessor pLevel, Rotation rotation, Random random) {
                return Math.max(generator.m_6337_() - 7, 0);
            }
        });
    }

    @Override
    public GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.UNDERGROUND_DECORATION;
    }

    public List<MobSpawnSettings.SpawnerData> getDefaultSpawnList(MobCategory category) {
        return category == MobCategory.MONSTER ? STRUCTURE_MONSTERS : Collections.emptyList();
    }
}

