/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.worldgen.islands;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.worldgen.islands.AbstractIslandStructure;
import slimeknights.tconstruct.world.worldgen.islands.variants.IIslandVariant;
import slimeknights.tconstruct.world.worldgen.islands.variants.IslandVariants;

public class EarthSlimeIslandStructure
extends AbstractIslandStructure {
    private static final List<MobSpawnSettings.SpawnerData> MONSTERS = ImmutableList.of((Object)new MobSpawnSettings.SpawnerData((EntityType)TinkerWorld.earthSlimeEntity.get(), 30, 4, 4));

    public EarthSlimeIslandStructure() {
        super(new AbstractIslandStructure.IIslandSettings(){

            @Override
            public IIslandVariant getVariant(Random random) {
                return random.nextBoolean() ? IslandVariants.EARTH_BLUE : IslandVariants.EARTH_GREEN;
            }

            @Override
            public int getHeight(ChunkPos chunkPos, ChunkGenerator generator, LevelHeightAccessor pLevel, Rotation rotation, Random random) {
                return Math.max(generator.m_6337_() - 7, 0);
            }
        });
    }

    public List<MobSpawnSettings.SpawnerData> getDefaultSpawnList(MobCategory category) {
        return category == MobCategory.MONSTER ? MONSTERS : Collections.emptyList();
    }
}

