/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.inventoryessentials.network;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class SingleTransferMessage {
    private final int slotNumber;

    public SingleTransferMessage(int slotNumber) {
        this.slotNumber = slotNumber;
    }

    public static SingleTransferMessage decode(FriendlyByteBuf buf) {
        byte slotNumber = buf.readByte();
        return new SingleTransferMessage(slotNumber);
    }

    public static void encode(SingleTransferMessage message, FriendlyByteBuf buf) {
        buf.writeByte(message.slotNumber);
    }

    public static void handle(ServerPlayer player, SingleTransferMessage message) {
        AbstractContainerMenu menu = player.f_36096_;
        if (menu != null && message.slotNumber >= 0 && message.slotNumber < menu.f_38839_.size()) {
            Slot slot = (Slot)menu.f_38839_.get(message.slotNumber);
            if (!slot.m_8010_((Player)player)) {
                return;
            }
            ItemStack sourceStack = slot.m_7993_();
            if (sourceStack.m_41613_() == 1) {
                menu.m_150399_(message.slotNumber, 0, ClickType.QUICK_MOVE, (Player)player);
            } else if (!sourceStack.m_41619_()) {
                ItemStack copyStack = sourceStack.m_41777_();
                sourceStack.m_41764_(1);
                copyStack.m_41774_(1);
                menu.m_150399_(message.slotNumber, 0, ClickType.QUICK_MOVE, (Player)player);
                if (!slot.m_6657_()) {
                    slot.m_5852_(copyStack);
                } else if (!player.m_36356_(copyStack)) {
                    player.m_36176_(copyStack, false);
                }
            }
        }
    }
}

